/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-11-26 14:40:52 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=862 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=27171 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=2559 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_e_notes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `route_url` text DEFAULT NULL COMMENT 'Clean url where the note was created.',
  `route_title` varchar(255) DEFAULT NULL,
  `route_post_id` bigint(20) unsigned DEFAULT NULL COMMENT 'The post id of the route that the note was created on.',
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `element_id` varchar(60) DEFAULT NULL COMMENT 'The Elementor element ID the note is attached to.',
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `author_id` bigint(20) unsigned DEFAULT NULL,
  `author_display_name` varchar(250) DEFAULT NULL COMMENT 'Save the author name when the author was deleted.',
  `status` varchar(20) NOT NULL DEFAULT 'publish',
  `position` text DEFAULT NULL COMMENT 'A JSON string that represents the position of the note inside the element in percentages. e.g. {x:10, y:15}',
  `content` longtext DEFAULT NULL,
  `is_resolved` tinyint(1) NOT NULL DEFAULT 0,
  `is_public` tinyint(1) NOT NULL DEFAULT 1,
  `last_activity_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `route_url_index` (`route_url`(191)),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `parent_id_index` (`parent_id`),
  KEY `author_id_index` (`author_id`),
  KEY `status_index` (`status`),
  KEY `is_resolved_index` (`is_resolved`),
  KEY `is_public_index` (`is_public`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `last_activity_at_index` (`last_activity_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_notes_users_relations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) NOT NULL COMMENT 'The relation type between user and note (e.g mention, watch, read).',
  `note_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`),
  KEY `note_id_index` (`note_id`),
  KEY `user_id_index` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) DEFAULT NULL,
  `hash_id` varchar(60) NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) NOT NULL,
  `referer_title` varchar(300) DEFAULT NULL,
  `element_id` varchar(20) NOT NULL,
  `form_name` varchar(60) NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) NOT NULL,
  `user_agent` text NOT NULL,
  `actions_count` int(11) DEFAULT 0,
  `actions_succeeded_count` int(11) DEFAULT 0,
  `status` varchar(20) NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `meta` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=MyISAM AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) NOT NULL,
  `action_label` varchar(60) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `log` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=MyISAM AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `key` varchar(60) DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=MyISAM AUTO_INCREMENT=248 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gf_draft_submissions` (
  `uuid` char(32) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `form_id` mediumint(10) unsigned NOT NULL,
  `date_created` datetime NOT NULL,
  `ip` varchar(45) NOT NULL,
  `source_url` longtext NOT NULL,
  `submission` longtext NOT NULL,
  PRIMARY KEY (`uuid`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gf_entry` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL,
  `post_id` bigint(10) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `date_updated` datetime DEFAULT NULL,
  `is_starred` tinyint(10) NOT NULL DEFAULT 0,
  `is_read` tinyint(10) NOT NULL DEFAULT 0,
  `ip` varchar(45) NOT NULL,
  `source_url` varchar(200) NOT NULL DEFAULT '',
  `user_agent` varchar(250) NOT NULL DEFAULT '',
  `currency` varchar(5) DEFAULT NULL,
  `payment_status` varchar(15) DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_amount` decimal(19,2) DEFAULT NULL,
  `payment_method` varchar(30) DEFAULT NULL,
  `transaction_id` varchar(50) DEFAULT NULL,
  `is_fulfilled` tinyint(10) DEFAULT NULL,
  `created_by` bigint(10) unsigned DEFAULT NULL,
  `transaction_type` tinyint(10) DEFAULT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `form_id_status` (`form_id`,`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gf_entry_meta` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL DEFAULT 0,
  `entry_id` bigint(10) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  `item_index` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `entry_id` (`entry_id`),
  KEY `meta_value` (`meta_value`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gf_entry_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `entry_id` int(10) unsigned NOT NULL,
  `user_name` varchar(250) DEFAULT NULL,
  `user_id` bigint(10) DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `value` longtext DEFAULT NULL,
  `note_type` varchar(50) DEFAULT NULL,
  `sub_type` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `entry_id` (`entry_id`),
  KEY `entry_user_key` (`entry_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gf_form` (
  `id` mediumint(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(150) NOT NULL,
  `date_created` datetime NOT NULL,
  `date_updated` datetime DEFAULT NULL,
  `is_active` tinyint(10) NOT NULL DEFAULT 1,
  `is_trash` tinyint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gf_form_meta` (
  `form_id` mediumint(10) unsigned NOT NULL,
  `display_meta` longtext DEFAULT NULL,
  `entries_grid_meta` longtext DEFAULT NULL,
  `confirmations` longtext DEFAULT NULL,
  `notifications` longtext DEFAULT NULL,
  PRIMARY KEY (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gf_form_revisions` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL,
  `display_meta` longtext DEFAULT NULL,
  `date_created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gf_form_view` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL,
  `date_created` datetime NOT NULL,
  `ip` char(15) DEFAULT NULL,
  `count` mediumint(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_custom_fields` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL,
  `type` varchar(90) NOT NULL,
  `params` longtext NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_dynamic_segment_filters` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `segment_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `filter_data` longblob DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `segment_id` (`segment_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_feature_flags` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `value` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_forms` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'enabled',
  `body` longtext DEFAULT NULL,
  `settings` longtext DEFAULT NULL,
  `styles` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `level` int(11) DEFAULT NULL,
  `message` longtext DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_mapping_to_external_entities` (
  `old_id` int(11) unsigned NOT NULL,
  `type` varchar(50) NOT NULL,
  `new_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`old_id`,`type`),
  KEY `new_id` (`new_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_newsletter_links` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `url` varchar(2083) NOT NULL,
  `hash` varchar(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `newsletter_id` (`newsletter_id`),
  KEY `queue_id` (`queue_id`),
  KEY `url` (`url`(100))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_newsletter_option` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `option_field_id` int(11) unsigned NOT NULL,
  `value` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `newsletter_id_option_field_id` (`newsletter_id`,`option_field_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_newsletter_option_fields` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL,
  `newsletter_type` varchar(90) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name_newsletter_type` (`newsletter_type`,`name`)
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_newsletter_posts` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `post_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `newsletter_id` (`newsletter_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_newsletter_segment` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `segment_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `newsletter_segment` (`newsletter_id`,`segment_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_newsletter_templates` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) DEFAULT 0,
  `name` varchar(250) NOT NULL,
  `categories` varchar(250) NOT NULL DEFAULT '[]',
  `description` varchar(255) NOT NULL DEFAULT '',
  `body` longtext DEFAULT NULL,
  `thumbnail` longtext DEFAULT NULL,
  `readonly` tinyint(1) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=75 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_newsletters` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `hash` varchar(150) DEFAULT NULL,
  `parent_id` int(11) unsigned DEFAULT NULL,
  `subject` varchar(250) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT 'standard',
  `sender_address` varchar(150) NOT NULL DEFAULT '',
  `sender_name` varchar(150) NOT NULL DEFAULT '',
  `status` varchar(20) NOT NULL DEFAULT 'draft',
  `reply_to_address` varchar(150) NOT NULL DEFAULT '',
  `reply_to_name` varchar(150) NOT NULL DEFAULT '',
  `preheader` varchar(250) NOT NULL DEFAULT '',
  `body` longtext DEFAULT NULL,
  `sent_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  `unsubscribe_token` char(15) DEFAULT NULL,
  `ga_campaign` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unsubscribe_token` (`unsubscribe_token`),
  KEY `type_status` (`type`,`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_scheduled_task_subscribers` (
  `task_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `processed` int(1) NOT NULL,
  `failed` smallint(1) NOT NULL DEFAULT 0,
  `error` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`task_id`,`subscriber_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_scheduled_tasks` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(90) DEFAULT NULL,
  `status` varchar(12) DEFAULT NULL,
  `priority` mediumint(9) NOT NULL DEFAULT 0,
  `scheduled_at` timestamp NULL DEFAULT NULL,
  `processed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  `in_progress` int(1) DEFAULT NULL,
  `reschedule_count` int(11) NOT NULL DEFAULT 0,
  `meta` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_segments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL,
  `type` varchar(90) NOT NULL DEFAULT 'default',
  `description` varchar(250) NOT NULL DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  `average_engagement_score` float unsigned DEFAULT NULL,
  `average_engagement_score_updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `average_engagement_score_updated_at` (`average_engagement_score_updated_at`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_sending_queues` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `task_id` int(11) unsigned NOT NULL,
  `newsletter_id` int(11) unsigned NOT NULL,
  `newsletter_rendered_body` longtext DEFAULT NULL,
  `newsletter_rendered_subject` varchar(250) DEFAULT NULL,
  `subscribers` longtext DEFAULT NULL,
  `count_total` int(11) unsigned NOT NULL DEFAULT 0,
  `count_processed` int(11) unsigned NOT NULL DEFAULT 0,
  `count_to_process` int(11) unsigned NOT NULL DEFAULT 0,
  `meta` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_id` (`task_id`),
  KEY `newsletter_id` (`newsletter_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_settings` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `value` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_statistics_bounces` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_statistics_clicks` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `link_id` int(11) unsigned NOT NULL,
  `user_agent_id` int(11) unsigned DEFAULT NULL,
  `user_agent_type` tinyint(1) NOT NULL DEFAULT 0,
  `count` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `newsletter_id_subscriber_id_user_agent_type` (`newsletter_id`,`subscriber_id`,`user_agent_type`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_statistics_forms` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `form_subscriber` (`form_id`,`subscriber_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_statistics_newsletters` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `sent_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `newsletter_id` (`newsletter_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_statistics_opens` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `user_agent_id` int(11) unsigned DEFAULT NULL,
  `user_agent_type` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `newsletter_id_subscriber_id_user_agent_type` (`newsletter_id`,`subscriber_id`,`user_agent_type`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`),
  KEY `created_at` (`created_at`),
  KEY `subscriber_id_created_at` (`subscriber_id`,`created_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_statistics_unsubscribes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned DEFAULT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `source` varchar(255) DEFAULT 'unknown',
  `meta` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `newsletter_id_subscriber_id` (`newsletter_id`,`subscriber_id`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_statistics_woocommerce_purchases` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `click_id` int(11) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `order_currency` char(3) NOT NULL,
  `order_price_total` float NOT NULL COMMENT 'With shipping and taxes in order_currency',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `click_id_order_id` (`click_id`,`order_id`),
  KEY `newsletter_id` (`newsletter_id`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_stats_notifications` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `task_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `newsletter_id_task_id` (`newsletter_id`,`task_id`),
  KEY `task_id` (`task_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_subscriber_custom_field` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` int(11) unsigned NOT NULL,
  `custom_field_id` int(11) unsigned NOT NULL,
  `value` text NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscriber_id_custom_field_id` (`subscriber_id`,`custom_field_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_subscriber_ips` (
  `ip` varchar(45) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`created_at`,`ip`),
  KEY `ip` (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_subscriber_segment` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` int(11) unsigned NOT NULL,
  `segment_id` int(11) unsigned NOT NULL,
  `status` varchar(12) NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscriber_segment` (`subscriber_id`,`segment_id`),
  KEY `segment_id` (`segment_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_subscribers` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `wp_user_id` bigint(20) DEFAULT NULL,
  `is_woocommerce_user` int(1) NOT NULL DEFAULT 0,
  `first_name` varchar(255) NOT NULL DEFAULT '',
  `last_name` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(150) NOT NULL,
  `status` varchar(12) NOT NULL DEFAULT 'unconfirmed',
  `subscribed_ip` varchar(45) DEFAULT NULL,
  `confirmed_ip` varchar(45) DEFAULT NULL,
  `confirmed_at` timestamp NULL DEFAULT NULL,
  `last_subscribed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  `unconfirmed_data` longtext DEFAULT NULL,
  `source` enum('form','imported','administrator','api','wordpress_user','woocommerce_user','woocommerce_checkout','unknown') DEFAULT 'unknown',
  `count_confirmations` int(11) unsigned NOT NULL DEFAULT 0,
  `unsubscribe_token` char(15) DEFAULT NULL,
  `link_token` char(32) DEFAULT NULL,
  `engagement_score` float unsigned DEFAULT NULL,
  `engagement_score_updated_at` timestamp NULL DEFAULT NULL,
  `last_engagement_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  UNIQUE KEY `unsubscribe_token` (`unsubscribe_token`),
  KEY `wp_user_id` (`wp_user_id`),
  KEY `updated_at` (`updated_at`),
  KEY `status_deleted_at` (`status`,`deleted_at`),
  KEY `last_subscribed_at` (`last_subscribed_at`),
  KEY `engagement_score_updated_at` (`engagement_score_updated_at`),
  KEY `link_token` (`link_token`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_user_agents` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `hash` varchar(32) NOT NULL,
  `user_agent` text NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash` (`hash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_user_flags` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id_name` (`user_id`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=85193 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=29353 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=3204 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=203 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT 0,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=323 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=414 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("793", "woocommerce_cleanup_draft_orders", "complete", "2024-11-01 16:49:30", "2024-11-01 20:19:30", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730479770;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730479770;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-11-01 22:19:20", "2024-11-02 01:49:20", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("807", "woocommerce_cleanup_draft_orders", "complete", "2024-11-16 22:32:45", "2024-11-17 02:02:45", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1731796365;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1731796365;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-11-17 00:58:39", "2024-11-17 04:28:39", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("815", "woocommerce_cleanup_draft_orders", "complete", "2024-11-25 11:26:23", "2024-11-25 14:56:23", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732533983;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732533983;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-11-25 11:36:39", "2024-11-25 15:06:39", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("816", "woocommerce_cleanup_draft_orders", "complete", "2024-11-26 11:36:39", "2024-11-26 15:06:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732620999;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732620999;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-11-26 11:57:24", "2024-11-26 15:27:24", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("796", "woocommerce_cleanup_draft_orders", "complete", "2024-11-05 08:08:03", "2024-11-05 11:38:03", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730794083;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730794083;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-11-05 08:09:02", "2024-11-05 11:39:02", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("797", "woocommerce_cleanup_draft_orders", "complete", "2024-11-06 08:09:02", "2024-11-06 11:39:02", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730880542;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730880542;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-11-06 08:59:31", "2024-11-06 12:29:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("798", "woocommerce_cleanup_draft_orders", "complete", "2024-11-07 08:59:31", "2024-11-07 12:29:31", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730969971;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730969971;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-11-07 09:50:28", "2024-11-07 13:20:28", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("800", "woocommerce_cleanup_draft_orders", "complete", "2024-11-09 11:06:23", "2024-11-09 14:36:23", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1731150383;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1731150383;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-11-09 13:03:08", "2024-11-09 16:33:08", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("808", "woocommerce_cleanup_draft_orders", "complete", "2024-11-18 00:58:39", "2024-11-18 04:28:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1731891519;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1731891519;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-11-18 04:30:51", "2024-11-18 08:00:51", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("817", "woocommerce_cleanup_draft_orders", "pending", "2024-11-27 11:57:24", "2024-11-27 15:27:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732708644;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732708644;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("788", "woocommerce_cleanup_draft_orders", "complete", "2024-10-27 10:21:09", "2024-10-27 13:51:09", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730024469;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730024469;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-10-27 11:38:39", "2024-10-27 15:08:39", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("789", "woocommerce_cleanup_draft_orders", "complete", "2024-10-28 11:38:39", "2024-10-28 15:08:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730115519;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730115519;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-10-28 12:09:49", "2024-10-28 15:39:49", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("790", "woocommerce_cleanup_draft_orders", "complete", "2024-10-29 12:09:49", "2024-10-29 15:39:49", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730203789;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730203789;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-10-29 12:49:53", "2024-10-29 16:19:53", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("791", "woocommerce_cleanup_draft_orders", "complete", "2024-10-30 12:49:53", "2024-10-30 16:19:53", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730292593;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730292593;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-10-30 13:15:53", "2024-10-30 16:45:53", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("792", "woocommerce_cleanup_draft_orders", "complete", "2024-10-31 13:15:53", "2024-10-31 16:45:53", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730380553;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730380553;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-10-31 16:49:30", "2024-10-31 20:19:30", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("794", "woocommerce_cleanup_draft_orders", "complete", "2024-11-02 22:19:20", "2024-11-03 01:49:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730585960;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730585960;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-11-02 23:14:31", "2024-11-03 02:44:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("795", "woocommerce_cleanup_draft_orders", "complete", "2024-11-03 23:14:31", "2024-11-04 02:44:31", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1730675671;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1730675671;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-11-04 08:08:03", "2024-11-04 11:38:03", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("799", "woocommerce_cleanup_draft_orders", "complete", "2024-11-08 09:50:28", "2024-11-08 13:20:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1731059428;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1731059428;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-11-08 11:06:23", "2024-11-08 14:36:23", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("801", "woocommerce_cleanup_draft_orders", "complete", "2024-11-10 13:03:08", "2024-11-10 16:33:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1731243788;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1731243788;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-11-10 13:04:36", "2024-11-10 16:34:36", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("802", "woocommerce_cleanup_draft_orders", "complete", "2024-11-11 13:04:36", "2024-11-11 16:34:36", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1731330276;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1731330276;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-11-11 14:03:05", "2024-11-11 17:33:05", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("803", "woocommerce_cleanup_draft_orders", "complete", "2024-11-12 14:03:05", "2024-11-12 17:33:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1731420185;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1731420185;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-11-12 16:23:11", "2024-11-12 19:53:11", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("804", "woocommerce_cleanup_draft_orders", "complete", "2024-11-13 16:23:11", "2024-11-13 19:53:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1731514991;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1731514991;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-11-13 16:58:45", "2024-11-13 20:28:45", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("805", "woocommerce_cleanup_draft_orders", "complete", "2024-11-14 16:58:45", "2024-11-14 20:28:45", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1731603525;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1731603525;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-11-14 19:54:08", "2024-11-14 23:24:08", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("806", "woocommerce_cleanup_draft_orders", "complete", "2024-11-15 19:54:08", "2024-11-15 23:24:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1731700448;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1731700448;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-11-15 22:32:45", "2024-11-16 02:02:45", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("809", "woocommerce_cleanup_draft_orders", "complete", "2024-11-19 04:30:51", "2024-11-19 08:00:51", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1731990651;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1731990651;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-11-19 08:19:49", "2024-11-19 11:49:49", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("810", "woocommerce_cleanup_draft_orders", "complete", "2024-11-20 08:19:49", "2024-11-20 11:49:49", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732090789;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732090789;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-11-20 08:40:56", "2024-11-20 12:10:56", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("811", "woocommerce_cleanup_draft_orders", "complete", "2024-11-21 08:40:56", "2024-11-21 12:10:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732178456;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732178456;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-11-21 10:54:12", "2024-11-21 14:24:12", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("812", "woocommerce_cleanup_draft_orders", "complete", "2024-11-22 10:54:12", "2024-11-22 14:24:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732272852;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732272852;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-11-22 11:00:35", "2024-11-22 14:30:35", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("813", "woocommerce_cleanup_draft_orders", "complete", "2024-11-23 11:00:35", "2024-11-23 14:30:35", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732359635;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732359635;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-11-23 11:22:34", "2024-11-23 14:52:34", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("814", "woocommerce_cleanup_draft_orders", "complete", "2024-11-24 11:22:34", "2024-11-24 14:52:34", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732447354;s:18:\"\0*\0first_timestamp\";i:1662266958;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732447354;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "0", "1", "2024-11-24 11:26:23", "2024-11-24 14:56:23", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("818", "wc-admin_import_customers", "complete", "2024-11-26 14:29:37", "2024-11-26 17:59:37", "[3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631377;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631377;}", "2", "1", "2024-11-26 14:30:38", "2024-11-26 18:00:38", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("819", "woocommerce_run_product_attribute_lookup_regeneration_callback", "complete", "2024-11-26 14:31:11", "2024-11-26 18:01:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631471;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631471;}", "3", "1", "2024-11-26 14:32:26", "2024-11-26 18:02:26", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("820", "woocommerce_run_update_callback", "complete", "2024-11-26 14:34:41", "2024-11-26 18:04:41", "{\"update_callback\":\"wc_update_721_adjust_new_zealand_states\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631681;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631681;}", "3", "1", "2024-11-26 14:34:42", "2024-11-26 18:04:42", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("821", "woocommerce_run_update_callback", "complete", "2024-11-26 14:34:42", "2024-11-26 18:04:42", "{\"update_callback\":\"wc_update_721_adjust_ukraine_states\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631682;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631682;}", "3", "1", "2024-11-26 14:34:42", "2024-11-26 18:04:42", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("822", "woocommerce_run_update_callback", "complete", "2024-11-26 14:34:43", "2024-11-26 18:04:43", "{\"update_callback\":\"wc_update_722_adjust_new_zealand_states\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631683;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631683;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("823", "woocommerce_run_update_callback", "complete", "2024-11-26 14:34:44", "2024-11-26 18:04:44", "{\"update_callback\":\"wc_update_722_adjust_ukraine_states\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631684;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631684;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("824", "woocommerce_run_update_callback", "complete", "2024-11-26 14:34:45", "2024-11-26 18:04:45", "{\"update_callback\":\"wc_update_750_add_columns_to_order_stats_table\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631685;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631685;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("825", "woocommerce_run_update_callback", "complete", "2024-11-26 14:34:46", "2024-11-26 18:04:46", "{\"update_callback\":\"wc_update_750_disable_new_product_management_experience\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631686;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631686;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("826", "woocommerce_run_update_callback", "complete", "2024-11-26 14:34:47", "2024-11-26 18:04:47", "{\"update_callback\":\"wc_update_770_remove_multichannel_marketing_feature_options\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631687;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631687;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("827", "woocommerce_run_update_callback", "complete", "2024-11-26 14:34:48", "2024-11-26 18:04:48", "{\"update_callback\":\"wc_update_810_migrate_transactional_metadata_for_hpos\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631688;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631688;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("828", "woocommerce_run_update_callback", "complete", "2024-11-26 14:34:49", "2024-11-26 18:04:49", "{\"update_callback\":\"wc_update_860_remove_recommended_marketing_plugins_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631689;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631689;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("829", "woocommerce_run_update_callback", "complete", "2024-11-26 14:34:50", "2024-11-26 18:04:50", "{\"update_callback\":\"wc_update_870_prevent_listing_of_transient_files_directory\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631690;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631690;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("830", "woocommerce_run_update_callback", "complete", "2024-11-26 14:34:51", "2024-11-26 18:04:51", "{\"update_callback\":\"wc_update_890_update_connect_to_woocommerce_note\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631691;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631691;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("831", "woocommerce_run_update_callback", "complete", "2024-11-26 14:34:52", "2024-11-26 18:04:52", "{\"update_callback\":\"wc_update_890_update_paypal_standard_load_eligibility\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631692;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631692;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("832", "woocommerce_run_update_callback", "complete", "2024-11-26 14:34:53", "2024-11-26 18:04:53", "{\"update_callback\":\"wc_update_891_create_plugin_autoinstall_history_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631693;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631693;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("833", "woocommerce_run_update_callback", "complete", "2024-11-26 14:34:54", "2024-11-26 18:04:54", "{\"update_callback\":\"wc_update_910_add_launch_your_store_tour_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631694;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631694;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("834", "woocommerce_run_update_callback", "complete", "2024-11-26 14:34:55", "2024-11-26 18:04:55", "{\"update_callback\":\"wc_update_910_remove_obsolete_user_meta\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631695;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631695;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("835", "woocommerce_run_update_callback", "complete", "2024-11-26 14:34:56", "2024-11-26 18:04:56", "{\"update_callback\":\"wc_update_920_add_wc_hooked_blocks_version_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631696;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631696;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("836", "woocommerce_run_update_callback", "complete", "2024-11-26 14:34:57", "2024-11-26 18:04:57", "{\"update_callback\":\"wc_update_930_add_woocommerce_coming_soon_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631697;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631697;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("837", "woocommerce_run_update_callback", "complete", "2024-11-26 14:34:58", "2024-11-26 18:04:58", "{\"update_callback\":\"wc_update_930_migrate_user_meta_for_launch_your_store_tour\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631698;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631698;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("838", "woocommerce_run_update_callback", "complete", "2024-11-26 14:34:59", "2024-11-26 18:04:59", "{\"update_callback\":\"wc_update_940_add_phone_to_order_address_fts_index\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631699;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631699;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("839", "woocommerce_run_update_callback", "complete", "2024-11-26 14:35:00", "2024-11-26 18:05:00", "{\"update_callback\":\"wc_update_940_remove_help_panel_highlight_shown\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631700;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631700;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("840", "woocommerce_update_db_to_current_version", "complete", "2024-11-26 14:35:01", "2024-11-26 18:05:01", "{\"version\":\"9.4.2\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631701;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631701;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("841", "woocommerce_run_update_callback", "complete", "2024-11-26 14:35:01", "2024-11-26 18:05:01", "{\"update_callback\":\"wc_update_721_adjust_new_zealand_states\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631701;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631701;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("842", "woocommerce_run_update_callback", "complete", "2024-11-26 14:35:02", "2024-11-26 18:05:02", "{\"update_callback\":\"wc_update_721_adjust_ukraine_states\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631702;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631702;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("843", "woocommerce_run_update_callback", "complete", "2024-11-26 14:35:03", "2024-11-26 18:05:03", "{\"update_callback\":\"wc_update_722_adjust_new_zealand_states\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631703;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631703;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("844", "woocommerce_run_update_callback", "complete", "2024-11-26 14:35:04", "2024-11-26 18:05:04", "{\"update_callback\":\"wc_update_722_adjust_ukraine_states\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631704;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631704;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("845", "woocommerce_run_update_callback", "complete", "2024-11-26 14:35:05", "2024-11-26 18:05:05", "{\"update_callback\":\"wc_update_750_add_columns_to_order_stats_table\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631705;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631705;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("846", "woocommerce_run_update_callback", "complete", "2024-11-26 14:35:06", "2024-11-26 18:05:06", "{\"update_callback\":\"wc_update_750_disable_new_product_management_experience\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631706;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631706;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("847", "woocommerce_run_update_callback", "complete", "2024-11-26 14:35:07", "2024-11-26 18:05:07", "{\"update_callback\":\"wc_update_770_remove_multichannel_marketing_feature_options\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631707;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631707;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("848", "woocommerce_run_update_callback", "complete", "2024-11-26 14:35:08", "2024-11-26 18:05:08", "{\"update_callback\":\"wc_update_810_migrate_transactional_metadata_for_hpos\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631708;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631708;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("849", "woocommerce_run_update_callback", "complete", "2024-11-26 14:35:09", "2024-11-26 18:05:09", "{\"update_callback\":\"wc_update_860_remove_recommended_marketing_plugins_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631709;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631709;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("850", "woocommerce_run_update_callback", "complete", "2024-11-26 14:35:10", "2024-11-26 18:05:10", "{\"update_callback\":\"wc_update_870_prevent_listing_of_transient_files_directory\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631710;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631710;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("851", "woocommerce_run_update_callback", "complete", "2024-11-26 14:35:11", "2024-11-26 18:05:11", "{\"update_callback\":\"wc_update_890_update_connect_to_woocommerce_note\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631711;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631711;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("852", "woocommerce_run_update_callback", "complete", "2024-11-26 14:35:12", "2024-11-26 18:05:12", "{\"update_callback\":\"wc_update_890_update_paypal_standard_load_eligibility\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631712;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631712;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("853", "woocommerce_run_update_callback", "complete", "2024-11-26 14:35:13", "2024-11-26 18:05:13", "{\"update_callback\":\"wc_update_891_create_plugin_autoinstall_history_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631713;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631713;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("854", "woocommerce_run_update_callback", "complete", "2024-11-26 14:35:14", "2024-11-26 18:05:14", "{\"update_callback\":\"wc_update_910_add_launch_your_store_tour_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631714;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631714;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("855", "woocommerce_run_update_callback", "complete", "2024-11-26 14:35:15", "2024-11-26 18:05:15", "{\"update_callback\":\"wc_update_910_remove_obsolete_user_meta\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631715;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631715;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("856", "woocommerce_run_update_callback", "complete", "2024-11-26 14:35:16", "2024-11-26 18:05:16", "{\"update_callback\":\"wc_update_920_add_wc_hooked_blocks_version_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631716;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631716;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("857", "woocommerce_run_update_callback", "complete", "2024-11-26 14:35:17", "2024-11-26 18:05:17", "{\"update_callback\":\"wc_update_930_add_woocommerce_coming_soon_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631717;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631717;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("858", "woocommerce_run_update_callback", "complete", "2024-11-26 14:35:18", "2024-11-26 18:05:18", "{\"update_callback\":\"wc_update_930_migrate_user_meta_for_launch_your_store_tour\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631718;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631718;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("859", "woocommerce_run_update_callback", "complete", "2024-11-26 14:35:19", "2024-11-26 18:05:19", "{\"update_callback\":\"wc_update_940_add_phone_to_order_address_fts_index\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631719;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631719;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("860", "woocommerce_run_update_callback", "complete", "2024-11-26 14:35:20", "2024-11-26 18:05:20", "{\"update_callback\":\"wc_update_940_remove_help_panel_highlight_shown\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732631720;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732631720;}", "3", "1", "2024-11-26 14:35:40", "2024-11-26 18:05:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("861", "action_scheduler/migration_hook", "pending", "2024-11-26 14:41:30", "2024-11-26 18:11:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732632090;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732632090;}", "1", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "wc-admin-data");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "woocommerce-db-updates");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("2356", "793", "ایجاد فعالیت", "2024-10-31 16:49:30", "2024-10-31 20:19:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2355", "792", "عملیات توسط WP Cron کامل شد", "2024-10-31 16:49:30", "2024-10-31 20:19:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2354", "792", "عملیات توسط WP Cron شروع شد", "2024-10-31 16:49:30", "2024-10-31 20:19:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2398", "807", "action created", "2024-11-15 22:32:45", "2024-11-16 02:02:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2401", "808", "action created", "2024-11-17 00:58:39", "2024-11-17 04:28:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2400", "807", "action complete via WP Cron", "2024-11-17 00:58:39", "2024-11-17 04:28:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2422", "815", "action created", "2024-11-24 11:26:23", "2024-11-24 14:56:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("2425", "816", "action created", "2024-11-25 11:36:39", "2024-11-25 15:06:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2421", "814", "action complete via WP Cron", "2024-11-24 11:26:23", "2024-11-24 14:56:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("2420", "814", "action started via WP Cron", "2024-11-24 11:26:23", "2024-11-24 14:56:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("2365", "796", "ایجاد فعالیت", "2024-11-04 08:08:03", "2024-11-04 11:38:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("2364", "795", "عملیات توسط WP Cron کامل شد", "2024-11-04 08:08:03", "2024-11-04 11:38:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("2363", "795", "عملیات توسط WP Cron شروع شد", "2024-11-04 08:08:03", "2024-11-04 11:38:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("2368", "797", "ایجاد فعالیت", "2024-11-05 08:09:02", "2024-11-05 11:39:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("2367", "796", "عملیات توسط WP Cron کامل شد", "2024-11-05 08:09:02", "2024-11-05 11:39:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("2366", "796", "عملیات توسط WP Cron شروع شد", "2024-11-05 08:09:02", "2024-11-05 11:39:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("2371", "798", "ایجاد فعالیت", "2024-11-06 08:59:31", "2024-11-06 12:29:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2370", "797", "عملیات توسط WP Cron کامل شد", "2024-11-06 08:59:31", "2024-11-06 12:29:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2369", "797", "عملیات توسط WP Cron شروع شد", "2024-11-06 08:59:31", "2024-11-06 12:29:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2377", "800", "ایجاد فعالیت", "2024-11-08 11:06:23", "2024-11-08 14:36:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("2376", "799", "عملیات توسط WP Cron کامل شد", "2024-11-08 11:06:23", "2024-11-08 14:36:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("2375", "799", "عملیات توسط WP Cron شروع شد", "2024-11-08 11:06:23", "2024-11-08 14:36:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("2397", "806", "action complete via WP Cron", "2024-11-15 22:32:45", "2024-11-16 02:02:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2396", "806", "action started via WP Cron", "2024-11-15 22:32:45", "2024-11-16 02:02:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2399", "807", "action started via WP Cron", "2024-11-17 00:58:39", "2024-11-17 04:28:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2424", "815", "action complete via WP Cron", "2024-11-25 11:36:39", "2024-11-25 15:06:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2423", "815", "action started via WP Cron", "2024-11-25 11:36:39", "2024-11-25 15:06:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2428", "817", "action created", "2024-11-26 11:57:24", "2024-11-26 15:27:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("2427", "816", "action complete via WP Cron", "2024-11-26 11:57:24", "2024-11-26 15:27:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("2426", "816", "action started via WP Cron", "2024-11-26 11:57:24", "2024-11-26 15:27:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("2341", "788", "ایجاد فعالیت", "2024-10-26 10:21:09", "2024-10-26 13:51:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("2342", "788", "عملیات توسط WP Cron شروع شد", "2024-10-27 11:38:39", "2024-10-27 15:08:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2343", "788", "عملیات توسط WP Cron کامل شد", "2024-10-27 11:38:39", "2024-10-27 15:08:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2344", "789", "ایجاد فعالیت", "2024-10-27 11:38:39", "2024-10-27 15:08:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2345", "789", "عملیات توسط WP Cron شروع شد", "2024-10-28 12:09:49", "2024-10-28 15:39:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("2346", "789", "عملیات توسط WP Cron کامل شد", "2024-10-28 12:09:49", "2024-10-28 15:39:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("2347", "790", "ایجاد فعالیت", "2024-10-28 12:09:49", "2024-10-28 15:39:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("2348", "790", "عملیات توسط WP Cron شروع شد", "2024-10-29 12:49:53", "2024-10-29 16:19:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2349", "790", "عملیات توسط WP Cron کامل شد", "2024-10-29 12:49:53", "2024-10-29 16:19:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2350", "791", "ایجاد فعالیت", "2024-10-29 12:49:53", "2024-10-29 16:19:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2351", "791", "عملیات توسط WP Cron شروع شد", "2024-10-30 13:15:53", "2024-10-30 16:45:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2352", "791", "عملیات توسط WP Cron کامل شد", "2024-10-30 13:15:53", "2024-10-30 16:45:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2353", "792", "ایجاد فعالیت", "2024-10-30 13:15:53", "2024-10-30 16:45:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2357", "793", "عملیات توسط WP Cron شروع شد", "2024-11-01 22:19:20", "2024-11-02 01:49:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2358", "793", "عملیات توسط WP Cron کامل شد", "2024-11-01 22:19:20", "2024-11-02 01:49:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2359", "794", "ایجاد فعالیت", "2024-11-01 22:19:20", "2024-11-02 01:49:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2360", "794", "عملیات توسط WP Cron شروع شد", "2024-11-02 23:14:31", "2024-11-03 02:44:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2361", "794", "عملیات توسط WP Cron کامل شد", "2024-11-02 23:14:31", "2024-11-03 02:44:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2362", "795", "ایجاد فعالیت", "2024-11-02 23:14:31", "2024-11-03 02:44:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2372", "798", "عملیات توسط WP Cron شروع شد", "2024-11-07 09:50:28", "2024-11-07 13:20:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2373", "798", "عملیات توسط WP Cron کامل شد", "2024-11-07 09:50:28", "2024-11-07 13:20:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2374", "799", "ایجاد فعالیت", "2024-11-07 09:50:28", "2024-11-07 13:20:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2378", "800", "عملیات توسط WP Cron شروع شد", "2024-11-09 13:03:08", "2024-11-09 16:33:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2379", "800", "عملیات توسط WP Cron کامل شد", "2024-11-09 13:03:08", "2024-11-09 16:33:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2380", "801", "ایجاد فعالیت", "2024-11-09 13:03:08", "2024-11-09 16:33:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2381", "801", "عملیات توسط WP Cron شروع شد", "2024-11-10 13:04:36", "2024-11-10 16:34:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2382", "801", "عملیات توسط WP Cron کامل شد", "2024-11-10 13:04:36", "2024-11-10 16:34:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2383", "802", "ایجاد فعالیت", "2024-11-10 13:04:36", "2024-11-10 16:34:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2384", "802", "عملیات توسط WP Cron شروع شد", "2024-11-11 14:03:05", "2024-11-11 17:33:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("2385", "802", "عملیات توسط WP Cron کامل شد", "2024-11-11 14:03:05", "2024-11-11 17:33:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("2386", "803", "ایجاد فعالیت", "2024-11-11 14:03:05", "2024-11-11 17:33:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("2387", "803", "عملیات توسط WP Cron شروع شد", "2024-11-12 16:23:11", "2024-11-12 19:53:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2388", "803", "عملیات توسط WP Cron کامل شد", "2024-11-12 16:23:11", "2024-11-12 19:53:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2389", "804", "ایجاد فعالیت", "2024-11-12 16:23:11", "2024-11-12 19:53:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2390", "804", "عملیات توسط WP Cron شروع شد", "2024-11-13 16:58:45", "2024-11-13 20:28:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2391", "804", "عملیات توسط WP Cron کامل شد", "2024-11-13 16:58:45", "2024-11-13 20:28:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2392", "805", "ایجاد فعالیت", "2024-11-13 16:58:45", "2024-11-13 20:28:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2393", "805", "action started via WP Cron", "2024-11-14 19:54:08", "2024-11-14 23:24:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2394", "805", "action complete via WP Cron", "2024-11-14 19:54:08", "2024-11-14 23:24:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2395", "806", "action created", "2024-11-14 19:54:08", "2024-11-14 23:24:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2402", "808", "action started via WP Cron", "2024-11-18 04:30:51", "2024-11-18 08:00:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("2403", "808", "action complete via WP Cron", "2024-11-18 04:30:51", "2024-11-18 08:00:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("2404", "809", "action created", "2024-11-18 04:30:51", "2024-11-18 08:00:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("2405", "809", "action started via WP Cron", "2024-11-19 08:19:49", "2024-11-19 11:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("2406", "809", "action complete via WP Cron", "2024-11-19 08:19:49", "2024-11-19 11:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("2407", "810", "action created", "2024-11-19 08:19:49", "2024-11-19 11:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("2408", "810", "action started via WP Cron", "2024-11-20 08:40:56", "2024-11-20 12:10:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2409", "810", "action complete via WP Cron", "2024-11-20 08:40:56", "2024-11-20 12:10:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2410", "811", "action created", "2024-11-20 08:40:56", "2024-11-20 12:10:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2411", "811", "action started via WP Cron", "2024-11-21 10:54:12", "2024-11-21 14:24:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2412", "811", "action complete via WP Cron", "2024-11-21 10:54:12", "2024-11-21 14:24:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2413", "812", "action created", "2024-11-21 10:54:12", "2024-11-21 14:24:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2414", "812", "action started via WP Cron", "2024-11-22 11:00:35", "2024-11-22 14:30:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2415", "812", "action complete via WP Cron", "2024-11-22 11:00:35", "2024-11-22 14:30:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2416", "813", "action created", "2024-11-22 11:00:35", "2024-11-22 14:30:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2417", "813", "action started via WP Cron", "2024-11-23 11:22:34", "2024-11-23 14:52:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2418", "813", "action complete via WP Cron", "2024-11-23 11:22:34", "2024-11-23 14:52:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2419", "814", "action created", "2024-11-23 11:22:34", "2024-11-23 14:52:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2429", "818", "action created", "2024-11-26 14:29:32", "2024-11-26 17:59:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2430", "818", "action started via Async Request", "2024-11-26 14:30:38", "2024-11-26 18:00:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("2431", "818", "action complete via Async Request", "2024-11-26 14:30:38", "2024-11-26 18:00:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("2432", "819", "ایجاد فعالیت", "2024-11-26 14:31:10", "2024-11-26 18:01:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2433", "819", "عملیات توسط Async Request شروع شد", "2024-11-26 14:32:26", "2024-11-26 18:02:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2434", "819", "عملیات توسط Async Request کامل شد", "2024-11-26 14:32:26", "2024-11-26 18:02:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2435", "820", "ایجاد فعالیت", "2024-11-26 14:34:41", "2024-11-26 18:04:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2436", "821", "ایجاد فعالیت", "2024-11-26 14:34:41", "2024-11-26 18:04:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2437", "822", "ایجاد فعالیت", "2024-11-26 14:34:41", "2024-11-26 18:04:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2438", "823", "ایجاد فعالیت", "2024-11-26 14:34:41", "2024-11-26 18:04:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2439", "824", "ایجاد فعالیت", "2024-11-26 14:34:41", "2024-11-26 18:04:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2440", "825", "ایجاد فعالیت", "2024-11-26 14:34:41", "2024-11-26 18:04:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2441", "826", "ایجاد فعالیت", "2024-11-26 14:34:41", "2024-11-26 18:04:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2442", "827", "ایجاد فعالیت", "2024-11-26 14:34:41", "2024-11-26 18:04:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2443", "828", "ایجاد فعالیت", "2024-11-26 14:34:41", "2024-11-26 18:04:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2444", "829", "ایجاد فعالیت", "2024-11-26 14:34:41", "2024-11-26 18:04:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2445", "830", "ایجاد فعالیت", "2024-11-26 14:34:41", "2024-11-26 18:04:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2446", "831", "ایجاد فعالیت", "2024-11-26 14:34:41", "2024-11-26 18:04:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2447", "832", "ایجاد فعالیت", "2024-11-26 14:34:41", "2024-11-26 18:04:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2448", "833", "ایجاد فعالیت", "2024-11-26 14:34:41", "2024-11-26 18:04:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2449", "834", "ایجاد فعالیت", "2024-11-26 14:34:41", "2024-11-26 18:04:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2450", "835", "ایجاد فعالیت", "2024-11-26 14:34:41", "2024-11-26 18:04:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2451", "836", "ایجاد فعالیت", "2024-11-26 14:34:41", "2024-11-26 18:04:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2452", "837", "ایجاد فعالیت", "2024-11-26 14:34:41", "2024-11-26 18:04:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2453", "838", "ایجاد فعالیت", "2024-11-26 14:34:41", "2024-11-26 18:04:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2454", "839", "ایجاد فعالیت", "2024-11-26 14:34:41", "2024-11-26 18:04:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2455", "840", "ایجاد فعالیت", "2024-11-26 14:34:41", "2024-11-26 18:04:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2456", "820", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:34:42", "2024-11-26 18:04:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("2457", "820", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:34:42", "2024-11-26 18:04:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("2458", "821", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:34:42", "2024-11-26 18:04:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("2459", "821", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:34:42", "2024-11-26 18:04:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("2460", "841", "ایجاد فعالیت", "2024-11-26 14:35:01", "2024-11-26 18:05:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2461", "842", "ایجاد فعالیت", "2024-11-26 14:35:01", "2024-11-26 18:05:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2462", "843", "ایجاد فعالیت", "2024-11-26 14:35:01", "2024-11-26 18:05:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2463", "844", "ایجاد فعالیت", "2024-11-26 14:35:01", "2024-11-26 18:05:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2464", "845", "ایجاد فعالیت", "2024-11-26 14:35:01", "2024-11-26 18:05:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2465", "846", "ایجاد فعالیت", "2024-11-26 14:35:01", "2024-11-26 18:05:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2466", "847", "ایجاد فعالیت", "2024-11-26 14:35:01", "2024-11-26 18:05:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2467", "848", "ایجاد فعالیت", "2024-11-26 14:35:01", "2024-11-26 18:05:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2468", "849", "ایجاد فعالیت", "2024-11-26 14:35:01", "2024-11-26 18:05:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2469", "850", "ایجاد فعالیت", "2024-11-26 14:35:01", "2024-11-26 18:05:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2470", "851", "ایجاد فعالیت", "2024-11-26 14:35:01", "2024-11-26 18:05:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2471", "852", "ایجاد فعالیت", "2024-11-26 14:35:01", "2024-11-26 18:05:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2472", "853", "ایجاد فعالیت", "2024-11-26 14:35:01", "2024-11-26 18:05:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2473", "854", "ایجاد فعالیت", "2024-11-26 14:35:01", "2024-11-26 18:05:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2474", "855", "ایجاد فعالیت", "2024-11-26 14:35:01", "2024-11-26 18:05:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2475", "856", "ایجاد فعالیت", "2024-11-26 14:35:01", "2024-11-26 18:05:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2476", "857", "ایجاد فعالیت", "2024-11-26 14:35:01", "2024-11-26 18:05:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2477", "858", "ایجاد فعالیت", "2024-11-26 14:35:01", "2024-11-26 18:05:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2478", "859", "ایجاد فعالیت", "2024-11-26 14:35:01", "2024-11-26 18:05:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2479", "860", "ایجاد فعالیت", "2024-11-26 14:35:01", "2024-11-26 18:05:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2480", "822", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2481", "822", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2482", "823", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2483", "823", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2484", "824", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2485", "824", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2486", "825", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2487", "825", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2488", "826", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2489", "826", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2490", "827", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2491", "827", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2492", "828", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2493", "828", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2494", "829", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2495", "829", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2496", "830", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2497", "830", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2498", "831", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2499", "831", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2500", "832", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2501", "832", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2502", "833", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2503", "833", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2504", "834", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2505", "834", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2506", "835", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2507", "835", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2508", "836", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2509", "836", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2510", "837", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2511", "837", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2512", "838", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2513", "838", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2514", "839", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2515", "839", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2516", "840", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2517", "840", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2518", "841", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2519", "841", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2520", "842", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2521", "842", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2522", "843", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2523", "843", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2524", "844", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2525", "844", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2526", "845", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2527", "845", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2528", "846", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2529", "846", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2530", "847", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2531", "847", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2532", "848", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2533", "848", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2534", "849", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2535", "849", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2536", "850", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2537", "850", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2538", "851", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2539", "851", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2540", "852", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2541", "852", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2542", "853", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2543", "853", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2544", "854", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2545", "854", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2546", "855", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2547", "855", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2548", "856", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2549", "856", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2550", "857", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2551", "857", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2552", "858", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2553", "858", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2554", "859", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2555", "859", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2556", "860", "عملیات توسط WP Cron شروع شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2557", "860", "عملیات توسط WP Cron کامل شد", "2024-11-26 14:35:40", "2024-11-26 18:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2558", "861", "ایجاد فعالیت", "2024-11-26 14:40:30", "2024-11-26 18:10:30");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("6", "20211212_d8b3d8a7db8cd8aad8a2d985d8a7d8", "0d57b5b33fedd5db1720_20241126143515", "21", "2024-11-26 14:40:52", "designer", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-11-26 14:35:15\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.1\";s:9:\"VersionDB\";s:7:\"10.6.19\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:6;s:4:\"Name\";s:39:\"20211212_d8b3d8a7db8cd8aad8a2d985d8a7d8\";s:4:\"Hash\";s:35:\"0d57b5b33fedd5db1720_20241126143515\";s:8:\"NameHash\";s:75:\"20211212_d8b3d8a7db8cd8aad8a2d985d8a7d8_0d57b5b33fedd5db1720_20241126143515\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:85:\"20211212_d8b3d8a7db8cd8aad8a2d985d8a7d8_0d57b5b33fedd5db1720_20241126143515_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.6\";s:6:\"WPUser\";s:8:\"designer\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:87:\"20211212_d8b3d8a7db8cd8aad8a2d985d8a7d8_0d57b5b33fedd5db1720_20241126143515_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:67:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/resume\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:4448;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:26501;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-11-26 14:35:15\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.1\";s:9:\"VersionDB\";s:7:\"10.6.19\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20211212_d8b3d8a7db8cd8aad8a2d985d8a7d8\";s:4:\"Hash\";s:35:\"0d57b5b33fedd5db1720_20241126143515\";s:8:\"NameHash\";s:75:\"20211212_d8b3d8a7db8cd8aad8a2d985d8a7d8_0d57b5b33fedd5db1720_20241126143515\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:93:\"20211212_d8b3d8a7db8cd8aad8a2d985d8a7d8_0d57b5b33fedd5db1720_20241126143515_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:81:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/resume/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:88:\"20211212_d8b3d8a7db8cd8aad8a2d985d8a7d8_0d57b5b33fedd5db1720_20241126143515_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:188:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/resume/wp-content/backups-dup-lite/tmp/20211212_d8b3d8a7db8cd8aad8a2d985d8a7d8_0d57b5b33fedd5db1720_20241126143515_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:76:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/resume/wp-admin\";i:1;s:79:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/resume/wp-includes\";i:2;s:88:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/resume/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:67:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/resume\";i:1;s:67:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/resume\";i:2;s:78:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/resume/wp-content\";i:3;s:86:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/resume/wp-content/uploads\";i:4;s:86:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/resume/wp-content/plugins\";i:5;s:89:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/resume/wp-content/mu-plugins\";i:6;s:85:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/resume/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:99:\"/home/prewebsi/domains/pre-websites.ir/public_html/elementor/resume/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_e_submissions */
INSERT INTO `wp_e_submissions` VALUES("1", "submission", "812bb07e-88d1-4bdc-97bb-57ab2f90861f", "1", "1886", "https://pre-websites.ir/elementor/resume/demo-4/", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "5.123.12.219", "Mozilla/5.0 (Linux; Android 10; Redmi Note 8) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/96.0.4664.104 Mobile Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2021-12-19 19:01:15", "2021-12-19 19:01:15", "2021-12-19 22:31:15", "2021-12-19 22:31:15");
INSERT INTO `wp_e_submissions` VALUES("2", "submission", "f890180a-8bb8-4a8a-adf2-a5c61baae990", "6", "2736", "https://pre-websites.ir/elementor/resume/demo-10/", "دمو شماره 10", "ab92e20", "فرم جدید", "0", "0", "151.246.127.58", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/97.0.4692.99 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"2736\"}", "2022-01-24 13:28:58", "2022-01-24 13:28:58", "2022-01-24 16:58:58", "2022-01-24 16:58:58");
INSERT INTO `wp_e_submissions` VALUES("3", "submission", "af4e40ac-9b91-46c1-8bbb-6a5a21076a9a", "11", "1886", "https://pre-websites.ir/elementor/resume/demo-4/", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "95.81.123.68", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2022-02-16 10:58:30", "2022-02-16 10:58:30", "2022-02-16 14:28:30", "2022-02-16 14:28:30");
INSERT INTO `wp_e_submissions` VALUES("4", "submission", "5ae72e3d-c6e9-4195-b4e0-2eb9de03ff47", "16", "1886", "https://pre-websites.ir/elementor/resume/demo-4/", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "95.81.123.68", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2022-02-16 10:58:32", "2022-02-16 10:58:33", "2022-02-16 14:28:32", "2022-02-16 14:28:33");
INSERT INTO `wp_e_submissions` VALUES("5", "submission", "11d64b33-959e-4b79-bb19-171382319a1b", "21", "1886", "https://pre-websites.ir/elementor/resume/demo-4/", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "95.81.123.68", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2022-02-16 10:58:37", "2022-02-16 10:58:37", "2022-02-16 14:28:37", "2022-02-16 14:28:37");
INSERT INTO `wp_e_submissions` VALUES("6", "submission", "8608ff05-2902-4c61-a43b-04bccb5f319a", "26", "1886", "https://pre-websites.ir/elementor/resume/demo-4/", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "95.81.123.68", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2022-02-16 10:58:38", "2022-02-16 10:58:38", "2022-02-16 14:28:38", "2022-02-16 14:28:38");
INSERT INTO `wp_e_submissions` VALUES("7", "submission", "91bfae28-f366-44f6-8e85-4fc902b70cdb", "31", "1886", "https://pre-websites.ir/elementor/resume/demo-4/", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "95.81.123.68", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2022-02-16 10:58:39", "2022-02-16 10:58:40", "2022-02-16 14:28:39", "2022-02-16 14:28:40");
INSERT INTO `wp_e_submissions` VALUES("8", "submission", "1dda1522-e525-49d1-aeba-fdf8ae644f5b", "36", "1886", "https://pre-websites.ir/elementor/resume/demo-4/", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "95.81.123.68", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2022-02-16 10:58:41", "2022-02-16 10:58:41", "2022-02-16 14:28:41", "2022-02-16 14:28:41");
INSERT INTO `wp_e_submissions` VALUES("9", "submission", "be76fb94-e07d-40c3-b880-dec56bd154a9", "41", "1886", "https://pre-websites.ir/elementor/resume/demo-4/", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "95.81.123.68", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2022-02-16 10:58:42", "2022-02-16 10:58:42", "2022-02-16 14:28:42", "2022-02-16 14:28:42");
INSERT INTO `wp_e_submissions` VALUES("10", "submission", "41ac1c36-e146-40f8-9fd3-cb45e66aa562", "46", "1886", "https://pre-websites.ir/elementor/resume/demo-4/", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "95.81.123.68", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2022-02-16 10:58:43", "2022-02-16 10:58:43", "2022-02-16 14:28:43", "2022-02-16 14:28:43");
INSERT INTO `wp_e_submissions` VALUES("11", "submission", "a46d0eba-3a30-40fd-b4f8-4bfe75322efb", "51", "1886", "https://pre-websites.ir/elementor/resume/demo-4/", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "95.81.123.68", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2022-02-16 10:58:44", "2022-02-16 10:58:44", "2022-02-16 14:28:44", "2022-02-16 14:28:44");
INSERT INTO `wp_e_submissions` VALUES("12", "submission", "03ab29c0-4f8d-4d48-89d6-ee39c8965a0b", "56", "1886", "https://pre-websites.ir/elementor/resume/demo-4/", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "95.81.123.68", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2022-02-16 10:58:45", "2022-02-16 10:58:45", "2022-02-16 14:28:45", "2022-02-16 14:28:45");
INSERT INTO `wp_e_submissions` VALUES("13", "submission", "8e19710d-55df-4fa2-9d6a-da31f465355f", "61", "1886", "https://pre-websites.ir/elementor/resume/demo-4/", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "95.81.123.68", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2022-02-16 10:58:46", "2022-02-16 10:58:46", "2022-02-16 14:28:46", "2022-02-16 14:28:46");
INSERT INTO `wp_e_submissions` VALUES("14", "submission", "407a985b-20b2-49b4-8fcd-0e816b31a8e3", "66", "1886", "https://pre-websites.ir/elementor/resume/demo-4/#", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "95.81.123.68", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/98.0.4758.82 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2022-02-16 10:58:48", "2022-02-16 10:58:48", "2022-02-16 14:28:48", "2022-02-16 14:28:48");
INSERT INTO `wp_e_submissions` VALUES("15", "submission", "51f80603-fdbe-4068-adf7-42dabaaefae7", "71", "1886", "https://pre-websites.ir/elementor/resume/demo-4/#", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "37.98.70.40", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.3 Safari/605.1.15", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2022-02-21 15:27:16", "2022-02-21 15:27:16", "2022-02-21 18:57:16", "2022-02-21 18:57:16");
INSERT INTO `wp_e_submissions` VALUES("16", "submission", "29d6b3a4-882e-49b5-ab9a-10c6b5f06c8f", "76", "1609", "https://pre-websites.ir/elementor/resume/demo-2/", "دمو شماره 2", "32ab87d", "فرم ارتباط با من", "0", "0", "151.244.8.224", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4896.127 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1609\"}", "2022-05-02 16:26:46", "2022-05-02 16:26:46", "2022-05-02 20:56:46", "2022-05-02 20:56:46");
INSERT INTO `wp_e_submissions` VALUES("17", "submission", "4fbe58ae-e5e4-48ee-8f97-9c982b206ebf", "80", "1886", "https://pre-websites.ir/elementor/resume/demo-4/#", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "188.159.1.58", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2022-08-14 09:18:47", "2022-08-14 09:18:47", "2022-08-14 13:48:47", "2022-08-14 13:48:47");
INSERT INTO `wp_e_submissions` VALUES("18", "submission", "8dac921c-632f-4e59-a77e-a7bd803450a4", "85", "1886", "https://pre-websites.ir/elementor/resume/demo-4/", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "31.14.153.13", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2022-08-31 19:07:18", "2022-08-31 19:07:18", "2022-08-31 23:37:18", "2022-08-31 23:37:18");
INSERT INTO `wp_e_submissions` VALUES("19", "submission", "0f4bf55e-dad4-4212-9233-313bf3e93a5e", "90", "1886", "https://pre-websites.ir/elementor/resume/demo-4/", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "89.21.64.50", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:107.0) Gecko/20100101 Firefox/107.0", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2022-11-26 09:12:06", "2022-11-26 09:12:06", "2022-11-26 12:42:06", "2022-11-26 12:42:06");
INSERT INTO `wp_e_submissions` VALUES("20", "submission", "00a26899-c3e4-4719-9e8d-2756173cf3b3", "95", "1461", "https://pre-websites.ir/elementor/resume/demo-7/", "دمو شماره 7", "6db8d96", "فرم جدید", "0", "0", "31.7.117.14", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1461\"}", "2022-12-11 17:44:54", "2022-12-11 17:44:54", "2022-12-11 21:14:54", "2022-12-11 21:14:54");
INSERT INTO `wp_e_submissions` VALUES("21", "submission", "bfd3b4a1-c11b-4556-9e16-ca1140f1d193", "100", "2507", "https://pre-websites.ir/elementor/resume/demo-9/#", "دمو شماره 9", "5249c2c", "فرم جدید", "0", "0", "5.219.129.212", "Mozilla/5.0 (Linux; Android 9; Redmi Note 8T) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/107.0.0.0 Mobile Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"2507\"}", "2022-12-20 20:02:04", "2022-12-20 20:02:04", "2022-12-20 23:32:04", "2022-12-20 23:32:04");
INSERT INTO `wp_e_submissions` VALUES("22", "submission", "e1af8239-3612-4b69-b3d1-227ae2d81ba7", "105", "1886", "https://pre-websites.ir/elementor/resume/demo-4/#", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "217.219.139.129", "Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:109.0) Gecko/20100101 Firefox/109.0", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2023-01-25 22:16:51", "2023-01-25 22:16:52", "2023-01-26 01:46:51", "2023-01-26 01:46:52");
INSERT INTO `wp_e_submissions` VALUES("23", "submission", "208fb6d4-d5ab-4e37-98b9-dafa0b3cf37e", "110", "1461", "https://pre-websites.ir/elementor/resume/demo-7/", "دمو شماره 7", "6db8d96", "فرم جدید", "0", "0", "85.185.176.83", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1461\"}", "2023-02-15 12:45:51", "2023-02-15 12:45:51", "2023-02-15 16:15:51", "2023-02-15 16:15:51");
INSERT INTO `wp_e_submissions` VALUES("24", "submission", "a02484d8-f7dd-4436-8ef8-9a8bbb07c460", "115", "2157", "https://pre-websites.ir/elementor/resume/demo-8/", "دمو شماره 8", "cb373b7", "فرم جدید", "0", "0", "192.15.45.10", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"2157\"}", "2023-03-12 14:44:30", "2023-03-12 14:44:30", "2023-03-12 18:14:30", "2023-03-12 18:14:30");
INSERT INTO `wp_e_submissions` VALUES("25", "submission", "56f28084-d80a-495d-8b20-8044410c7e98", "120", "1886", "https://pre-websites.ir/elementor/resume/demo-4/", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "89.41.19.129", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2023-04-21 11:54:23", "2023-04-21 11:54:23", "2023-04-21 15:24:23", "2023-04-21 15:24:23");
INSERT INTO `wp_e_submissions` VALUES("26", "submission", "0643e510-3095-4fc3-ba1d-6d4abdac54e1", "125", "1886", "https://pre-websites.ir/elementor/resume/demo-4/", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "5.124.150.174", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/112.0", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2023-05-05 17:58:31", "2023-05-05 17:58:31", "2023-05-05 21:28:31", "2023-05-05 21:28:31");
INSERT INTO `wp_e_submissions` VALUES("27", "submission", "b35b5985-2b89-41ab-95a4-db7f26574d08", "130", "1886", "https://pre-websites.ir/elementor/resume/demo-4/", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "62.102.138.150", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2023-05-06 09:34:18", "2023-05-06 09:34:18", "2023-05-06 13:04:18", "2023-05-06 13:04:18");
INSERT INTO `wp_e_submissions` VALUES("28", "submission", "87b30616-d8ea-496d-98e0-6bcb6dcdff7a", "135", "1886", "https://pre-websites.ir/elementor/resume/demo-4/", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "37.191.92.137", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2023-07-01 07:20:14", "2023-07-01 07:20:14", "2023-07-01 10:50:14", "2023-07-01 10:50:14");
INSERT INTO `wp_e_submissions` VALUES("29", "submission", "7168e04c-9407-4bb9-b31a-45ae1393334f", "140", "606", "https://pre-websites.ir/elementor/resume/", "", "3115e33", "فرم تماس", "0", "0", "46.143.76.6", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"606\"}", "2023-07-18 18:16:53", "2023-07-18 18:16:53", "2023-07-18 21:46:53", "2023-07-18 21:46:53");
INSERT INTO `wp_e_submissions` VALUES("30", "submission", "3387d746-a906-4cc7-be77-2bd634215656", "144", "1886", "https://pre-websites.ir/elementor/resume/demo-4/#", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "31.130.183.2", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/116.0.0.0 Safari/537.36 Edg/116.0.1938.62", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2023-08-31 04:52:38", "2023-08-31 04:52:42", "2023-08-31 08:22:38", "2023-08-31 08:22:42");
INSERT INTO `wp_e_submissions` VALUES("31", "submission", "e9614978-e31c-41f4-8ccf-0ac5b708892d", "149", "1886", "https://pre-websites.ir/elementor/resume/demo-4/#", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "5.209.91.176", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/116.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2023-08-31 13:53:39", "2023-08-31 13:53:42", "2023-08-31 17:23:39", "2023-08-31 17:23:42");
INSERT INTO `wp_e_submissions` VALUES("32", "submission", "015c949b-ce76-40f7-b7a2-39b313606b44", "154", "2507", "https://pre-websites.ir/elementor/resume/demo-9/#", "دمو شماره 9", "5249c2c", "فرم جدید", "0", "0", "37.98.72.174", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/116.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"2507\"}", "2023-09-03 20:15:12", "2023-09-03 20:15:17", "2023-09-03 23:45:12", "2023-09-03 23:45:17");
INSERT INTO `wp_e_submissions` VALUES("33", "submission", "9ad2b203-13f3-4144-a7d2-2db9057e8d39", "159", "2157", "https://pre-websites.ir/elementor/resume/demo-8/", "دمو شماره 8", "cb373b7", "فرم جدید", "0", "0", "83.120.133.167", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"2157\"}", "2023-09-17 00:09:48", "2023-09-17 00:09:50", "2023-09-17 03:39:48", "2023-09-17 03:39:50");
INSERT INTO `wp_e_submissions` VALUES("34", "submission", "90edd156-6841-4996-b388-1b89231728b8", "164", "1886", "https://pre-websites.ir/elementor/resume/demo-4/#", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "5.134.143.48", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/117.0.0.0 Safari/537.36 Edg/117.0.2045.31", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2023-09-18 18:21:07", "2023-09-18 18:21:12", "2023-09-18 21:51:07", "2023-09-18 21:51:12");
INSERT INTO `wp_e_submissions` VALUES("35", "submission", "afca3105-d34d-46f1-a48d-da1cedf65467", "169", "2157", "https://pre-websites.ir/elementor/resume/demo-8/", "دمو شماره 8", "cb373b7", "فرم جدید", "0", "0", "188.210.123.163", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/116.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"2157\"}", "2023-09-22 18:41:58", "2023-09-22 18:41:58", "2023-09-22 22:11:58", "2023-09-22 22:11:58");
INSERT INTO `wp_e_submissions` VALUES("36", "submission", "95a88eeb-ccd6-4c33-8a25-3b557f0b379d", "174", "1886", "https://pre-websites.ir/elementor/resume/demo-4/", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "5.122.36.29", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/117.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2023-09-26 18:02:48", "2023-09-26 18:02:54", "2023-09-26 21:32:48", "2023-09-26 21:32:54");
INSERT INTO `wp_e_submissions` VALUES("37", "submission", "f8429498-18d2-4f35-aa6d-3768311ad2e3", "179", "1886", "https://pre-websites.ir/elementor/resume/demo-4/", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "95.162.224.254", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/117.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2023-10-02 16:35:29", "2023-10-02 16:35:34", "2023-10-02 20:05:29", "2023-10-02 20:05:34");
INSERT INTO `wp_e_submissions` VALUES("38", "submission", "2523658b-a739-4fdb-be9c-fc9aebc12f12", "184", "1886", "https://pre-websites.ir/elementor/resume/demo-4/#", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "5.119.187.96", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/118.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2023-10-26 07:15:12", "2023-10-26 07:15:16", "2023-10-26 10:45:12", "2023-10-26 10:45:16");
INSERT INTO `wp_e_submissions` VALUES("39", "submission", "d2425294-00e1-4fc8-9a60-24c8b0231a6e", "189", "1886", "https://pre-websites.ir/elementor/resume/demo-4/", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "78.39.18.37", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/118.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2023-10-30 15:04:27", "2023-10-30 15:04:29", "2023-10-30 18:34:27", "2023-10-30 18:34:29");
INSERT INTO `wp_e_submissions` VALUES("40", "submission", "dddc607c-3c2a-4e73-bc55-f4c553d10727", "194", "2157", "https://pre-websites.ir/elementor/resume/demo-8/#", "دمو شماره 8", "cb373b7", "فرم جدید", "0", "0", "188.215.197.74", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/116.0.0.0 Safari/537.36 Edg/116.0.1938.69", "1", "1", "new", "0", "{\"edit_post_id\":\"2157\"}", "2023-11-17 09:42:50", "2023-11-17 09:42:53", "2023-11-17 13:12:50", "2023-11-17 13:12:53");
INSERT INTO `wp_e_submissions` VALUES("41", "submission", "2cef2867-9bd3-4a7d-af81-d3fae5ddadee", "199", "1609", "https://pre-websites.ir/elementor/resume/demo-2/", "دمو شماره 2", "32ab87d", "فرم ارتباط با من", "0", "0", "5.106.27.86", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1609\"}", "2024-01-08 11:28:42", "2024-01-08 11:28:47", "2024-01-08 14:58:42", "2024-01-08 14:58:47");
INSERT INTO `wp_e_submissions` VALUES("42", "submission", "9d210db7-90c8-4767-88da-fb3ed22700a0", "203", "1886", "https://pre-websites.ir/elementor/resume/demo-4/", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "188.136.144.106", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/121.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2024-02-17 07:24:01", "2024-02-17 07:24:03", "2024-02-17 10:54:01", "2024-02-17 10:54:03");
INSERT INTO `wp_e_submissions` VALUES("43", "submission", "f57bc86d-7b17-454c-add8-1fd93f178561", "208", "1886", "https://pre-websites.ir/elementor/resume/demo-4/", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "188.136.144.106", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/121.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2024-02-17 07:24:13", "2024-02-17 07:24:13", "2024-02-17 10:54:13", "2024-02-17 10:54:13");
INSERT INTO `wp_e_submissions` VALUES("44", "submission", "301e5191-f709-4a9f-9ffa-c8a3facda474", "213", "2157", "https://pre-websites.ir/elementor/resume/demo-8/", "دمو شماره 8", "cb373b7", "فرم جدید", "0", "0", "2.147.212.100", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/122.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"2157\"}", "2024-02-29 06:39:03", "2024-02-29 06:39:07", "2024-02-29 10:09:03", "2024-02-29 10:09:07");
INSERT INTO `wp_e_submissions` VALUES("45", "submission", "3faff05b-e4d9-4215-aefd-6bf14b545e36", "218", "1116", "https://pre-websites.ir/elementor/resume/demo-5/#", "دمو شماره 5", "bfe596b", "فرم جدید", "0", "0", "2.187.121.245", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:123.0) Gecko/20100101 Firefox/123.0", "1", "1", "new", "0", "{\"edit_post_id\":\"1116\"}", "2024-03-20 13:26:10", "2024-03-20 13:26:15", "2024-03-20 16:56:10", "2024-03-20 16:56:15");
INSERT INTO `wp_e_submissions` VALUES("46", "submission", "abaf20da-d2dd-40f3-a59c-d50bd0061bed", "223", "1886", "https://pre-websites.ir/elementor/resume/demo-4/#", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "5.112.59.230", "Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/122.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2024-03-22 07:12:55", "2024-03-22 07:13:00", "2024-03-22 10:42:55", "2024-03-22 10:43:00");
INSERT INTO `wp_e_submissions` VALUES("47", "submission", "e835d295-c2bf-494c-ac28-0013081b98d0", "228", "1886", "https://pre-websites.ir/elementor/resume/demo-4/", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "5.123.75.75", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/123.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2024-04-01 16:05:45", "2024-04-01 16:05:50", "2024-04-01 19:35:45", "2024-04-01 19:35:50");
INSERT INTO `wp_e_submissions` VALUES("48", "submission", "eb8aaf8a-947c-4e74-a667-21cd301604ab", "233", "1886", "https://pre-websites.ir/elementor/resume/demo-4/", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "2.147.59.212", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:125.0) Gecko/20100101 Firefox/125.0", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2024-05-08 01:35:03", "2024-05-08 01:35:04", "2024-05-08 05:05:03", "2024-05-08 05:05:04");
INSERT INTO `wp_e_submissions` VALUES("49", "submission", "feff0a3f-db2a-47c4-b1d9-82fc38f6dafe", "238", "1461", "https://pre-websites.ir/elementor/resume/demo-7/#", "دمو شماره 7", "6db8d96", "فرم جدید", "0", "0", "37.98.72.6", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/126.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1461\"}", "2024-07-11 13:12:16", "2024-07-11 13:12:17", "2024-07-11 16:42:16", "2024-07-11 16:42:17");
INSERT INTO `wp_e_submissions` VALUES("50", "submission", "315fc223-4255-4ede-a08a-39941170d3c4", "243", "1886", "https://pre-websites.ir/elementor/resume/demo-4/", "دمو شماره 4", "c8147bc", "فرم جدید", "0", "0", "5.238.249.43", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36", "1", "1", "new", "0", "{\"edit_post_id\":\"1886\"}", "2024-11-23 07:07:56", "2024-11-23 07:07:57", "2024-11-23 10:37:56", "2024-11-23 10:37:57");

/* INSERT TABLE DATA: wp_e_submissions_actions_log */
INSERT INTO `wp_e_submissions_actions_log` VALUES("1", "1", "email", "آدرس ایمیل", "success", NULL, "2021-12-19 19:01:15", "2021-12-19 19:01:15", "2021-12-19 22:31:15", "2021-12-19 22:31:15");
INSERT INTO `wp_e_submissions_actions_log` VALUES("2", "2", "email", "آدرس ایمیل", "success", NULL, "2022-01-24 13:28:58", "2022-01-24 13:28:58", "2022-01-24 16:58:58", "2022-01-24 16:58:58");
INSERT INTO `wp_e_submissions_actions_log` VALUES("3", "3", "email", "آدرس ایمیل", "success", NULL, "2022-02-16 10:58:30", "2022-02-16 10:58:30", "2022-02-16 14:28:30", "2022-02-16 14:28:30");
INSERT INTO `wp_e_submissions_actions_log` VALUES("4", "4", "email", "آدرس ایمیل", "success", NULL, "2022-02-16 10:58:33", "2022-02-16 10:58:33", "2022-02-16 14:28:33", "2022-02-16 14:28:33");
INSERT INTO `wp_e_submissions_actions_log` VALUES("5", "5", "email", "آدرس ایمیل", "success", NULL, "2022-02-16 10:58:37", "2022-02-16 10:58:37", "2022-02-16 14:28:37", "2022-02-16 14:28:37");
INSERT INTO `wp_e_submissions_actions_log` VALUES("6", "6", "email", "آدرس ایمیل", "success", NULL, "2022-02-16 10:58:38", "2022-02-16 10:58:38", "2022-02-16 14:28:38", "2022-02-16 14:28:38");
INSERT INTO `wp_e_submissions_actions_log` VALUES("7", "7", "email", "آدرس ایمیل", "success", NULL, "2022-02-16 10:58:40", "2022-02-16 10:58:40", "2022-02-16 14:28:40", "2022-02-16 14:28:40");
INSERT INTO `wp_e_submissions_actions_log` VALUES("8", "8", "email", "آدرس ایمیل", "success", NULL, "2022-02-16 10:58:41", "2022-02-16 10:58:41", "2022-02-16 14:28:41", "2022-02-16 14:28:41");
INSERT INTO `wp_e_submissions_actions_log` VALUES("9", "9", "email", "آدرس ایمیل", "success", NULL, "2022-02-16 10:58:42", "2022-02-16 10:58:42", "2022-02-16 14:28:42", "2022-02-16 14:28:42");
INSERT INTO `wp_e_submissions_actions_log` VALUES("10", "10", "email", "آدرس ایمیل", "success", NULL, "2022-02-16 10:58:43", "2022-02-16 10:58:43", "2022-02-16 14:28:43", "2022-02-16 14:28:43");
INSERT INTO `wp_e_submissions_actions_log` VALUES("11", "11", "email", "آدرس ایمیل", "success", NULL, "2022-02-16 10:58:44", "2022-02-16 10:58:44", "2022-02-16 14:28:44", "2022-02-16 14:28:44");
INSERT INTO `wp_e_submissions_actions_log` VALUES("12", "12", "email", "آدرس ایمیل", "success", NULL, "2022-02-16 10:58:45", "2022-02-16 10:58:45", "2022-02-16 14:28:45", "2022-02-16 14:28:45");
INSERT INTO `wp_e_submissions_actions_log` VALUES("13", "13", "email", "آدرس ایمیل", "success", NULL, "2022-02-16 10:58:46", "2022-02-16 10:58:46", "2022-02-16 14:28:46", "2022-02-16 14:28:46");
INSERT INTO `wp_e_submissions_actions_log` VALUES("14", "14", "email", "آدرس ایمیل", "success", NULL, "2022-02-16 10:58:48", "2022-02-16 10:58:48", "2022-02-16 14:28:48", "2022-02-16 14:28:48");
INSERT INTO `wp_e_submissions_actions_log` VALUES("15", "15", "email", "آدرس ایمیل", "success", NULL, "2022-02-21 15:27:16", "2022-02-21 15:27:16", "2022-02-21 18:57:16", "2022-02-21 18:57:16");
INSERT INTO `wp_e_submissions_actions_log` VALUES("16", "16", "email", "آدرس ایمیل", "success", NULL, "2022-05-02 16:26:46", "2022-05-02 16:26:46", "2022-05-02 20:56:46", "2022-05-02 20:56:46");
INSERT INTO `wp_e_submissions_actions_log` VALUES("17", "17", "email", "آدرس ایمیل", "success", NULL, "2022-08-14 09:18:47", "2022-08-14 09:18:47", "2022-08-14 13:48:47", "2022-08-14 13:48:47");
INSERT INTO `wp_e_submissions_actions_log` VALUES("18", "18", "email", "آدرس ایمیل", "success", NULL, "2022-08-31 19:07:18", "2022-08-31 19:07:18", "2022-08-31 23:37:18", "2022-08-31 23:37:18");
INSERT INTO `wp_e_submissions_actions_log` VALUES("19", "19", "email", "آدرس ایمیل", "success", NULL, "2022-11-26 09:12:06", "2022-11-26 09:12:06", "2022-11-26 12:42:06", "2022-11-26 12:42:06");
INSERT INTO `wp_e_submissions_actions_log` VALUES("20", "20", "email", "آدرس ایمیل", "success", NULL, "2022-12-11 17:44:54", "2022-12-11 17:44:54", "2022-12-11 21:14:54", "2022-12-11 21:14:54");
INSERT INTO `wp_e_submissions_actions_log` VALUES("21", "21", "email", "آدرس ایمیل", "success", NULL, "2022-12-20 20:02:04", "2022-12-20 20:02:04", "2022-12-20 23:32:04", "2022-12-20 23:32:04");
INSERT INTO `wp_e_submissions_actions_log` VALUES("22", "22", "email", "آدرس ایمیل", "success", NULL, "2023-01-25 22:16:52", "2023-01-25 22:16:52", "2023-01-26 01:46:52", "2023-01-26 01:46:52");
INSERT INTO `wp_e_submissions_actions_log` VALUES("23", "23", "email", "آدرس ایمیل", "success", NULL, "2023-02-15 12:45:51", "2023-02-15 12:45:51", "2023-02-15 16:15:51", "2023-02-15 16:15:51");
INSERT INTO `wp_e_submissions_actions_log` VALUES("24", "24", "email", "آدرس ایمیل", "success", NULL, "2023-03-12 14:44:30", "2023-03-12 14:44:30", "2023-03-12 18:14:30", "2023-03-12 18:14:30");
INSERT INTO `wp_e_submissions_actions_log` VALUES("25", "25", "email", "آدرس ایمیل", "success", NULL, "2023-04-21 11:54:23", "2023-04-21 11:54:23", "2023-04-21 15:24:23", "2023-04-21 15:24:23");
INSERT INTO `wp_e_submissions_actions_log` VALUES("26", "26", "email", "آدرس ایمیل", "success", NULL, "2023-05-05 17:58:31", "2023-05-05 17:58:31", "2023-05-05 21:28:31", "2023-05-05 21:28:31");
INSERT INTO `wp_e_submissions_actions_log` VALUES("27", "27", "email", "آدرس ایمیل", "success", NULL, "2023-05-06 09:34:18", "2023-05-06 09:34:18", "2023-05-06 13:04:18", "2023-05-06 13:04:18");
INSERT INTO `wp_e_submissions_actions_log` VALUES("28", "28", "email", "آدرس ایمیل", "success", NULL, "2023-07-01 07:20:14", "2023-07-01 07:20:14", "2023-07-01 10:50:14", "2023-07-01 10:50:14");
INSERT INTO `wp_e_submissions_actions_log` VALUES("29", "29", "email", "آدرس ایمیل", "success", NULL, "2023-07-18 18:16:53", "2023-07-18 18:16:53", "2023-07-18 21:46:53", "2023-07-18 21:46:53");
INSERT INTO `wp_e_submissions_actions_log` VALUES("30", "30", "email", "آدرس ایمیل", "success", NULL, "2023-08-31 04:52:42", "2023-08-31 04:52:42", "2023-08-31 08:22:42", "2023-08-31 08:22:42");
INSERT INTO `wp_e_submissions_actions_log` VALUES("31", "31", "email", "آدرس ایمیل", "success", NULL, "2023-08-31 13:53:42", "2023-08-31 13:53:42", "2023-08-31 17:23:42", "2023-08-31 17:23:42");
INSERT INTO `wp_e_submissions_actions_log` VALUES("32", "32", "email", "آدرس ایمیل", "success", NULL, "2023-09-03 20:15:17", "2023-09-03 20:15:17", "2023-09-03 23:45:17", "2023-09-03 23:45:17");
INSERT INTO `wp_e_submissions_actions_log` VALUES("33", "33", "email", "آدرس ایمیل", "success", NULL, "2023-09-17 00:09:50", "2023-09-17 00:09:50", "2023-09-17 03:39:50", "2023-09-17 03:39:50");
INSERT INTO `wp_e_submissions_actions_log` VALUES("34", "34", "email", "آدرس ایمیل", "success", NULL, "2023-09-18 18:21:12", "2023-09-18 18:21:12", "2023-09-18 21:51:12", "2023-09-18 21:51:12");
INSERT INTO `wp_e_submissions_actions_log` VALUES("35", "35", "email", "آدرس ایمیل", "success", NULL, "2023-09-22 18:41:58", "2023-09-22 18:41:58", "2023-09-22 22:11:58", "2023-09-22 22:11:58");
INSERT INTO `wp_e_submissions_actions_log` VALUES("36", "36", "email", "آدرس ایمیل", "success", NULL, "2023-09-26 18:02:54", "2023-09-26 18:02:54", "2023-09-26 21:32:54", "2023-09-26 21:32:54");
INSERT INTO `wp_e_submissions_actions_log` VALUES("37", "37", "email", "آدرس ایمیل", "success", NULL, "2023-10-02 16:35:34", "2023-10-02 16:35:34", "2023-10-02 20:05:34", "2023-10-02 20:05:34");
INSERT INTO `wp_e_submissions_actions_log` VALUES("38", "38", "email", "آدرس ایمیل", "success", NULL, "2023-10-26 07:15:16", "2023-10-26 07:15:16", "2023-10-26 10:45:16", "2023-10-26 10:45:16");
INSERT INTO `wp_e_submissions_actions_log` VALUES("39", "39", "email", "آدرس ایمیل", "success", NULL, "2023-10-30 15:04:29", "2023-10-30 15:04:29", "2023-10-30 18:34:29", "2023-10-30 18:34:29");
INSERT INTO `wp_e_submissions_actions_log` VALUES("40", "40", "email", "آدرس ایمیل", "success", NULL, "2023-11-17 09:42:53", "2023-11-17 09:42:53", "2023-11-17 13:12:53", "2023-11-17 13:12:53");
INSERT INTO `wp_e_submissions_actions_log` VALUES("41", "41", "email", "آدرس ایمیل", "success", NULL, "2024-01-08 11:28:47", "2024-01-08 11:28:47", "2024-01-08 14:58:47", "2024-01-08 14:58:47");
INSERT INTO `wp_e_submissions_actions_log` VALUES("42", "42", "email", "آدرس ایمیل", "success", NULL, "2024-02-17 07:24:03", "2024-02-17 07:24:03", "2024-02-17 10:54:03", "2024-02-17 10:54:03");
INSERT INTO `wp_e_submissions_actions_log` VALUES("43", "43", "email", "آدرس ایمیل", "success", NULL, "2024-02-17 07:24:13", "2024-02-17 07:24:13", "2024-02-17 10:54:13", "2024-02-17 10:54:13");
INSERT INTO `wp_e_submissions_actions_log` VALUES("44", "44", "email", "آدرس ایمیل", "success", NULL, "2024-02-29 06:39:07", "2024-02-29 06:39:07", "2024-02-29 10:09:07", "2024-02-29 10:09:07");
INSERT INTO `wp_e_submissions_actions_log` VALUES("45", "45", "email", "آدرس ایمیل", "success", NULL, "2024-03-20 13:26:15", "2024-03-20 13:26:15", "2024-03-20 16:56:15", "2024-03-20 16:56:15");
INSERT INTO `wp_e_submissions_actions_log` VALUES("46", "46", "email", "آدرس ایمیل", "success", NULL, "2024-03-22 07:13:00", "2024-03-22 07:13:00", "2024-03-22 10:43:00", "2024-03-22 10:43:00");
INSERT INTO `wp_e_submissions_actions_log` VALUES("47", "47", "email", "آدرس ایمیل", "success", NULL, "2024-04-01 16:05:50", "2024-04-01 16:05:50", "2024-04-01 19:35:50", "2024-04-01 19:35:50");
INSERT INTO `wp_e_submissions_actions_log` VALUES("48", "48", "email", "آدرس ایمیل", "success", NULL, "2024-05-08 01:35:04", "2024-05-08 01:35:04", "2024-05-08 05:05:04", "2024-05-08 05:05:04");
INSERT INTO `wp_e_submissions_actions_log` VALUES("49", "49", "email", "آدرس ایمیل", "success", NULL, "2024-07-11 13:12:17", "2024-07-11 13:12:17", "2024-07-11 16:42:17", "2024-07-11 16:42:17");
INSERT INTO `wp_e_submissions_actions_log` VALUES("50", "50", "email", "آدرس ایمیل", "success", NULL, "2024-11-23 07:07:57", "2024-11-23 07:07:57", "2024-11-23 10:37:57", "2024-11-23 10:37:57");

/* INSERT TABLE DATA: wp_e_submissions_values */
INSERT INTO `wp_e_submissions_values` VALUES("1", "1", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("2", "1", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("3", "1", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("4", "1", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("5", "1", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("6", "2", "name", "سشیشس");
INSERT INTO `wp_e_submissions_values` VALUES("7", "2", "field_caef327", "لتالتلا");
INSERT INTO `wp_e_submissions_values` VALUES("8", "2", "field_a531e97", "التلت");
INSERT INTO `wp_e_submissions_values` VALUES("9", "2", "field_13658e8", "050589+5215");
INSERT INTO `wp_e_submissions_values` VALUES("10", "2", "message", "ابلالبا");
INSERT INTO `wp_e_submissions_values` VALUES("11", "3", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("12", "3", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("13", "3", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("14", "3", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("15", "3", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("16", "4", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("17", "4", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("18", "4", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("19", "4", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("20", "4", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("21", "5", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("22", "5", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("23", "5", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("24", "5", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("25", "5", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("26", "6", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("27", "6", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("28", "6", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("29", "6", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("30", "6", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("31", "7", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("32", "7", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("33", "7", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("34", "7", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("35", "7", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("36", "8", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("37", "8", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("38", "8", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("39", "8", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("40", "8", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("41", "9", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("42", "9", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("43", "9", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("44", "9", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("45", "9", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("46", "10", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("47", "10", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("48", "10", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("49", "10", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("50", "10", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("51", "11", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("52", "11", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("53", "11", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("54", "11", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("55", "11", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("56", "12", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("57", "12", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("58", "12", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("59", "12", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("60", "12", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("61", "13", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("62", "13", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("63", "13", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("64", "13", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("65", "13", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("66", "14", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("67", "14", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("68", "14", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("69", "14", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("70", "14", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("71", "15", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("72", "15", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("73", "15", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("74", "15", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("75", "15", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("76", "16", "name", "تست");
INSERT INTO `wp_e_submissions_values` VALUES("77", "16", "field_eb1f139", "تست");
INSERT INTO `wp_e_submissions_values` VALUES("78", "16", "field_dd6e22e", "09120000");
INSERT INTO `wp_e_submissions_values` VALUES("79", "16", "field_d64763d", "تست");
INSERT INTO `wp_e_submissions_values` VALUES("80", "17", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("81", "17", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("82", "17", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("83", "17", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("84", "17", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("85", "18", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("86", "18", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("87", "18", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("88", "18", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("89", "18", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("90", "19", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("91", "19", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("92", "19", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("93", "19", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("94", "19", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("95", "20", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("96", "20", "field_380550f", "");
INSERT INTO `wp_e_submissions_values` VALUES("97", "20", "field_a16caf8", "");
INSERT INTO `wp_e_submissions_values` VALUES("98", "20", "field_eae51a9", "");
INSERT INTO `wp_e_submissions_values` VALUES("99", "20", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("100", "21", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("101", "21", "field_214d3c5", "");
INSERT INTO `wp_e_submissions_values` VALUES("102", "21", "field_9fbe66d", "");
INSERT INTO `wp_e_submissions_values` VALUES("103", "21", "field_510d034", "");
INSERT INTO `wp_e_submissions_values` VALUES("104", "21", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("105", "22", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("106", "22", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("107", "22", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("108", "22", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("109", "22", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("110", "23", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("111", "23", "field_380550f", "");
INSERT INTO `wp_e_submissions_values` VALUES("112", "23", "field_a16caf8", "");
INSERT INTO `wp_e_submissions_values` VALUES("113", "23", "field_eae51a9", "");
INSERT INTO `wp_e_submissions_values` VALUES("114", "23", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("115", "24", "name", "مهدی قلی قلی");
INSERT INTO `wp_e_submissions_values` VALUES("116", "24", "field_d470400", "");
INSERT INTO `wp_e_submissions_values` VALUES("117", "24", "field_015992a", "");
INSERT INTO `wp_e_submissions_values` VALUES("118", "24", "field_33debf8", "");
INSERT INTO `wp_e_submissions_values` VALUES("119", "24", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("120", "25", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("121", "25", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("122", "25", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("123", "25", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("124", "25", "message", "هخحهخحت");
INSERT INTO `wp_e_submissions_values` VALUES("125", "26", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("126", "26", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("127", "26", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("128", "26", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("129", "26", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("130", "27", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("131", "27", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("132", "27", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("133", "27", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("134", "27", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("135", "28", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("136", "28", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("137", "28", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("138", "28", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("139", "28", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("140", "29", "name", "خرس");
INSERT INTO `wp_e_submissions_values` VALUES("141", "29", "field_1053cb5", "موضوع من");
INSERT INTO `wp_e_submissions_values` VALUES("142", "29", "field_58e50d2", "09122222222");
INSERT INTO `wp_e_submissions_values` VALUES("143", "29", "field_9d4e7d2", "توضیحات من");
INSERT INTO `wp_e_submissions_values` VALUES("144", "30", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("145", "30", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("146", "30", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("147", "30", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("148", "30", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("149", "31", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("150", "31", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("151", "31", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("152", "31", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("153", "31", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("154", "32", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("155", "32", "field_214d3c5", "");
INSERT INTO `wp_e_submissions_values` VALUES("156", "32", "field_9fbe66d", "");
INSERT INTO `wp_e_submissions_values` VALUES("157", "32", "field_510d034", "");
INSERT INTO `wp_e_submissions_values` VALUES("158", "32", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("159", "33", "name", "حبیب شاکری");
INSERT INTO `wp_e_submissions_values` VALUES("160", "33", "field_d470400", "");
INSERT INTO `wp_e_submissions_values` VALUES("161", "33", "field_015992a", "گکگگ");
INSERT INTO `wp_e_submissions_values` VALUES("162", "33", "field_33debf8", "");
INSERT INTO `wp_e_submissions_values` VALUES("163", "33", "message", "...");
INSERT INTO `wp_e_submissions_values` VALUES("164", "34", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("165", "34", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("166", "34", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("167", "34", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("168", "34", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("169", "35", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("170", "35", "field_d470400", "");
INSERT INTO `wp_e_submissions_values` VALUES("171", "35", "field_015992a", "");
INSERT INTO `wp_e_submissions_values` VALUES("172", "35", "field_33debf8", "");
INSERT INTO `wp_e_submissions_values` VALUES("173", "35", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("174", "36", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("175", "36", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("176", "36", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("177", "36", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("178", "36", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("179", "37", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("180", "37", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("181", "37", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("182", "37", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("183", "37", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("184", "38", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("185", "38", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("186", "38", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("187", "38", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("188", "38", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("189", "39", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("190", "39", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("191", "39", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("192", "39", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("193", "39", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("194", "40", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("195", "40", "field_d470400", "");
INSERT INTO `wp_e_submissions_values` VALUES("196", "40", "field_015992a", "");
INSERT INTO `wp_e_submissions_values` VALUES("197", "40", "field_33debf8", "");
INSERT INTO `wp_e_submissions_values` VALUES("198", "40", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("199", "41", "name", "ظرنمدظ خذن");
INSERT INTO `wp_e_submissions_values` VALUES("200", "41", "field_eb1f139", ".ک پ");
INSERT INTO `wp_e_submissions_values` VALUES("201", "41", "field_dd6e22e", "5");
INSERT INTO `wp_e_submissions_values` VALUES("202", "41", "field_d64763d", "/");
INSERT INTO `wp_e_submissions_values` VALUES("203", "42", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("204", "42", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("205", "42", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("206", "42", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("207", "42", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("208", "43", "name", "dddd");
INSERT INTO `wp_e_submissions_values` VALUES("209", "43", "field_ef24274", "dddd");
INSERT INTO `wp_e_submissions_values` VALUES("210", "43", "field_a265d77", "ddddd");
INSERT INTO `wp_e_submissions_values` VALUES("211", "43", "field_526305a", "00888080800");
INSERT INTO `wp_e_submissions_values` VALUES("212", "43", "message", "adadad");
INSERT INTO `wp_e_submissions_values` VALUES("213", "44", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("214", "44", "field_d470400", "");
INSERT INTO `wp_e_submissions_values` VALUES("215", "44", "field_015992a", "");
INSERT INTO `wp_e_submissions_values` VALUES("216", "44", "field_33debf8", "");
INSERT INTO `wp_e_submissions_values` VALUES("217", "44", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("218", "45", "name", ";");
INSERT INTO `wp_e_submissions_values` VALUES("219", "45", "field_f4f6c63", "d");
INSERT INTO `wp_e_submissions_values` VALUES("220", "45", "field_70f50e3", "22");
INSERT INTO `wp_e_submissions_values` VALUES("221", "45", "field_47a44de", "2");
INSERT INTO `wp_e_submissions_values` VALUES("222", "45", "field_3b3e0a4", "");
INSERT INTO `wp_e_submissions_values` VALUES("223", "46", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("224", "46", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("225", "46", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("226", "46", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("227", "46", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("228", "47", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("229", "47", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("230", "47", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("231", "47", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("232", "47", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("233", "48", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("234", "48", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("235", "48", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("236", "48", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("237", "48", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("238", "49", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("239", "49", "field_380550f", "");
INSERT INTO `wp_e_submissions_values` VALUES("240", "49", "field_a16caf8", "");
INSERT INTO `wp_e_submissions_values` VALUES("241", "49", "field_eae51a9", "");
INSERT INTO `wp_e_submissions_values` VALUES("242", "49", "message", "");
INSERT INTO `wp_e_submissions_values` VALUES("243", "50", "name", "");
INSERT INTO `wp_e_submissions_values` VALUES("244", "50", "field_ef24274", "");
INSERT INTO `wp_e_submissions_values` VALUES("245", "50", "field_a265d77", "");
INSERT INTO `wp_e_submissions_values` VALUES("246", "50", "field_526305a", "");
INSERT INTO `wp_e_submissions_values` VALUES("247", "50", "message", "");

/* INSERT TABLE DATA: wp_mailpoet_newsletter_option_fields */
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("1", "isScheduled", "standard", NULL, "2021-10-13 09:33:38");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("2", "scheduledAt", "standard", NULL, "2021-10-13 09:33:38");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("3", "event", "welcome", NULL, "2021-10-13 09:33:38");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("4", "segment", "welcome", NULL, "2021-10-13 09:33:38");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("5", "role", "welcome", NULL, "2021-10-13 09:33:38");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("6", "afterTimeNumber", "welcome", NULL, "2021-10-13 09:33:38");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("7", "afterTimeType", "welcome", NULL, "2021-10-13 09:33:38");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("8", "intervalType", "notification", NULL, "2021-10-13 09:33:38");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("9", "timeOfDay", "notification", NULL, "2021-10-13 09:33:38");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("10", "weekDay", "notification", NULL, "2021-10-13 09:33:38");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("11", "monthDay", "notification", NULL, "2021-10-13 09:33:38");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("12", "nthWeekDay", "notification", NULL, "2021-10-13 09:33:38");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("13", "schedule", "notification", NULL, "2021-10-13 09:33:38");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("14", "group", "automatic", NULL, "2021-10-13 09:33:38");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("15", "event", "automatic", NULL, "2021-10-13 09:33:38");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("16", "sendTo", "automatic", NULL, "2021-10-13 09:33:38");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("17", "segment", "automatic", NULL, "2021-10-13 09:33:38");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("18", "afterTimeNumber", "automatic", NULL, "2021-10-13 09:33:38");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("19", "afterTimeType", "automatic", NULL, "2021-10-13 09:33:38");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("20", "meta", "automatic", NULL, "2021-10-13 09:33:38");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("21", "afterTimeNumber", "re_engagement", NULL, "2021-10-13 09:33:38");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("22", "afterTimeType", "re_engagement", NULL, "2021-10-13 09:33:38");

/* INSERT TABLE DATA: wp_mailpoet_newsletter_templates */
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("1", "0", "ایمیل خوش آمد گویی: نمونه خالی با الگوی 1 ستون", "[\"welcome\",\"blank\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"\\u0622\\u0631\\u0645 \\u062c\\u0639\\u0644\\u06cc\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>\\u0633\\u0644\\u0627\\u0645\\u060c \\u0645\\u0634\\u062a\\u0631\\u06a9 \\u062c\\u062f\\u06cc\\u062f!<\\/strong><\\/h1>\\n<p>&nbsp;<\\/p>\\n<p>[subscriber:firstname | default:Subscriber],<\\/p>\\n<p>&nbsp;<\\/p>\\n<p>\\u0634\\u0645\\u0627 \\u0628\\u0647 \\u062a\\u0627\\u0632\\u06af\\u06cc \\u0628\\u0647 \\u0644\\u06cc\\u0633\\u062a \\u0645\\u0627 \\u067e\\u06cc\\u0648\\u0633\\u062a\\u0647 \\u0627\\u06cc\\u062f \\u0648 \\u0645\\u0627 \\u0645\\u06cc \\u062e\\u0648\\u0627\\u0647\\u06cc\\u0645 \\u0627\\u0632 \\u0634\\u0645\\u0627 \\u06cc\\u06a9 \\u0627\\u0633\\u062a\\u0642\\u0628\\u0627\\u0644 \\u06af\\u0631\\u0645 \\u062f\\u0627\\u0634\\u062a\\u0647 \\u0628\\u0627\\u0634\\u06cc\\u0645!<\\/p>\\n<p>&nbsp;<\\/p>\\n<p>\\u0645\\u06cc \\u062e\\u0648\\u0627\\u0647\\u06cc\\u062f \\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a \\u0628\\u0647\\u062a\\u0631\\u06cc \\u0627\\u0632 \\u0645\\u0627 \\u062f\\u0631\\u06cc\\u0627\\u0641\\u062a \\u06a9\\u0646\\u06cc\\u062f\\u061f \\u0628\\u0631\\u062e\\u06cc \\u0627\\u0632 \\u0645\\u062d\\u0628\\u0648\\u0628 \\u062a\\u0631\\u06cc\\u0646 \\u0645\\u0642\\u0627\\u0644\\u0627\\u062a \\u0645\\u0627 \\u0631\\u0627 \\u0628\\u0631\\u0631\\u0633\\u06cc \\u06a9\\u0646\\u06cc\\u062f: <\\/p>\\n<ol>\\n<li><a href=\\\"http:\\/\\/www.mailpoet.com\\/the-importance-of-focus-when-writing\\/\\\">\\u0627\\u0647\\u0645\\u06cc\\u062a \\u062a\\u0645\\u0631\\u06a9\\u0632 \\u0647\\u0646\\u06af\\u0627\\u0645 \\u0646\\u0648\\u0634\\u062a\\u0646<\\/a><\\/li>\\n<li><a href=\\\"http:\\/\\/www.mailpoet.com\\/write-great-subject-line\\/\\\">\\u0686\\u06af\\u0648\\u0646\\u0647 \\u06cc\\u06a9 \\u062e\\u0637 \\u0645\\u0648\\u0636\\u0648\\u0639 \\u0628\\u0631\\u062c\\u0633\\u062a\\u0647 \\u0628\\u0646\\u0648\\u06cc\\u0633\\u06cc\\u0645\\u061f<\\/a><\\/li>\\n<li><a href=\\\"http:\\/\\/www.mailpoet.com\\/just-sit-write-advice-motivation-ernest-hemingway\\/\\\">\\u0641\\u0642\\u0637 \\u0628\\u0646\\u0634\\u06cc\\u0646\\u06cc\\u062f \\u0648 \\u0628\\u0646\\u0648\\u06cc\\u0633\\u06cc\\u062f &ndash;  \\u0645\\u0634\\u0627\\u0648\\u0631\\u0647 \\u062f\\u0631 \\u0645\\u0648\\u0631\\u062f \\u0627\\u0646\\u06af\\u06cc\\u0632\\u0647 \\u0627\\u0632 \\u0627\\u0631\\u0646\\u0633\\u062a \\u0647\\u0645\\u06cc\\u0646\\u06af\\u0648\\u06cc<\\/a><\\/li>\\n<\\/ol>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"24.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/welcome-email-blank-1-column/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("2", "0", "ایمیل خوش آمد گویی: نمونه خالی با الگوی 1:2 ستون", "[\"welcome\",\"blank\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"\\u0622\\u0631\\u0645 \\u062c\\u0639\\u0644\\u06cc\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>\\u0633\\u0644\\u0627\\u0645\\u060c \\u0645\\u0634\\u062a\\u0631\\u06a9 \\u062c\\u062f\\u06cc\\u062f!<\\/strong><\\/h1>\\n<p>&nbsp;<\\/p>\\n<p>[subscriber:firstname | default:Subscriber],<\\/p>\\n<p>&nbsp;<\\/p>\\n<p>\\u0634\\u0645\\u0627 \\u0628\\u0647 \\u062a\\u0627\\u0632\\u06af\\u06cc \\u0628\\u0647 \\u0644\\u06cc\\u0633\\u062a \\u0645\\u0627 \\u067e\\u06cc\\u0648\\u0633\\u062a\\u0647 \\u0627\\u06cc\\u062f \\u0648 \\u0645\\u0627 \\u0645\\u06cc \\u062e\\u0648\\u0627\\u0647\\u06cc\\u0645 \\u0627\\u0632 \\u0634\\u0645\\u0627 \\u06cc\\u06a9 \\u0627\\u0633\\u062a\\u0642\\u0628\\u0627\\u0644 \\u06af\\u0631\\u0645 \\u062f\\u0627\\u0634\\u062a\\u0647 \\u0628\\u0627\\u0634\\u06cc\\u0645!<\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>\\u0645\\u062d\\u0628\\u0648\\u0628 \\u062a\\u0631\\u06cc\\u0646 \\u067e\\u0633\\u062a \\u0647\\u0627\\u06cc \\u0645\\u0627<\\/h3>\"},{\"type\":\"text\",\"text\":\"<ul>\\n<li><a href=\\\"http:\\/\\/www.mailpoet.com\\/the-importance-of-focus-when-writing\\/\\\">\\u0627\\u0647\\u0645\\u06cc\\u062a \\u062a\\u0645\\u0631\\u06a9\\u0632 \\u062f\\u0631 \\u0647\\u0646\\u06af\\u0627\\u0645 \\u0646\\u0648\\u0634\\u062a\\u0646<\\/a><\\/li>\\n<li><a href=\\\"http:\\/\\/www.mailpoet.com\\/write-great-subject-line\\/\\\">\\u0686\\u06af\\u0648\\u0646\\u06af\\u06cc \\u0646\\u0648\\u0634\\u062a\\u0646 \\u06cc\\u06a9 \\u062e\\u0637 \\u0645\\u0648\\u0636\\u0648\\u0639 \\u0628\\u0632\\u0631\\u06af<\\/a><\\/li>\\n<li><a href=\\\"http:\\/\\/www.mailpoet.com\\/just-sit-write-advice-motivation-ernest-hemingway\\/\\\">\\u0641\\u0642\\u0637 \\u0628\\u0646\\u0634\\u06cc\\u0646\\u06cc\\u062f \\u0648 \\u0628\\u0646\\u0648\\u06cc\\u0633\\u06cc\\u062f &ndash;  \\u0645\\u0634\\u0627\\u0648\\u0631\\u0647 \\u062f\\u0631 \\u0645\\u0648\\u0631\\u062f \\u0627\\u0646\\u06af\\u06cc\\u0632\\u0647 \\u0627\\u0632 \\u0627\\u0631\\u0646\\u0633\\u062a \\u0647\\u0645\\u06cc\\u0646\\u06af\\u0648\\u06cc <\\/a><\\/li>\\n<\\/ul>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>\\u0628\\u0639\\u062f\\u06cc \\u0686\\u06cc\\u0633\\u062a\\u061f<\\/h3>\"},{\"type\":\"text\",\"text\":\"<p>\\u06cc\\u06a9 \\u062f\\u06a9\\u0645\\u0647 \\u0628\\u0647 \\u0645\\u0646\\u0638\\u0648\\u0631 \\u062f\\u0639\\u0648\\u062a \\u0628\\u0647 \\u0627\\u0642\\u062f\\u0627\\u0645 \\u0628\\u0647 \\u062e\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647 \\u062e\\u0648\\u062f \\u0627\\u0636\\u0627\\u0641\\u0647 \\u06a9\\u0646\\u06cc\\u062f. \\u0627\\u06cc\\u0646 \\u06a9\\u0627\\u0631 \\u0646\\u0631\\u062e \\u06a9\\u0644\\u06cc\\u06a9 \\u0634\\u062f\\u0646 \\u0627\\u06cc\\u0645\\u06cc\\u0644 \\u0634\\u0645\\u0627 \\u0631\\u0627 \\u0627\\u0641\\u0632\\u0627\\u06cc\\u0634 \\u0645\\u06cc \\u062f\\u0647\\u062f.<\\/p>\"},{\"type\":\"button\",\"text\":\"\\u062f\\u0641\\u0639\\u0627\\u062a \\u0628\\u0627\\u0632\\u062f\\u06cc\\u062f!\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"24.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"26px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/welcome-email-blank-1-2-column/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("3", "0", "Gift Welcome", "[\"welcome\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/gift\\/Gift-Header-1.jpg\",\"alt\":\"Gift-Header-1\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"920px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#e7e7e7\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #dd2d2d;\\\">We\'re so happy you\'re onboard!<\\/span><\\/h2>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra. Pellentesque in interdum eros, a venenatis velit. Fusce finibus convallis augue, ut viverra felis placerat in. <\\/span><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\"><\\/span><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\">Curabitur et commodo ipsum. Mauris tellus metus, tristique vel sollicitudin ut, malesuada in augue. Aliquam ultricies purus vel commodo vehicula.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Get Started\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#dd2d2d\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/gift\\/Gift-Footer.jpg\",\"alt\":\"Gift-Footer\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"920px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"23px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"font-size: 11px; text-align: center;\\\"><span style=\\\"color: #808080;\\\"><strong>Address Line 1<\\/strong><\\/span><\\/p>\\n<p style=\\\"font-size: 11px; text-align: center;\\\"><span style=\\\"color: #808080;\\\"><strong>Address Line 2<\\/strong><\\/span><\\/p>\\n<p style=\\\"font-size: 11px; text-align: center;\\\"><span style=\\\"color: #808080;\\\"><strong>City<\\/strong><\\/span><\\/p>\\n<p style=\\\"font-size: 11px; text-align: center;\\\"><span style=\\\"color: #808080;\\\"><strong>Country<\\/strong><\\/span><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"5.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Instagram.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 11px;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a><span>&nbsp;|&nbsp;<\\/span><a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/p>\"}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#dd2d2d\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#ffffff\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/gift/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("4", "0", "Minimal", "[\"welcome\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"29px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#303c54\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"60px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/minimal\\/Minimal-Logo1.png\",\"alt\":\"Minimal-Logo1\",\"fullWidth\":false,\"width\":\"590px\",\"height\":\"93px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"60px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"80px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: right;\\\"><span style=\\\"color: #8b9cbc;\\\">EST.2009<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"41px\"}}},{\"type\":\"text\",\"text\":\"<h2>Welcome to Minimal, Kim.<\\/h2>\"},{\"type\":\"text\",\"text\":\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra. Pellentesque in interdum eros, a venenatis velit. Fusce finibus convallis augue, ut viverra felis placerat in. Curabitur et commodo ipsum. Mauris tellus metus, tristique vel sollicitudin ut, malesuada in augue. Aliquam ultricies purus vel commodo vehicula. Cras sollicitudin nunc facilisis neque tristique sagittis.<\\/p>\\n<p><\\/p>\\n<p>Maecenas iaculis, lacus malesuada dictum dapibus, justo justo molestie lorem, ac dapibus magna urna vel arcu. Aliquam erat volutpat. Sed bibendum, ipsum sed ullamcorper blandit, eros odio interdum nibh, non venenatis metus lacus vitae lectus.<\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"30px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"2px\",\"borderColor\":\"#d9d9d9\"}}},{\"type\":\"text\",\"text\":\"<h2>Some of our recent stories<\\/h2>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/minimal\\/plasma-stingray111-800x533.jpg\",\"alt\":\"plasma-stingray111-800x533\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"533px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>Story Title Goes Here<\\/h3>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra.<\\/span><\\/p>\\n<p><span><\\/span><\\/p>\\n<p><strong><a href=\\\"https:\\/\\/wordpress.org\\/\\\">Read More<\\/a><\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/minimal\\/gettyimages-578313682-800x533.jpg\",\"alt\":\"gettyimages-578313682-800x533\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"533px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>Story Title Goes Here<\\/h3>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra.<\\/span><\\/p>\\n<p><span><\\/span><\\/p>\\n<p><strong><a href=\\\"https:\\/\\/wordpress.org\\/\\\">Read More<\\/a><\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/minimal\\/5_what_to_do_p352m1141746-800x533.jpg\",\"alt\":\"5_what_to_do_p352m1141746-800x533\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"533px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>Story Title Goes Here<\\/h3>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra.<\\/span><\\/p>\\n<p><span><\\/span><\\/p>\\n<p><strong><a href=\\\"https:\\/\\/wordpress.org\\/\\\">Read More<\\/a><\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f3f3f3\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"47px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/minimal\\/Minimal-Logo-Small.png\",\"alt\":\"Minimal-Logo-Small\",\"fullWidth\":false,\"width\":\"120px\",\"height\":\"23px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-color\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Instagram.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #808080;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #808080;\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a><\\/span><\\/p>\\n<p><span style=\\\"color: #808080;\\\"><a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #808080;\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/span><br \\/><span style=\\\"color: #999999;\\\">\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f3f3f3\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Georgia\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Georgia\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Georgia\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Georgia\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#303c54\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#ffffff\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Button\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"30px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"2px\",\"borderColor\":\"#d9d9d9\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png?mailpoet_version=3.8.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png?mailpoet_version=3.8.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"29px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/minimal/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("5", "0", "New Phone Purchase", "[\"welcome\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#1b1821\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/phone\\/Phone-Logo.png\",\"alt\":\"Phone-Logo\",\"fullWidth\":true,\"width\":\"122px\",\"height\":\"23px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#1b1821\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/phone\\/Phone-Title.png\",\"alt\":\"Phone-Title\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"215px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/phone\\/Phone-Header.jpg\",\"alt\":\"Phone-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"920px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\"><strong>Welcome to your brand new Casia 7200.<\\/strong><\\/span><\\/h3>\\n<p style=\\\"text-align: center;\\\"><strong><span style=\\\"color: #8748d5;\\\">Let\'s get you all set up.<\\/span><\\/strong><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #999999;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra. Pellentesque in interdum eros, a venenatis velit. Fusce finibus convallis augue, ut viverra felis placerat in.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Get Started\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#8748d5\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"159px\",\"lineHeight\":\"45px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#2c2c2c\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"font-size: 11px; text-align: left;\\\"><span style=\\\"color: #999999;\\\">Address Line 1<\\/span><\\/p>\\n<p style=\\\"font-size: 11px; text-align: left;\\\"><span style=\\\"color: #999999;\\\">Address Line 2<\\/span><\\/p>\\n<p style=\\\"font-size: 11px; text-align: left;\\\"><span style=\\\"color: #999999;\\\">City<\\/span><\\/p>\\n<p style=\\\"font-size: 11px; text-align: left;\\\"><span style=\\\"color: #999999;\\\">Country<\\/span><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/phone\\/Phone-Logo.png\",\"alt\":\"Phone-Logo\",\"fullWidth\":false,\"width\":\"122px\",\"height\":\"23px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"pinterest\",\"link\":\"http:\\/\\/www.pinterest.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Pinterest.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Pinterest\"},{\"type\":\"socialIcon\",\"iconType\":\"linkedin\",\"link\":\"http:\\/\\/www.linkedin.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/LinkedIn.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"LinkedIn\"}]}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: right; font-size: 11px;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a><\\/p>\\n<p style=\\\"text-align: right; font-size: 11px;\\\"><a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/p>\"}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#8748d5\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#1b1821\"},\"body\":{\"backgroundColor\":\"#1b1821\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Button\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png?mailpoet_version=3.9.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png?mailpoet_version=3.9.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/phone/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("6", "0", "Sunglasses", "[\"welcome\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/sunglasses\\/Glasses-Logo.jpg\",\"alt\":\"Glasses-Logo\",\"fullWidth\":false,\"width\":\"250px\",\"height\":\"66px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"padding\":\"17px\",\"borderStyle\":\"solid\",\"borderWidth\":\"2px\",\"borderColor\":\"#f8b849\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/sunglasses\\/Glasses-Header-2.jpg\",\"alt\":\"Glasses-Header-2\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"116px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\"><strong>Here\'s what we sent you<\\/strong><\\/span><\\/h3>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/sunglasses\\/Glasses-Images-1.jpg\",\"alt\":\"Glasses-Images-1\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"650px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Choose These Frames\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8b849\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"195px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/sunglasses\\/Glasses-Images-2.jpg\",\"alt\":\"Glasses-Images-2\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"650px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Choose These Frames\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8b849\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"195px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/sunglasses\\/Glasses-Images-3.jpg\",\"alt\":\"Glasses-Images-3\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"650px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Choose These Frames\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8b849\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"195px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"padding\":\"34.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"2px\",\"borderColor\":\"#f8b849\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/sunglasses\\/Glasses-Header.jpg\",\"alt\":\"Glasses-Header\",\"fullWidth\":true,\"width\":\"640px\",\"height\":\"920px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"60px\"}}},{\"type\":\"text\",\"text\":\"<h3><strong>Our Summer Range Is Here<\\/strong><\\/h3>\\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra. Pellentesque in interdum eros, a venenatis velit.<\\/p>\\n<p><\\/p>\\n<p>Fusce finibus convallis augue, ut viverra felis placerat in. Curabitur et commodo ipsum. Mauris tellus metus, tristique vel sollicitudin ut, malesuada in augue.&nbsp;<\\/p>\"},{\"type\":\"button\",\"text\":\"Find Out More\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8b849\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"137px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"padding\":\"34.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"2px\",\"borderColor\":\"#f8b849\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\"><strong>Got any questions or need some help?<\\/strong><\\/span><\\/h2>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\">We\'re just a click or a phone call away.<\\/span><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\"><\\/span><\\/p>\\n<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\"><strong>Call Us:<\\/strong> 08856877854<\\/span><\\/h3>\\n<h3 style=\\\"text-align: center;\\\"><\\/h3>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"padding\":\"23.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"2px\",\"borderColor\":\"#f8b849\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Email.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"}]},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 11px;\\\"><strong><span style=\\\"color: #808080;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #808080;\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a>&nbsp;|&nbsp;<a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #808080;\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/span><\\/strong><br \\/><span style=\\\"color: #808080;\\\">\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/span><\\/p>\"}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#ffffff\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/sunglasses/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("7", "0", "Real Estate", "[\"welcome\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#8691be\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/real-estate\\/Property-Logo-1-150x84.jpg\",\"alt\":\"Property-Logo-1\",\"fullWidth\":false,\"width\":\"150px\",\"height\":\"84px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Website.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#8691be\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><strong><span style=\\\"color: #ffffff;\\\">TAKING&nbsp;THE WORRY OUT OF REAL ESTATE<\\/span><\\/strong><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Welcome Home<\\/span><\\/h1>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/real-estate\\/Property-Header.jpg\",\"alt\":\"Property-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"782px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\">We\'re here to help you move<\\/h3>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/real-estate\\/Property-Icon-1.png\",\"alt\":\"Property-Icon-1\",\"fullWidth\":false,\"width\":\"48px\",\"height\":\"48px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 12px;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex.<\\/span><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/real-estate\\/Property-Icon-2.png\",\"alt\":\"Property-Icon-2\",\"fullWidth\":false,\"width\":\"48px\",\"height\":\"48px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 12px;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex.<\\/span><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/real-estate\\/Property-Icon-3.png\",\"alt\":\"Property-Icon-3\",\"fullWidth\":false,\"width\":\"48px\",\"height\":\"48px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 12px;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex.<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"22.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#8691be\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\">We\'d love to keep you updated with our latest news. <\\/span><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\">Sign up to our newsletter now and you\'ll never miss a thing.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Sign Up Now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#8691be\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"24px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#6a7087\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}},{\"type\":\"footer\",\"text\":\"<p><strong><span style=\\\"color: #ffffff;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #ffffff;\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #ffffff;\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/span><\\/strong><br \\/><span style=\\\"color: #ffffff;\\\">\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"40px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#6a7087\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Button\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png?mailpoet_version=3.8.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png?mailpoet_version=3.8.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/real-estate/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("8", "0", "خوش آمد گویی برنامه", "[\"welcome\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#eeeeee\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#eeeeee\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#32b6c6\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/app_welcome\\/App-Signup-Logo-1.png\",\"alt\":\"App-Signup-Logo\",\"fullWidth\":false,\"width\":\"80px\",\"height\":\"80px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center; margin: 0;\\\"><strong>Welcome to Appy<\\/strong><\\/h1><p style=\\\"text-align: center; margin: 0;\\\"><span style=\\\"color: #ffffff;\\\">Let\'s get started!<\\/span><\\/p>\"},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/app_welcome\\/App-Signup-Header.png\",\"alt\":\"App-Signup-Header\",\"fullWidth\":false,\"width\":\"1280px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Hi [subscriber:firstname | default:subscriber],<\\/p>\\n                                  <p style=\\\"text-align: center;\\\"><\\/p>\\n                                  <p style=\\\"text-align: center;\\\">In MailPoet, you can write emails in plain text, just like in a regular email. This can make your email newsletters more personal and attention-grabbing.<\\/p>\\n                                  <p style=\\\"text-align: center;\\\"><\\/p>\\n                                  <p style=\\\"text-align: center;\\\">Is this too simple? You can still style your text with basic formatting, like <strong>bold<\\/strong> or <em>italics.<\\/em><\\/p>\\n                                  <p style=\\\"text-align: center;\\\"><\\/p>\\n                                  <p style=\\\"text-align: center;\\\">Finally, you can also add a call-to-action button between 2 blocks of text, like this:<\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"23px\"}}},{\"type\":\"button\",\"text\":\"Get Started Here\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#32b6c6\",\"borderColor\":\"#32b6c6\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"188px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/app_welcome\\/App-Signup-Team.jpg\",\"alt\":\"App-Signup-Team\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"700px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#eeeeee\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/app_welcome\\/App-Signup-Logo-Footer.png\",\"alt\":\"App-Signup-Logo-Footer\",\"fullWidth\":false,\"width\":\"50px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 12px;\\\"><strong>Appy<\\/strong><\\/p>\\n                                <p style=\\\"text-align: center; font-size: 12px;\\\"><span>Address Line 1<\\/span><\\/p>\\n                                <p style=\\\"text-align: center; font-size: 12px;\\\"><span>Address Line 2<\\/span><\\/p>\\n                                <p style=\\\"text-align: center; font-size: 12px;\\\"><span>City<\\/span><\\/p>\\n                                <p style=\\\"text-align: center; font-size: 12px;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a><span> | <\\/span><a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/p>\"},{\"type\":\"social\",\"iconSet\":\"full-symbol-color\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#404040\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"26px\"},\"h2\":{\"fontColor\":\"#404040\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"h3\":{\"fontColor\":\"#32b6c6\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#32b6c6\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/app_welcome/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("9", "0", "به فودباکس خوش آمدید", "[\"welcome\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f4f4f4\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/food_box\\/Food-Delivery-Logo.png\",\"alt\":\"Food-Delivery-Logo\",\"fullWidth\":false,\"width\":\"640px\",\"height\":\"180px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/food_box\\/Food-Delivery-App.png\",\"alt\":\"Food-Delivery-App\",\"fullWidth\":false,\"width\":\"640px\",\"height\":\"180px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<h1><strong>Welcome to FoodBox<\\/strong><\\/h1>\\n                                  <h2><strong>Lorem ipsum dolor sit amet<\\/strong><\\/h2>\\n                                  <p>Curabitur sollicitudin eros eu cursus sollicitudin. Suspendisse laoreet sollicitudin urna, ut lacinia risus dictum a. Integer a neque eu magna commodo sodales eu eget ante.<\\/p>\"},{\"type\":\"button\",\"text\":\"Get Started\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#7cc119\",\"borderColor\":\"#7cc119\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"100px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/food_box\\/Food-Delivery-Focus.jpg\",\"alt\":\"Food-Delivery-Focus\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"800px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"31.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"2px\",\"borderColor\":\"#e5e5e5\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\">Get started in 3 simple steps<\\/h2>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/food_box\\/Food-Delivery-1-1.png\",\"alt\":\"Food-Delivery-1\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"250px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur sollicitudin eros eu cursus sollicitudin.<\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/food_box\\/Food-Delivery-2-1.png\",\"alt\":\"Food-Delivery-2\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"250px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"text-align: center;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur sollicitudin eros eu cursus sollicitudin.<\\/span><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/food_box\\/Food-Delivery-3-1.png\",\"alt\":\"Food-Delivery-3\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"250px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"text-align: center;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur sollicitudin eros eu cursus sollicitudin.<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"button\",\"text\":\"Get Started\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#7cc119\",\"borderColor\":\"#7cc119\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"100px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#4599da\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 14px;\\\"><strong><span style=\\\"color: #ffffff;\\\">Link 1 - Link 2 - Link 3 - Link 4<\\/span><\\/strong><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"24px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Website.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#4599da\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f4f4f4\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\"},\"h1\":{\"fontColor\":\"#4599da\",\"fontFamily\":\"Arial\",\"fontSize\":\"26px\"},\"h2\":{\"fontColor\":\"#878787\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\"},\"link\":{\"fontColor\":\"#4599da\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#f4f4f4\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/food_box/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("10", "0", "Poet", "[\"welcome\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ebebeb\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/poet\\/Poet-Header.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ebebeb\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<p><a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#909090\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"144px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/poet\\/Poet-Logo.png\",\"alt\":\"Poet-Logo\",\"fullWidth\":false,\"width\":\"166px\",\"height\":\"144px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h1>Thanks for signing up!<\\/h1>\\n    <p><span style=\\\"color: #000000;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis ut fringilla velit, id malesuada nisi. Nam ac rutrum diam.<\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":\"2_1\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"66px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"font-size: 12px;\\\"><span style=\\\"color: #999999;\\\"><strong>Latest p<\\/strong><\\/span><\\/p>\\n    <h2><strong>The 26th of December<\\/strong><\\/h2>\\n    <h3><span>A Tuesday, day of Tiw,<\\/span><br \\/><span>god of war, dawns in darkness.<\\/span><br \\/><span>The short holiday day of talking by the fire,<\\/span><br \\/><span>floating on snowshoes among<\\/span><br \\/><span>ancient self-pollarded maples,<\\/span><br \\/><span>visiting, being visited, giving<\\/span><br \\/><span>a rain gauge, receiving red socks,<\\/span><br \\/><span>watching snow buntings nearly over<\\/span><br \\/><span>their heads in snow stab at spirtled bits<\\/span><br \\/><span>of sunflower seeds the chickadees<\\/span><br \\/><span>hold with their feet to a bough<\\/span><br \\/><span>and hack apart, scattering debris<\\/span><br \\/><span>like sloppy butchers, is over.<\\/span><br \\/><span>Irregular life begins. Telephone calls,<\\/span><br \\/><span>Google searches, evasive letters,<\\/span><br \\/><span>complicated arrangements, faxes,<\\/span><br \\/><span>second thoughts, consultations,<\\/span><br \\/><span>e-mails, solemnly given kisses.<\\/span><\\/h3>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/poet\\/Poet-Images-1.jpg\",\"alt\":\"Poet-Images\",\"fullWidth\":true,\"width\":\"400px\",\"height\":\"1200px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#393939\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: right;\\\"><span style=\\\"color: #ffffff;\\\">What did you think of this poem? Let me know on one of my social media channels.<\\/span><\\/p>\"},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"styles\":{\"block\":{\"textAlign\":\"right\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\">Poetry books<\\/h1>\\n    <p style=\\\"text-align: center;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis ut fringilla velit, id malesuada nisi. Nam ac rutrum diam.<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/poet\\/Poet-Books-1.png\",\"alt\":\"Poet-Books-1\",\"fullWidth\":false,\"width\":\"220px\",\"height\":\"646px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"button\",\"text\":\"Buy online\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#393939\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/poet\\/Poet-Books-3.png\",\"alt\":\"Poet-Books-3\",\"fullWidth\":false,\"width\":\"600px\",\"height\":\"646px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"button\",\"text\":\"Buy online\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#393939\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/poet\\/Poet-Books-2.png\",\"alt\":\"Poet-Books-2\",\"fullWidth\":false,\"width\":\"600px\",\"height\":\"646px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"button\",\"text\":\"Buy online\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#393939\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/poet\\/Poet-Logo.png\",\"alt\":\"Poet-Logo\",\"fullWidth\":false,\"width\":\"166px\",\"height\":\"144px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#939393\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#333333\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#646464\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#393939\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"24px\"},\"h2\":{\"fontColor\":\"#393939\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"30px\"},\"h3\":{\"fontColor\":\"#646464\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"16px\"},\"link\":{\"fontColor\":\"#393939\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ebebeb\"},\"body\":{\"backgroundColor\":\"#ebebeb\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Buy online\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#393939\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#939393\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#333333\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\",\"styles\":{\"block\":{\"textAlign\":\"right\"}}},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#909090\",\"textDecoration\":\"none\"}},\"type\":\"header\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/poet/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("11", "0", "آگاه ساز پست: نمونه خالی با الگوی 1 ستون", "[\"notification\",\"blank\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"fake-logo\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>\\u067e\\u0633\\u062a \\u0647\\u0627\\u06cc \\u062c\\u062f\\u06cc\\u062f \\u0648\\u0628\\u0644\\u0627\\u06af \\u0645\\u0627 \\u0631\\u0627 \\u0628\\u0631\\u0631\\u0633\\u06cc \\u06a9\\u0646\\u06cc\\u062f! <\\/strong><\\/h1>\\n<p>&nbsp;<\\/p>\\n<p>\\u0645\\u06cc\\u0644 \\u067e\\u0648\\u0626\\u062a \\u0645\\u06cc \\u062a\\u0648\\u0627\\u0646\\u062f <span style=\\\"line-height: 1.6em; background-color: inherit;\\\"><em>\\u0628\\u0635\\u0648\\u0631\\u062a \\u0627\\u062a\\u0648\\u0645\\u0627\\u062a\\u06cc\\u06a9<\\/em> <\\/span><span style=\\\"line-height: 1.6em; background-color: inherit;\\\">\\u067e\\u0633\\u062a \\u0647\\u0627\\u06cc \\u062c\\u062f\\u06cc\\u062f \\u0648\\u0628\\u0644\\u0627\\u06af \\u0634\\u0645\\u0627 \\u0631\\u0627 \\u0628\\u0647 \\u0645\\u0634\\u062a\\u0631\\u06a9\\u0627\\u0646\\u062a\\u0627\\u0646 \\u0627\\u0631\\u0633\\u0627\\u0644 \\u06a9\\u0646\\u062f!<\\/span><\\/p>\\n<p><span style=\\\"line-height: 1.6em; background-color: inherit;\\\"><\\/span><\\/p>\\n<p><span style=\\\"line-height: 1.6em; background-color: inherit;\\\">\\u062f\\u0631 \\u0632\\u06cc\\u0631\\u060c \\u0645\\u06cc \\u062a\\u0648\\u0627\\u0646\\u06cc\\u062f \\u0633\\u0647 \\u067e\\u0633\\u062a \\u0622\\u062e\\u0631\\u06cc \\u0631\\u0627 \\u06a9\\u0647 \\u0628\\u0635\\u0648\\u0631\\u062a \\u0627\\u062a\\u0648\\u0645\\u0627\\u062a\\u06cc\\u06a9 \\u0646\\u0645\\u0627\\u06cc\\u0634 \\u062f\\u0627\\u062f\\u0647 \\u0634\\u062f\\u0647 \\u0631\\u0627 \\u067e\\u06cc\\u062f\\u0627 \\u06a9\\u0646\\u06cc\\u062f, \\u0628\\u0647 \\u0644\\u0637\\u0641 \\u0648\\u06cc\\u062c\\u062a <em>\\u0622\\u062e\\u0631\\u06cc\\u0646 \\u0645\\u062d\\u062a\\u0648\\u0627\\u06cc \\u0627\\u062a\\u0648\\u0645\\u0627\\u062a\\u06cc\\u06a9<\\/em> , \\u06a9\\u0647 \\u0645\\u06cc \\u062a\\u0648\\u0627\\u0646\\u06cc\\u062f \\u0622\\u0646\\u0631\\u0627 \\u062f\\u0631 \\u0646\\u0648\\u0627\\u0631 \\u06a9\\u0646\\u0627\\u0631\\u06cc \\u0633\\u0645\\u062a \\u0631\\u0627\\u0633\\u062a \\u067e\\u06cc\\u062f\\u0627 \\u06a9\\u0646\\u06cc\\u062f, \\u0632\\u06cc\\u0631 <em>\\u0645\\u062d\\u062a\\u0648\\u0627<\\/em>.<\\/span><\\/p>\\n<p><span style=\\\"line-height: 1.6em; background-color: inherit;\\\"><\\/span><\\/p>\\n<p><span style=\\\"line-height: 1.6em; background-color: inherit;\\\">\\u0628\\u0631\\u0627\\u06cc \\u0648\\u06cc\\u0631\\u0627\\u06cc\\u0634 \\u062a\\u0646\\u0638\\u06cc\\u0645\\u0627\\u062a \\u0648 \\u0633\\u0628\\u06a9 \\u067e\\u0633\\u062a \\u0647\\u0627\\u060c \\u0628\\u0647 \\u0633\\u0627\\u062f\\u06af\\u06cc \\u06a9\\u0644\\u06cc\\u06a9 \\u06a9\\u0646\\u06cc\\u062f \\u0628\\u0631 \\u0631\\u0648\\u06cc \\u06cc\\u06a9 \\u067e\\u0633\\u062a \\u062f\\u0631 \\u0632\\u06cc\\u0631.<\\/span><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"3\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"\\u0646\\u0648\\u06cc\\u0633\\u0646\\u062f\\u0647:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"\\u062f\\u0633\\u062a\\u0647 \\u0647\\u0627:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"\\u062e\\u0648\\u0627\\u0646\\u062f\\u0646 \\u067e\\u0633\\u062a\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"160px\",\"lineHeight\":\"30px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"24.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/post-notifications-blank-1-column/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("12", "0", "Modular Style Stories", "[\"notification\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/modular-style-stories\\/Modular-Logo.png\",\"alt\":\"Modular-Logo\",\"fullWidth\":false,\"width\":\"271px\",\"height\":\"37px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"26px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-color\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Instagram.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"pinterest\",\"link\":\"http:\\/\\/www.pinterest.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Pinterest.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Pinterest\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\",\"height\":\"40px\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"3\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#ffffff\",\"borderWidth\":\"1px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"120px\",\"lineHeight\":\"40px\",\"fontColor\":\"#b956c5\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"context\":\"automatedLatestContentLayout.readMoreButton\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"3px\",\"borderColor\":\"#efe7f0\"}},\"context\":\"automatedLatestContentLayout.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#b956c5\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/ladybirds-transparent-shell-reveals-how-it-folds-its-wings\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/modular-style-stories\\/gettyimages-578313682-800x533.jpg\",\"alt\":\"Ladybird\\u2019s transparent shell reveals how it folds its wings\",\"fullWidth\":false,\"width\":660,\"height\":440,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong>Ladybird&rsquo;s transparent shell reveals how it folds its wings<\\/strong><\\/h3>\\n<p class=\\\"mailpoet_wp_post\\\">They certainly know how to fold. A see-through artificial wing case has been used to watch for the first time as ladybirds put away their wings after flight.<\\/p>\"},{\"type\":\"button\",\"text\":\"Read More\",\"url\":\"http:\\/\\/mailpoet.info\\/ladybirds-transparent-shell-reveals-how-it-folds-its-wings\\/\",\"styles\":{\"block\":{\"backgroundColor\":\"#b956c5\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"103px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/plasma-jet-engines-that-could-take-you-from-the-ground-to-space\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/modular-style-stories\\/plasma-stingray111-800x533.jpg\",\"alt\":\"Plasma jet engines that could take you from the ground to space\",\"fullWidth\":false,\"width\":660,\"height\":440,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong>Plasma jet engines that could take you from ground to space<\\/strong><\\/h3>\\n<p class=\\\"mailpoet_wp_post\\\">FORGET fuel-powered jet engines. We&rsquo;re on the verge of having aircraft that can fly from the ground up to the edge of space using air and electricity alone.<\\/p>\"},{\"type\":\"button\",\"text\":\"Read More\",\"url\":\"http:\\/\\/mailpoet.info\\/plasma-jet-engines-that-could-take-you-from-the-ground-to-space\\/\",\"styles\":{\"block\":{\"backgroundColor\":\"#b956c5\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"103px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/cutting-through-the-smog-what-to-do-to-fight-air-pollution\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/modular-style-stories\\/5_what_to_do_p352m1141746-800x533.jpg\",\"alt\":\"Cutting through the smog: What to do to fight air pollution\",\"fullWidth\":false,\"width\":660,\"height\":440,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\"><strong>Cutting through the smog: What to do to fight air pollution<\\/strong><\\/span><\\/h3>\"},{\"type\":\"button\",\"text\":\"Read More\",\"url\":\"http:\\/\\/mailpoet.info\\/cutting-through-the-smog-what-to-do-to-fight-air-pollution\\/\",\"styles\":{\"block\":{\"backgroundColor\":\"#b956c5\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"103px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/ladybirds-transparent-shell-reveals-how-it-folds-its-wings\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/modular-style-stories\\/gettyimages-578313682-800x533.jpg\",\"alt\":\"Ladybird\\u2019s transparent shell reveals how it folds its wings\",\"fullWidth\":false,\"width\":660,\"height\":440,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\"><strong>Ladybird&rsquo;s transparent shell reveals how it folds its wings<\\/strong><\\/span><\\/h3>\"},{\"type\":\"button\",\"text\":\"Read More\",\"url\":\"http:\\/\\/mailpoet.info\\/ladybirds-transparent-shell-reveals-how-it-folds-its-wings\\/\",\"styles\":{\"block\":{\"backgroundColor\":\"#b956c5\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"103px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/plasma-jet-engines-that-could-take-you-from-the-ground-to-space\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/modular-style-stories\\/plasma-stingray111-800x533.jpg\",\"alt\":\"Plasma jet engines that could take you from the ground to space\",\"fullWidth\":false,\"width\":660,\"height\":440,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\"><strong>Plasma jet engines that could take you from the ground to space<\\/strong><\\/span><\\/h3>\"},{\"type\":\"button\",\"text\":\"Read More\",\"url\":\"http:\\/\\/mailpoet.info\\/plasma-jet-engines-that-could-take-you-from-the-ground-to-space\\/\",\"styles\":{\"block\":{\"backgroundColor\":\"#b956c5\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"103px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#b956c5\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"21px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Website.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #ffffff;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #ffffff;\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #ffffff;\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/span><br \\/><span style=\\\"color: #ffffff;\\\">\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"26px\"},\"h3\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"20px\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#b956c5\"},\"body\":{\"backgroundColor\":\"#efe7f0\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"2\",\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":true,\"featuredImagePosition\":\"aboveTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"116px\",\"lineHeight\":\"40px\",\"fontColor\":\"#b956c5\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"3px\",\"borderColor\":\"#ffffff\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContent\",\"terms\":[],\"withLayout\":false},\"automatedLatestContentLayout\":{\"amount\":\"3\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#ffffff\",\"borderWidth\":\"1px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"120px\",\"lineHeight\":\"40px\",\"fontColor\":\"#b956c5\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"3px\",\"borderColor\":\"#efe7f0\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"container\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":true,\"featuredImagePosition\":\"aboveTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"posts\",\"offset\":0,\"terms\":[],\"search\":\"\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png?mailpoet_version=3.7.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png?mailpoet_version=3.7.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\",\"height\":\"40px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/modular-style-stories/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("13", "0", "Stripped RSS Style Layout", "[\"notification\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f4f4f4\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/rss-simple-news\\/RSS-Logo-2.png\",\"alt\":\"RSS-Logo-2\",\"fullWidth\":true,\"width\":\"210px\",\"height\":\"90px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"24px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-color\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Website.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong><span style=\\\"color: #333333;\\\">Latest RSS Simple&nbsp;Posts<\\/span><\\/strong><\\/h3>\\n<p><span style=\\\"color: #999999;\\\">Week 23: 23\\/19\\/19<\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"5\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":true,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more.\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"context\":\"automatedLatestContentLayout.readMoreButton\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#ececec\"}},\"context\":\"automatedLatestContentLayout.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f4f4f4\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<p><span style=\\\"color: #808080;\\\"><strong>RSS Simple<\\/strong><\\/span><\\/p>\\n<p><span style=\\\"color: #808080; font-size: 11px;\\\"><strong><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a><span>&nbsp;|&nbsp;<\\/span><a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/strong><\\/span><\\/p>\\n<p><span style=\\\"color: #808080; font-size: 11px;\\\"><strong><span>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/span><\\/strong><\\/span><\\/p>\"}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#3478f5\",\"fontFamily\":\"Arial\",\"fontSize\":\"20px\"},\"link\":{\"fontColor\":\"#3478f5\",\"textDecoration\":\"none\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#f4f4f4\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"3\",\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":true,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#efe7f0\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContent\",\"terms\":[],\"withLayout\":false},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":true,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more.\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#ececec\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"container\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png?mailpoet_version=3.7.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png?mailpoet_version=3.7.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/rss-simple-news/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("14", "0", "One Full Post In An Email", "[\"notification\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/not-so-medium\\/Not-So-Medium-Logo.png\",\"alt\":\"Not-So-Medium-Logo\",\"fullWidth\":false,\"width\":\"210px\",\"height\":\"90px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Website.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ebebeb\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p><strong><em>Welcome to this week\'s post. <\\/em><\\/strong><\\/p>\\n<p><em>Every Friday, we send you the most interesting story&nbsp;of the week in full.<\\/em><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#d6d6d6\",\"height\":\"20px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"63px\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"1\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"full\",\"titleFormat\":\"h1\",\"titleAlignment\":\"center\",\"titleIsLink\":true,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"aboveText\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"aboveText\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"View this post online & share!\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"context\":\"automatedLatestContentLayout.readMoreButton\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}},\"context\":\"automatedLatestContentLayout.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ebebeb\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><strong><em>Share this with your friends<\\/em><\\/strong><\\/p>\\n<p style=\\\"text-align: center;\\\"><em>We promise not to spam anyone, and we only send our great articles to any email addresses in our list. Promise!<\\/em><\\/p>\"},{\"type\":\"social\",\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"google-plus\",\"link\":\"http:\\/\\/plus.google.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Google-Plus.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Google Plus\"},{\"type\":\"socialIcon\",\"iconType\":\"linkedin\",\"link\":\"http:\\/\\/www.linkedin.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/LinkedIn.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"LinkedIn\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Email.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"}]},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#d6d6d6\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"footer\",\"text\":\"<p><strong><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/strong><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#2c2c2c\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Georgia\",\"fontSize\":\"18px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#ffffff\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"1\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"full\",\"titleFormat\":\"h1\",\"titleAlignment\":\"center\",\"titleIsLink\":true,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"aboveText\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"aboveText\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"View this post online & share!\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"container\":{\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png?mailpoet_version=3.9.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png?mailpoet_version=3.9.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"63px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/not-so-medium/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("15", "0", "Wide Story Layout", "[\"notification\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f0f0f0\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"50px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/wide-story-layout\\/Wide-Logo.png\",\"alt\":\"Wide-Logo\",\"fullWidth\":false,\"width\":\"200px\",\"height\":\"37px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #808080;\\\">Our Latest Posts<\\/span><\\/h3>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"3\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read The Post\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#5ecd39\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"36px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Lucida\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"context\":\"automatedLatestContentLayout.readMoreButton\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#f0f0f0\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"30px\",\"borderColor\":\"#f0f0f0\"}},\"context\":\"automatedLatestContentLayout.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/wide-story-layout\\/Wide-Footer.jpg\",\"alt\":\"Wide-Footer\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"721px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#5ecd39\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"21px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Website.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #ffffff;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #ffffff;\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #ffffff;\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/span><br \\/><span style=\\\"color: #ffffff;\\\">\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Lucida\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Lucida\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Lucida\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#5ecd39\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#f0f0f0\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"3\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read The Post\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#5ecd39\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"36px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Lucida\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#f0f0f0\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"30px\",\"borderColor\":\"#f0f0f0\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read The Post\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#5ecd39\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"36px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Lucida\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"container\":{\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png?mailpoet_version=3.11.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png?mailpoet_version=3.11.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"40px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/wide-story-layout/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("16", "0", "Industry Conference", "[\"notification\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"50px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Conf-Logo.png\",\"alt\":\"Conf-Logo\",\"fullWidth\":false,\"width\":\"150px\",\"height\":\"150px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff; font-size: 11px; text-transform: uppercase; opacity: 0.5; letter-spacing: 3px;\\\">Get ready for the biggest email conference of the year<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":\"2_1\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Conf-Header-2.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"56px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Conf-Ticket.png\",\"alt\":\"Conf-Ticket\",\"fullWidth\":false,\"width\":\"339px\",\"height\":\"177px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}},{\"type\":\"text\",\"text\":\"<h3><span style=\\\"font-size: 42px;\\\"><strong><span style=\\\"color: #ffffff; line-height: 1.2; position: relative; top: -5px;\\\">Email Boston 2018<\\/span><\\/strong><\\/span><\\/h3>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"133px\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"3\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"right\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read the post\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#b8291e\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"147px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Georgia\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}},\"context\":\"automatedLatestContentLayout.readMoreButton\"},\"sortBy\":\"oldest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"4px\",\"borderColor\":\"#dddddd\"}},\"context\":\"automatedLatestContentLayout.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Conf-Bottom-2.png\",\"alt\":\"Conf-Bottom\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#222222\",\"height\":\"34px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Industry-Coupon.png\",\"display\":\"fit\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"75px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">---<\\/span><\\/h3>\\n    <h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Grab 20% off your tickets right now<\\/span><\\/h3>\\n    <p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">We\'re offering an exclusive 20% off tickets with this coupon code!<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"CouPon_Code\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#b8291e\",\"borderColor\":\"#ffffff\",\"borderWidth\":\"3px\",\"borderRadius\":\"14px\",\"borderStyle\":\"solid\",\"width\":\"229px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"26px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"33px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"45px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#222222\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Conf-Top.png\",\"alt\":\"Conf-Top\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"12px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"padding\":\"14px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"7px\",\"borderColor\":\"#e1e1e1\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Conf-Holding.jpg\",\"alt\":\"Conf-Holding\",\"fullWidth\":false,\"width\":\"1000px\",\"height\":\"667px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"46px\"}}},{\"type\":\"text\",\"text\":\"<h3><strong>Check out&nbsp;this year\'s event<\\/strong><\\/h3>\\n    <p>We\'ve ramped up everything this year for our conference, including amazing new speakers and guests, and a few surprises for everyone.<\\/p>\"},{\"type\":\"button\",\"text\":\"Buy a ticket here\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#b8291e\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"147px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Georgia\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"padding\":\"1.5px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"7px\",\"borderColor\":\"#e1e1e1\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Conf-Bottom-2.png\",\"alt\":\"Conf-Bottom\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#222222\",\"height\":\"30px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#222222\",\"height\":\"20px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Email.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"header\",\"text\":\"<p>&nbsp;<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#8d8d8d\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"underline\"}}},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #b8291e;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #b8291e;\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #b8291e;\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/span><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arvo\",\"fontSize\":\"40px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arvo\",\"fontSize\":\"26px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arvo\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#b8291e\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#222222\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"3\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"right\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read the post\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#b8291e\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"147px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Georgia\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}},\"type\":\"button\"},\"sortBy\":\"oldest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"4px\",\"borderColor\":\"#dddddd\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read the post\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#b8291e\",\"borderColor\":\"#ffffff\",\"borderWidth\":\"3px\",\"borderRadius\":\"14px\",\"borderStyle\":\"solid\",\"width\":\"229px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"26px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"#222222\",\"padding\":\"1.5px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"7px\",\"borderColor\":\"#515151\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Email.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"75px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#8d8d8d\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/industry-conference/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("17", "0", "هفته نامه علمی", "[\"notification\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Science-Logo.png\",\"alt\":\"Science-Logo\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"300px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Health-Mag-Title-22.png\",\"alt\":\"Health-Mag-Title-2\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"214px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#b1b6d1\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\"><strong>The latest news from the world of science<\\/strong><\\/span><\\/h1>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"40px\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"2\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\",\"borderColor\":\"#2b2d37\",\"borderWidth\":\"1px\",\"borderRadius\":\"21px\",\"borderStyle\":\"solid\",\"width\":\"114px\",\"lineHeight\":\"33px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}},\"context\":\"automatedLatestContentLayout.readMoreButton\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"context\":\"automatedLatestContentLayout.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#b1b6d1\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Health-Mag-End-1.png\",\"alt\":\"Health-Mag-End\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\",\"height\":\"35px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Health-Mag-Promo-Start.png\",\"alt\":\"Health-Mag-Promo-Start\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"50px\"}}},{\"type\":\"text\",\"text\":\"<h2><strong>Download our app!<\\/strong><\\/h2>\\n                      <p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed in odio dui. Duis et dolor nec erat dictum laoreet. Morbi dapibus turpis id eros viverra tempor. <\\/span><\\/p>\\n                      <p><span><\\/span><\\/p>\\n                      <p><span>Fusce et diam ac sapien posuere luctus. Etiam in vehicula metus, ac viverra elit. Duis diam lacus, molestie vel enim non, rutrum placerat massa. Suspendisse a elit tincidunt, egestas lacus at, maximus diam. <\\/span><\\/p>\\n                      <p><span><\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Download Now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\",\"borderColor\":\"#2b2d37\",\"borderWidth\":\"1px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"144px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Health-Mag-Phone.png\",\"alt\":\"Health-Mag-Phone\",\"fullWidth\":false,\"width\":\"400px\",\"height\":\"573px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Health-Mag-Promo-End.png\",\"alt\":\"Health-Mag-Promo-End\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\",\"height\":\"35px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Health-Mag-Promo-Start.png\",\"alt\":\"Health-Mag-Promo-Start\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\">Keep In Touch With Us<\\/h3>\"},{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png?mailpoet_version=3.11.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png?mailpoet_version=3.11.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Health-Mag-Promo-End.png\",\"alt\":\"Health-Mag-Promo-End\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\",\"height\":\"26px\"}}},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #b1b6d1;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #b1b6d1;\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #b1b6d1;\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/span><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\"},\"text\":{\"fontColor\":\"#d6d6d6\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\",\"height\":\"40px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"26px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"20px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#2b2d37\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"2\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\",\"borderColor\":\"#2b2d37\",\"borderWidth\":\"1px\",\"borderRadius\":\"21px\",\"borderStyle\":\"solid\",\"width\":\"114px\",\"lineHeight\":\"33px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"container\":{\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png?mailpoet_version=3.11.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png?mailpoet_version=3.11.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"40px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/science_weekly/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("18", "0", "Newspaper Traditional", "[\"notification\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f2f9f8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"28px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"font-size: 15px;\\\"><em><strong>[date:mtext][date:dordinal],[date:y]<\\/strong><\\/em><\\/h3>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"header\",\"text\":\"<p><span style=\\\"color: #008080;\\\"><a href=\\\"[link:newsletter_view_in_browser_url]\\\" style=\\\"color: #008080;\\\">View this in your browser.<\\/a><\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"columnLayout\":\"2_1\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f2f9f8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/newspaper-traditional\\/News-Logo.png\",\"alt\":\"News-Logo\",\"fullWidth\":false,\"width\":\"200px\",\"height\":\"100px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png?mailpoet_version=3.12.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png?mailpoet_version=3.12.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Website.png?mailpoet_version=3.12.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png?mailpoet_version=3.12.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#c6dbd8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p><strong>Local News<\\/strong><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><strong>Sports&nbsp;Updates &amp; Scores<\\/strong><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: right;\\\"><strong>Business News<\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: left;\\\"><strong>Check Out Our New Blog Posts! <\\/strong><\\/h1>\\n    <p style=\\\"text-align: left;\\\">&nbsp;<\\/p>\\n    <p style=\\\"text-align: left;\\\">MailPoet can <span style=\\\"line-height: 1.6em; background-color: inherit;\\\"><em>automatically<\\/em> <\\/span><span style=\\\"line-height: 1.6em; background-color: inherit;\\\">send your new blog posts to your subscribers.<\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"line-height: 1.6em; background-color: inherit;\\\"><\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"line-height: 1.6em; background-color: inherit;\\\">Below, you\'ll find three recent posts, which are displayed automatically, thanks to the <em>Automatic Latest Content<\\/em> widget, which can be found in the right sidebar, under <em>Content<\\/em>.<\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"line-height: 1.6em; background-color: inherit;\\\"><\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"line-height: 1.6em; background-color: inherit;\\\">To edit the settings and styles of your post, simply click on a post below.<\\/span><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"double\",\"borderWidth\":\"7px\",\"borderColor\":\"#c6dbd8\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"3\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":true,\"imageFullWidth\":false,\"featuredImagePosition\":\"left\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read the post\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"160px\",\"lineHeight\":\"30px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"double\",\"borderWidth\":\"7px\",\"borderColor\":\"#c6dbd8\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#c6dbd8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#c6dbd8\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#c6dbd8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#c6dbd8\",\"height\":\"28px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/newspaper-traditional\\/News-Logo.png\",\"alt\":\"News-Logo\",\"fullWidth\":false,\"width\":\"200px\",\"height\":\"100px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #458687;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #458687;\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #458687;\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/span><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Email.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#c6dbd8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#c6dbd8\",\"height\":\"21px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Playfair Display\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"26px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"22px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#3d8076\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#f2f9f8\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"3\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":true,\"imageFullWidth\":false,\"featuredImagePosition\":\"left\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read the post\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"160px\",\"lineHeight\":\"30px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"double\",\"borderWidth\":\"7px\",\"borderColor\":\"#c6dbd8\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read the post\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"double\",\"borderWidth\":\"7px\",\"borderColor\":\"#c6dbd8\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Email.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/newspaper-traditional/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("19", "0", "Clear News", "[\"notification\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"27px\"}}},{\"type\":\"header\",\"text\":\"<p><a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"11px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#e2973f\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/clear-news\\/News-Logo-1.png\",\"alt\":\"News-Logo\",\"fullWidth\":false,\"width\":\"120px\",\"height\":\"167px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: right;\\\"><span style=\\\"color: #808080;\\\"><strong>October 2018<\\/strong><\\/span><\\/h3>\"}]}]},{\"type\":\"container\",\"columnLayout\":\"2_1\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: left; line-height: 1.3;\\\"><strong>Good Morning!<\\/strong><\\/h1>\\n    <h3>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce egestas nisl vel ante finibus fringilla ullamcorper non lectus. Aenean leo neque, egestas et lacus eu, viverra luctus nisi. Donec dapibus mauris at fringilla consequat. Cras sed porta nunc. Ut tincidunt luctus felis sed suscipit. Sed tristique faucibus fermentum.<\\/h3>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"24px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/clear-news\\/UEl2.gif\",\"alt\":\"UEl2\",\"fullWidth\":false,\"width\":\"360px\",\"height\":\"400px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#e2973f\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2><strong>Today\'s Top Stories<\\/strong><\\/h2>\"}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"3\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":true,\"featuredImagePosition\":\"left\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#e2973f\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"110px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}},\"context\":\"automatedLatestContentLayout.readMoreButton\"},\"sortBy\":\"newest\",\"showDivider\":false,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"context\":\"automatedLatestContentLayout.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#e2973f\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2><strong>We cover all types of news<\\/strong><\\/h2>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"World\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#e23f3f\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Business\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#50b6ce\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Politics\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#506dce\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Sports\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#e1bc2d\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Science\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#a650ce\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Health\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#64b03c\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Family\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#278f6e\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Arts\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#7c5e5e\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Local\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#4d4d4d\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":\"1_2\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/clear-news\\/News-Crossword.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"60px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: right;\\\"><span style=\\\"color: #ffffff;\\\">The Friday Crossword<\\/span><\\/h2>\\n    <p style=\\\"text-align: right;\\\"><span style=\\\"color: #ffffff;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum vitae ornare elit. Duis laoreet justo sed fringilla maximus. Aenean pharetra nec risus a vestibulum.<\\/span><\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Get started\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#e2973f\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"110px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"right\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"22px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"34.5px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#e2973f\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/clear-news\\/News-Logo-1.png\",\"alt\":\"News-Logo\",\"fullWidth\":false,\"width\":\"120px\",\"height\":\"167px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><strong><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a><\\/strong><\\/p>\\n    <p style=\\\"text-align: center;\\\"><strong><a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/strong><\\/p>\"},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Add your postal address!<\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"social\",\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"}]},{\"type\":\"social\",\"iconSet\":\"default\",\"icons\":[]}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Source Sans Pro\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"40px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"16px\"},\"link\":{\"fontColor\":\"#e2973f\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#ffffff\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"3\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":true,\"featuredImagePosition\":\"left\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#e2973f\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"110px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":false,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#4d4d4d\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"34.5px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#e2973f\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"13px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#e2973f\",\"textDecoration\":\"underline\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"titleOnly\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":true,\"featuredImagePosition\":\"centered\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"http:\\/\\/mailpoet.info\\/ladybirds-transparent-shell-reveals-how-it-folds-its-wings\\/\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#e2973f\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"110px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":false,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"posts\",\"offset\":0,\"terms\":[],\"search\":\"\"},\"social\":{\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"11px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#e2973f\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/clear-news/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("20", "0", "Dog Food", "[\"woocommerce\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/dog-food\\/Dog-Logo.png\",\"alt\":\"Dog-Logo\",\"fullWidth\":false,\"width\":\"42px\",\"height\":\"91px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"31px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"line-height: 1.2em;\\\"><strong>Thanks for buying your dog food from us<\\/strong><\\/h1>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/dog-food\\/Dog-Header-1024x409.jpg\",\"alt\":\"Dog-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"511px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"50px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>Here\'s some other pawsome things to try...&nbsp;<\\/strong><\\/h2>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/dog-food\\/Dog-Product-1.jpg\",\"alt\":\"Dog-Product-1\",\"fullWidth\":false,\"width\":\"500px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3><strong>Dog Jumper<\\/strong><\\/h3>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam a elementum ex.<\\/span><\\/p>\\n<p><span><strong><\\/strong><\\/span><\\/p>\\n<p><em><strong>$19.99<\\/strong><\\/em><\\/p>\"},{\"type\":\"button\",\"text\":\"Check it out\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f6f6f6\",\"borderColor\":\"#000000\",\"borderWidth\":\"3px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"113px\",\"lineHeight\":\"28px\",\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/dog-food\\/Dog-Product-2.jpg\",\"alt\":\"Dog-Product-2\",\"fullWidth\":false,\"width\":\"500px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3><strong>Dog&nbsp;Socks<\\/strong><\\/h3>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam a elementum ex.<\\/span><\\/p>\\n<p><span><\\/span><\\/p>\\n<p><span><em><strong>$19.99<\\/strong><\\/em><\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Check it out\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f6f6f6\",\"borderColor\":\"#000000\",\"borderWidth\":\"3px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"113px\",\"lineHeight\":\"28px\",\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/dog-food\\/Dog-Product-3.jpg\",\"alt\":\"Dog-Product-3\",\"fullWidth\":false,\"width\":\"500px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3><strong>Glow Collar<\\/strong><\\/h3>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam a elementum ex.<\\/span><\\/p>\\n<p><em><\\/em><\\/p>\\n<p><em><strong>$19.99<\\/strong><\\/em><\\/p>\"},{\"type\":\"button\",\"text\":\"Check it out\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f6f6f6\",\"borderColor\":\"#000000\",\"borderWidth\":\"3px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"113px\",\"lineHeight\":\"28px\",\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#000000\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"45px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}},{\"type\":\"text\",\"text\":\"<h3><strong><\\/strong><span style=\\\"color: #ffffff;\\\">Our Guarantee<\\/span><\\/h3>\\n<p><span style=\\\"color: #ffffff;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam a elementum ex. Aliquam mollis metus ac nisl luctus pulvinar. Donec tincidunt pharetra sem, nec eleifend augue. Morbi id nunc commodo, tempor erat et, pretium neque. Vivamus ante sapien, consequat vitae ante quis, facilisis pellentesque mi. Praesent at scelerisque leo. Donec elementum mi consequat, ultrices lorem nec, vestibulum arcu. Aenean id libero vitae felis consequat maximus<\\/span><\\/p>\\n<p><span style=\\\"color: #ffffff;\\\"><em><\\/em><\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#d4d4d4\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#d4d4d4\",\"height\":\"20px\"}}},{\"type\":\"footer\",\"text\":\"<p><strong><em><span style=\\\"color: #000000;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #000000;\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #000000;\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/span><\\/em><\\/strong><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"40px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#d4d4d4\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Check it out\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f6f6f6\",\"borderColor\":\"#000000\",\"borderWidth\":\"3px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"113px\",\"lineHeight\":\"28px\",\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"#d4d4d4\",\"height\":\"20px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/dog-food/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("21", "0", "Abandoned Cart – Kids", "[\"woocommerce\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"#c3e1e8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"#c3e1e8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"social\",\"iconSet\":\"circles\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/kids-clothing\\/Kids-Clothing-Logo.png\",\"alt\":\"Kids-Clothing-Logo\",\"fullWidth\":true,\"width\":\"250px\",\"height\":\"121px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"social\",\"iconSet\":\"circles\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"google-plus\",\"link\":\"http:\\/\\/plus.google.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Google-Plus.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Google Plus\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Instagram.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"#9bd2e0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"#9bd2e0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #4e4e4e;\\\"><strong>Boys Clothes<\\/strong><\\/span><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #4e4e4e;\\\"><strong>Girls Clothes<\\/strong><\\/span><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #4e4e4e;\\\"><strong>Toys & Games<\\/strong><\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/kids-clothing\\/Kids-Clothing-Header.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#9cd1e1\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"80px\"}}},{\"type\":\"text\",\"text\":\"<h1><strong>Wait!<\\/strong><\\/h1><h3>You\\u2019ve left something in your cart!<\\/h3>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"100px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"#9bd2e0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #4e4e4e;\\\"><strong>Don\\u2019t worry, we saved it for you\\u2026<\\/strong><\\/span><\\/h2>\"}]}]},{\"type\":\"abandonedCartContent\",\"withLayout\":true,\"amount\":\"2\",\"contentType\":\"product\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"titlePosition\":\"aboveExcerpt\",\"featuredImagePosition\":\"left\",\"pricePosition\":\"below\",\"readMoreType\":\"none\",\"readMoreText\":\"\",\"readMoreButton\":[],\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"borderColor\":\"#aaaaaa\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"padding\":\"13px\"}},\"context\":\"abandonedCartContent.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Go To Cart\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#9bd2e0\",\"borderColor\":\"#0074a2\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"borderWidth\":\"0px\",\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"lineHeight\":\"40px\",\"textAlign\":\"center\",\"width\":\"154px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"#fceba5\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>YOU MIGHT ALSO LIKE\\u2026<\\/strong><\\/h2>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/kids-clothing\\/Kids-Clothing-Image-3.jpg\",\"alt\":\"Kids-Clothing-Image-3\",\"fullWidth\":false,\"width\":\"500px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p><strong>Cherry Dress<\\/strong><\\/p><p><span>$10.99<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"View\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#9bd2e0\",\"borderColor\":\"#0074a2\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"borderWidth\":\"0px\",\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"lineHeight\":\"40px\",\"textAlign\":\"left\",\"width\":\"90px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/kids-clothing\\/Kids-Clothing-Image-2.jpg\",\"alt\":\"Kids-Clothing-Image-2\",\"fullWidth\":false,\"width\":\"500px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p><strong>Red T-Shirt<\\/strong><\\/p><p><span>$9.49<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"View\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#9bd2e0\",\"borderColor\":\"#0074a2\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"borderWidth\":\"0px\",\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"lineHeight\":\"40px\",\"textAlign\":\"left\",\"width\":\"90px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/kids-clothing\\/Kids-Clothing-Image-4.jpg\",\"alt\":\"Kids-Clothing-Image-4\",\"fullWidth\":false,\"width\":\"500px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p><strong>Pink Dance Dress<\\/strong><\\/p><p><span>$11.99<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"View\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#9bd2e0\",\"borderColor\":\"#0074a2\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"borderWidth\":\"0px\",\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"lineHeight\":\"40px\",\"textAlign\":\"left\",\"width\":\"90px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/kids-clothing\\/Kids-Clothing-Footer.jpg\",\"alt\":\"Kids-Clothing-Footer\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"107px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"#c3e1e8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"display\":\"scale\",\"src\":null},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/kids-clothing\\/Kids-Clothing-Logo-Footer-150x61.png\",\"alt\":\"Kids-Clothing-Logo-Footer\",\"fullWidth\":false,\"width\":\"150px\",\"height\":\"61px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"footer\",\"text\":\"<p><strong><span style=\\\"color: #333333;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #333333;\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #333333;\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/span><\\/strong><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"lineHeight\":\"1.6\"},\"h1\":{\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"40px\",\"lineHeight\":\"1.6\"},\"h2\":{\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\",\"lineHeight\":\"1.6\"},\"h3\":{\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"26px\",\"lineHeight\":\"1.6\"},\"link\":{\"fontColor\":\"#9bd2e0\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#c3e1e8\"}},\"blockDefaults\":{\"abandonedCartContent\":{\"amount\":\"2\",\"withLayout\":true,\"contentType\":\"product\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"left\",\"pricePosition\":\"below\",\"readMoreType\":\"none\",\"readMoreText\":\"\",\"readMoreButton\":[],\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"abandonedCartContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"abandonedCartContent\",\"titlePosition\":\"aboveExcerpt\"},\"automatedLatestContent\":{\"amount\":\"5\",\"authorPrecededBy\":\"\\u0646\\u0648\\u06cc\\u0633\\u0646\\u062f\\u0647:\",\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"categoriesPrecededBy\":\"\\u062f\\u0633\\u062a\\u0647 \\u0647\\u0627:\",\"contentType\":\"post\",\"displayType\":\"excerpt\",\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"borderColor\":\"#aaaaaa\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"padding\":\"13px\"}}},\"featuredImagePosition\":\"belowTitle\",\"imageFullWidth\":false,\"inclusionType\":\"include\",\"readMoreButton\":{\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"lineHeight\":\"40px\",\"textAlign\":\"center\",\"width\":\"180px\"}},\"text\":\"\\u0628\\u06cc\\u0634\\u062a\\u0631 \\u0628\\u062e\\u0648\\u0627\\u0646\\u06cc\\u062f\",\"url\":\"[postLink]\"},\"readMoreText\":\"\\u0628\\u06cc\\u0634\\u062a\\u0631 \\u0628\\u062e\\u0648\\u0627\\u0646\\u06cc\\u062f\",\"readMoreType\":\"button\",\"showAuthor\":\"no\",\"showCategories\":\"no\",\"showDivider\":true,\"sortBy\":\"newest\",\"titleAlignment\":\"left\",\"titleFormat\":\"h1\",\"titleIsLink\":false},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"authorPrecededBy\":\"\\u0646\\u0648\\u06cc\\u0633\\u0646\\u062f\\u0647:\",\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"categoriesPrecededBy\":\"Categories:\",\"contentType\":\"post\",\"displayType\":\"excerpt\",\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"borderColor\":\"#aaaaaa\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"padding\":\"13px\"}}},\"featuredImagePosition\":\"alternate\",\"imageFullWidth\":false,\"inclusionType\":\"include\",\"readMoreButton\":{\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"lineHeight\":\"40px\",\"textAlign\":\"center\",\"width\":\"180px\"}},\"text\":\"\\u0628\\u06cc\\u0634\\u062a\\u0631 \\u0628\\u062e\\u0648\\u0627\\u0646\\u06cc\\u062f\",\"url\":\"[postLink]\"},\"readMoreText\":\"\\u0628\\u06cc\\u0634\\u062a\\u0631 \\u0628\\u062e\\u0648\\u0627\\u0646\\u06cc\\u062f\",\"readMoreType\":\"button\",\"showAuthor\":\"no\",\"showCategories\":\"no\",\"showDivider\":true,\"sortBy\":\"newest\",\"titleAlignment\":\"left\",\"titleFormat\":\"h1\",\"titleIsLink\":false,\"withLayout\":true},\"button\":{\"styles\":{\"block\":{\"backgroundColor\":\"#9bd2e0\",\"borderColor\":\"#0074a2\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"borderWidth\":\"0px\",\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"lineHeight\":\"40px\",\"textAlign\":\"center\",\"width\":\"154px\"}},\"text\":\"Go To Cart\",\"url\":\"\",\"type\":\"button\"},\"container\":[],\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"borderColor\":\"#aaaaaa\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"padding\":\"13px\"}}},\"footer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"}},\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\"},\"posts\":{\"amount\":\"10\",\"authorPrecededBy\":\"\\u0646\\u0648\\u06cc\\u0633\\u0646\\u062f\\u0647:\",\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"categoriesPrecededBy\":\"Categories:\",\"contentType\":\"post\",\"displayType\":\"excerpt\",\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"borderColor\":\"#aaaaaa\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"padding\":\"13px\"}}},\"featuredImagePosition\":\"belowTitle\",\"imageFullWidth\":false,\"inclusionType\":\"include\",\"postStatus\":\"publish\",\"readMoreButton\":{\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"lineHeight\":\"40px\",\"textAlign\":\"center\",\"width\":\"180px\"}},\"text\":\"\\u0628\\u06cc\\u0634\\u062a\\u0631 \\u0628\\u062e\\u0648\\u0627\\u0646\\u06cc\\u062f\",\"url\":\"[postLink]\"},\"readMoreText\":\"\\u0628\\u06cc\\u0634\\u062a\\u0631 \\u0628\\u062e\\u0648\\u0627\\u0646\\u06cc\\u062f\",\"readMoreType\":\"link\",\"showAuthor\":\"no\",\"showCategories\":\"no\",\"showDivider\":true,\"sortBy\":\"newest\",\"titleAlignment\":\"left\",\"titleFormat\":\"h1\",\"titleIsLink\":false},\"products\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"product\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"pricePosition\":\"below\",\"readMoreType\":\"link\",\"readMoreText\":\"Buy now\",\"readMoreButton\":{\"text\":\"Buy now\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"height\":\"32px\",\"iconType\":\"facebook\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png?mailpoet_version=3.7.1\",\"link\":\"http:\\/\\/www.facebook.com\",\"text\":\"Facebook\",\"type\":\"socialIcon\",\"width\":\"32px\"},{\"height\":\"32px\",\"iconType\":\"twitter\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png?mailpoet_version=3.7.1\",\"link\":\"http:\\/\\/www.twitter.com\",\"text\":\"Twitter\",\"type\":\"socialIcon\",\"width\":\"32px\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"80px\"}},\"type\":\"spacer\"},\"header\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"}},\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\"},\"woocommerceHeading\":{\"contents\":{\"new_account\":\"New Order: #0001\",\"processing_order\":\"Thank you for your order\",\"completed_order\":\"Thanks for shopping with us\",\"customer_note\":\"A note has been added to your order\"}}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/kids-clothing/thumbnail.20201028.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("22", "0", "Rock Band", "[\"woocommerce\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#060d13\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/rock-band\\/RockBand-Header-2.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#060d13\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<p><a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Courier New\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#7acff0\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"315px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"48px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"29px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><span style=\\\"color: #7acff0;\\\">Free track download<\\/span><\\/h1>\\n    <p style=\\\"text-align: center;\\\"><span style=\\\"color: #d4d4d4;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis ut fringilla velit, id malesuada nisi. Nam ac rutrum diam. Nunc diam leo, bibendum eget aliquam eget, commodo vitae lectus<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Download now for free\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#152533\",\"borderColor\":\"#7acff0\",\"borderWidth\":\"2px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"18.5px\",\"borderStyle\":\"double\",\"borderWidth\":\"7px\",\"borderColor\":\"#1c2f40\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">We\'ve been busy in the studio<\\/span><\\/h2>\\n    <p style=\\\"text-align: center;\\\"><span style=\\\"color: #d4d4d4;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis ut fringilla velit, id malesuada nisi. Nam ac rutrum diam.<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/rock-band\\/RockBand-Albums-2.jpg\",\"alt\":\"RockBand-Albums-2\",\"fullWidth\":false,\"width\":\"250px\",\"height\":\"600px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Magnus Opium<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Buy now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#7acff0\",\"borderColor\":\"#7acff0\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"83px\",\"lineHeight\":\"32px\",\"fontColor\":\"#1c2f40\",\"fontFamily\":\"Courier New\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/rock-band\\/RockBand-Albums-1.jpg\",\"alt\":\"RockBand-Albums-1\",\"fullWidth\":false,\"width\":\"600px\",\"height\":\"600px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Skeletal Bones<\\/p>\"},{\"type\":\"button\",\"text\":\"Buy now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#7acff0\",\"borderColor\":\"#7acff0\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"83px\",\"lineHeight\":\"32px\",\"fontColor\":\"#1c2f40\",\"fontFamily\":\"Courier New\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/rock-band\\/RockBand-Albums-3.jpg\",\"alt\":\"RockBand-Albums-3\",\"fullWidth\":false,\"width\":\"600px\",\"height\":\"600px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Blinded by Vision<\\/p>\"},{\"type\":\"button\",\"text\":\"Buy now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#7acff0\",\"borderColor\":\"#7acff0\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"83px\",\"lineHeight\":\"32px\",\"fontColor\":\"#1c2f40\",\"fontFamily\":\"Courier New\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/rock-band\\/RockBand-Tours.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#1c2f40\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"37px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: right;\\\">New Tour Dates<\\/h1>\\n    <p style=\\\"text-align: right;\\\">14th March - London, UK<\\/p>\\n    <p style=\\\"text-align: right;\\\">15th March - Leeds, UK<\\/p>\\n    <p style=\\\"text-align: right;\\\">16th March - Birmingham, UK<\\/p>\\n    <p style=\\\"text-align: right;\\\">19th March - Manchester, UK<\\/p>\\n    <p style=\\\"text-align: right;\\\">21st March - Glasgow, UK<\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"144px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\">Bounce Rate<\\/h3>\"},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#aaaaaa\",\"fontFamily\":\"Courier New\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#7acff0\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"20px\"},\"link\":{\"fontColor\":\"#7acff0\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#060d13\"},\"body\":{\"backgroundColor\":\"#060d13\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Buy now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#7acff0\",\"borderColor\":\"#7acff0\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"83px\",\"lineHeight\":\"32px\",\"fontColor\":\"#1c2f40\",\"fontFamily\":\"Courier New\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"18.5px\",\"borderStyle\":\"double\",\"borderWidth\":\"7px\",\"borderColor\":\"#1c2f40\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#aaaaaa\",\"fontFamily\":\"Courier New\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#7acff0\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Courier New\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#7acff0\",\"textDecoration\":\"none\"}},\"type\":\"header\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/rock-band/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("23", "0", "Wine City (with coupon)", "[\"woocommerce\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"37px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/wine-city\\/Wine-Logo.png\",\"alt\":\"Wine-Logo\",\"fullWidth\":false,\"width\":\"136px\",\"height\":\"67px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"31px\"}}},{\"type\":\"social\",\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Instagram.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: left;\\\"><span style=\\\"color: #6d6d6d;\\\"><strong>Red Wine<\\/strong><\\/span><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: left;\\\"><span style=\\\"color: #6d6d6d;\\\"><strong>White&nbsp;Wine<\\/strong><\\/span><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: left;\\\"><span style=\\\"color: #6d6d6d;\\\"><strong>Rose&nbsp;Wine<\\/strong><\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/wine-city\\/Wine-Header-1.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\"><strong>Have a drink on us<\\/strong><\\/span><\\/h1>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"231px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"34px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #6d6d6d;\\\"><strong>You\'re our VIP - now it\'s time to celebrate!&nbsp;<\\/strong><\\/span><\\/h2>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #6d6d6d;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam a elementum ex. Aliquam mollis metus ac nisl luctus pulvinar. Donec tincidunt pharetra sem, nec eleifend augue.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"CoUponCoDE\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#6d6d6d\",\"borderWidth\":\"2px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"219px\",\"lineHeight\":\"50px\",\"fontColor\":\"#6d6d6d\",\"fontFamily\":\"Courier New\",\"fontSize\":\"30px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"17px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><strong><span style=\\\"color: #6d6d6d;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #6d6d6d;\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #6d6d6d;\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/span><\\/strong><br \\/><span style=\\\"color: #6d6d6d;\\\">\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#eeeeee\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"40px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"CoUponCoDE\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#6d6d6d\",\"borderWidth\":\"2px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"219px\",\"lineHeight\":\"50px\",\"fontColor\":\"#6d6d6d\",\"fontFamily\":\"Courier New\",\"fontSize\":\"30px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"17px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Instagram.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"231px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/wine-city/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("24", "0", "Abandoned Cart – Fitness", "[\"woocommerce\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e6e1e5\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/fitness\\/Fitness-Logo-1.jpg\",\"alt\":\"Fitness-Logo-1\",\"fullWidth\":true,\"width\":\"180px\",\"height\":\"96px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e6e1e5\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-color\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Instagram.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e6e1e5\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>Get back in the game<\\/strong><\\/h1>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/fitness\\/Fitness-Header.jpg\",\"alt\":\"Fitness-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"696px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><strong>You\'ve left something in your cart...<\\/strong><\\/h3>\"}]}]},{\"type\":\"abandonedCartContent\",\"withLayout\":true,\"amount\":\"2\",\"contentType\":\"product\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"full\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"titlePosition\":\"aboveExcerpt\",\"featuredImagePosition\":\"left\",\"pricePosition\":\"hidden\",\"readMoreType\":\"none\",\"readMoreText\":\"\",\"readMoreButton\":[],\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"context\":\"abandonedCartContent.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Recover Cart\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#343434\",\"borderWidth\":\"3px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"146px\",\"lineHeight\":\"37px\",\"fontColor\":\"#343434\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#afd147\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><strong>Still interested?<\\/strong><\\/h3>\\n<p style=\\\"text-align: center;\\\"><strong>Here\'s 20% off your order if you complete it right now. We\'re nice like that.<\\/strong><\\/p>\"},{\"type\":\"button\",\"text\":\"COUPONCODE\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#afd147\",\"borderColor\":\"#56741d\",\"borderWidth\":\"3px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"219px\",\"lineHeight\":\"50px\",\"fontColor\":\"#56741d\",\"fontFamily\":\"Courier New\",\"fontSize\":\"26px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/fitness\\/Fitness-Logo-Footer-1.png\",\"alt\":\"Fitness-Logo-Footer-1\",\"fullWidth\":false,\"width\":\"180px\",\"height\":\"52px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Instagram.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #999999;\\\">Address Line 1, Address Line 2, City, Country<\\/span><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #999999;\\\"><strong><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #999999;\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a><span>&nbsp;<\\/span>|<span>&nbsp;<\\/span><a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #999999;\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/strong><\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"lineHeight\":\"1.6\"},\"h1\":{\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"40px\",\"lineHeight\":\"1.6\"},\"h2\":{\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\",\"lineHeight\":\"1.6\"},\"h3\":{\"fontColor\":\"#4e4e4e\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\",\"lineHeight\":\"1.6\"},\"link\":{\"fontColor\":\"#3c3c3c\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#222222\"}},\"blockDefaults\":{\"abandonedCartContent\":{\"amount\":\"2\",\"withLayout\":true,\"contentType\":\"product\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"full\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"left\",\"pricePosition\":\"hidden\",\"readMoreType\":\"none\",\"readMoreText\":\"\",\"readMoreButton\":[],\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"abandonedCartContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"abandonedCartContent\",\"titlePosition\":\"aboveExcerpt\"},\"automatedLatestContent\":{\"amount\":\"5\",\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Recover Cart\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#343434\",\"borderWidth\":\"3px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"146px\",\"lineHeight\":\"37px\",\"fontColor\":\"#343434\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"container\":[],\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"products\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"product\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"pricePosition\":\"below\",\"readMoreType\":\"link\",\"readMoreText\":\"Buy now\",\"readMoreButton\":{\"text\":\"Buy now\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png?mailpoet_version=3.7.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png?mailpoet_version=3.7.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}},\"woocommerceHeading\":{\"contents\":{\"new_account\":\"New Order: #0001\",\"processing_order\":\"Thank you for your order\",\"completed_order\":\"Thanks for shopping with us\",\"customer_note\":\"A note has been added to your order\"}}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/fitness/thumbnail.20201028.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("25", "0", "Motor", "[\"woocommerce\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e3e3e3\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e3e3e3\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"24px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-color\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #d52a2a;\\\"><strong>Welcome to Vector Motors<\\/strong><\\/span><\\/p>\\n    <p style=\\\"text-align: center; font-size: 11px;\\\"><span style=\\\"color: #d52a2a;\\\"><a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/span><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"24px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-color\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Email.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Website.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"}]}]}]},{\"type\":\"container\",\"columnLayout\":\"2_1\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/motor\\/Car-Header-2.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#d52a2a\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/motor\\/Car-Header-logo-1.png\",\"alt\":\"Car-Header-logo-1\",\"fullWidth\":false,\"width\":\"167.5px\",\"height\":\"349px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"118px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"font-size: 35px; line-height: 40px; text-align: left; border-left: 10px solid #d52a2a; margin-left: 20px; padding-left: 20px;\\\"><strong><span style=\\\"color: #ffffff;\\\">Welcome to the club<\\/span><\\/strong><\\/h3>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"72px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong><span style=\\\"color: #d52a2a;\\\">You\'ve bought the car,&nbsp;here\'s&nbsp;what happens next.<\\/span><\\/strong><\\/h2>\\n    <p style=\\\"text-align: center;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam a elementum ex. Aliquam mollis metus ac nisl luctus pulvinar. Donec tincidunt pharetra sem, nec eleifend augue. Morbi id nunc commodo, tempor erat et, pretium neque. <\\/span><\\/p>\\n    <p style=\\\"text-align: center;\\\"><span><\\/span><\\/p>\\n    <p style=\\\"text-align: center;\\\"><span>Vivamus ante sapien, consequat vitae ante quis, facilisis pellentesque mi. Praesent at scelerisque leo. Donec elementum mi consequat, ultrices lorem nec, vestibulum arcu. Aenean id libero vitae felis consequat maximus.<\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#e3e3e3\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e3e3e3\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h1><strong>We\'re here to help<\\/strong><\\/h1>\\n    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam a elementum ex. Aliquam mollis metus ac nisl luctus pulvinar. Donec tincidunt pharetra sem, nec eleifend augue. Morbi id nunc commodo, tempor erat et, pretium neque.<\\/p>\\n    <p><\\/p>\\n    <p><strong><a href=\\\"\\\">Get in touch with us here<\\/a><\\/strong><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#e3e3e3\",\"height\":\"113px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"42px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Servicing Plans\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#d52a2a\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"176px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#e3e3e3\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/motor\\/Car-Wheel.jpg\",\"alt\":\"Car-Wheel\",\"fullWidth\":true,\"width\":\"600px\",\"height\":\"560px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><strong>We\'ll be in touch soon with updates<\\/strong><\\/h3>\\n    <p style=\\\"text-align: center;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam a elementum ex. Aliquam mollis metus ac nisl luctus pulvinar. Donec tincidunt pharetra sem, nec eleifend augue. Morbi id nunc commodo, tempor erat et, pretium neque.<\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"35px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e3e3e3\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#e3e3e3\",\"height\":\"20px\"}}},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #d52a2a;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #d52a2a;\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #d52a2a;\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/span><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/motor\\/Car-Footer.jpg\",\"alt\":\"Car-Footer\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"275px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#d52a2a\",\"height\":\"20px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Roboto\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#d52a2a\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#e3e3e3\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Servicing Plans\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#d52a2a\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"176px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"18.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"5px\",\"borderColor\":\"#d52a2a\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-color\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Email.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Website.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"118px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#d52a2a\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/motor/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("26", "0", "Avocado", "[\"woocommerce\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f3f8f3\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/avocado\\/Avocado-Logo-2.png\",\"alt\":\"Avocado-Logo-2\",\"fullWidth\":false,\"width\":\"212px\",\"height\":\"89px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"33px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: right;\\\"><strong>Has to be fresh<\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ddeeba\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"58px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>Holy Guacamole!<\\/strong><\\/h1>\\n<h2 style=\\\"text-align: center;\\\">Your monthly avocado<\\/h2>\\n<h2 style=\\\"text-align: center;\\\">delivery starts right now.<\\/h2>\"},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/avocado\\/Avocado-Header-1.jpg\",\"alt\":\"Avocado-Header-1\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"644px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/avocado\\/Avocado-Recipe.jpg\",\"alt\":\"Avocado-Recipe\",\"fullWidth\":true,\"width\":\"600px\",\"height\":\"890px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"135px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong>A quick and easy recipe to get you started...<\\/strong><\\/h3>\\n<p style=\\\"text-align: left;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer blandit tortor nec eleifend maximus. Nulla est lectus, tincidunt quis molestie vitae, suscipit non orci.<\\/p>\"},{\"type\":\"button\",\"text\":\"Check it out\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#9ecd2e\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"28px\",\"borderStyle\":\"solid\",\"width\":\"111px\",\"lineHeight\":\"36px\",\"fontColor\":\"#3d3d3d\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#9ecd2e\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><strong><span style=\\\"color: #333333;\\\"><\\/span><\\/strong><\\/p>\\n<p style=\\\"text-align: center;\\\"><strong><span style=\\\"color: #333333;\\\"><\\/span><\\/strong><strong><span style=\\\"color: #333333;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit.<\\/span><\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ddeeba\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"58px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>Got a friend that hass to have this too ?<\\/strong><\\/h2>\\n<h2 style=\\\"text-align: center;\\\"><\\/h2>\"},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/avocado\\/Avocado-Coupon.jpg\",\"alt\":\"Avocado-Coupon\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"382px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#dbefb4\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Send them your exclusive coupon code now and they\'ll receive 50% off their next order, and you\'ll get your next box for free!&nbsp;<\\/p>\"},{\"type\":\"button\",\"text\":\"AVOCADOSRULE\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#dbefb4\",\"borderColor\":\"#3d3d3d\",\"borderWidth\":\"3px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"254px\",\"lineHeight\":\"50px\",\"fontColor\":\"#3d3d3d\",\"fontFamily\":\"Arial\",\"fontSize\":\"26px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#dbefb4\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#f3f8f3\",\"height\":\"44px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"footer\",\"text\":\"<p><strong><span style=\\\"color: #9ecd2e;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #9ecd2e;\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #9ecd2e;\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/span><\\/strong><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#3d3d3d\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#3d3d3d\",\"fontFamily\":\"Arial\",\"fontSize\":\"40px\"},\"h2\":{\"fontColor\":\"#3d3d3d\",\"fontFamily\":\"Arial\",\"fontSize\":\"26px\"},\"h3\":{\"fontColor\":\"#3d3d3d\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#9ecd2e\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#f3f8f3\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"AVOCADOSRULE\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#dbefb4\",\"borderColor\":\"#3d3d3d\",\"borderWidth\":\"3px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"254px\",\"lineHeight\":\"50px\",\"fontColor\":\"#3d3d3d\",\"fontFamily\":\"Arial\",\"fontSize\":\"26px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"2px\",\"borderColor\":\"#9ecd2e\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"33px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/avocado/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("27", "0", "Book store (with coupon)", "[\"woocommerce\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#125674\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"60px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/book-store-with-coupon\\/Book-Logo.png\",\"alt\":\"Book-Logo\",\"fullWidth\":false,\"width\":\"200px\",\"height\":\"48px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/book-store-with-coupon\\/Book-Header.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#125674\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"100px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong><span style=\\\"color: #ffffff;\\\">Turn more pages this weekend...<\\/span><\\/strong><\\/h1>\\n    <p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Just to say thanks, here\'s a small gift from us to you.<\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"71px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/book-store-with-coupon\\/Book-Body-2.png\",\"display\":\"tile\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"21px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #5094ad;\\\"><strong>Read more every week<\\/strong><\\/span><\\/p>\\n    <h2 style=\\\"text-align: center;\\\"><strong>Your free gift!<\\/strong><\\/h2>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/book-store-with-coupon\\/Book-Body-2.png\",\"display\":\"tile\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"2px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#125674\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/book-store-with-coupon\\/Book-Body-2.png\",\"display\":\"tile\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span>Lorem ipsum dolor sit amet, adipiscing elit. Fusce mollis orci justo,<\\/span><\\/p>\\n    <p style=\\\"text-align: center;\\\"><span>commodo mattis nisi vitae. Sed aliquam, ex ac lacinia tempus,<\\/span><\\/p>\\n    <p style=\\\"text-align: center;\\\"><span>enim urna luctus odio, at leo ante non.<\\/span><\\/p>\"},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>20% off all books<\\/strong><\\/h2>\"},{\"type\":\"button\",\"text\":\"Coupon_Code\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#125674\",\"borderWidth\":\"3px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#125674\",\"fontFamily\":\"Courier New\",\"fontSize\":\"26px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/book-store-with-coupon\\/Book-Image-Wide-2.png\",\"alt\":\"Book-Image-Wide\",\"fullWidth\":true,\"width\":\"1200px\",\"height\":\"400px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#cdc391\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#cdc391\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#125674\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"29px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#125674\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/book-store-with-coupon\\/Book-Logo.png\",\"alt\":\"Book-Logo\",\"fullWidth\":false,\"width\":\"96px\",\"height\":\"48px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #cdc391;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #cdc391;\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #cdc391;\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/span><br \\/><span style=\\\"color: #ffffff;\\\">\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"header\",\"text\":\"<p><span style=\\\"color: #ffffff;\\\"><a href=\\\"[link:newsletter_view_in_browser_url]\\\" style=\\\"color: #ffffff;\\\">View this in your browser.<\\/a><\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Noticia Text\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Playfair Display\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Playfair Display\",\"fontSize\":\"22px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"20px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#125674\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Coupon_Code\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#125674\",\"borderWidth\":\"3px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#125674\",\"fontFamily\":\"Courier New\",\"fontSize\":\"26px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"2px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#125674\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/book-store-with-coupon/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("28", "0", "Flowers (with coupon)", "[\"woocommerce\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#eae5e5\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<p><span style=\\\"color: #000000;\\\"><a href=\\\"[link:newsletter_view_in_browser_url]\\\" style=\\\"color: #000000;\\\">View this email in your browser.<\\/a><\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e0a9bc\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/flowers-with-coupon\\/Flowers-Logo.png\",\"alt\":\"Flowers-Logo\",\"fullWidth\":false,\"width\":\"110px\",\"height\":\"180px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"44px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e0a9bc\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/flowers-with-coupon\\/Flowers-Header.jpg\",\"alt\":\"Flowers-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"850px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>Just for you.<\\/strong><\\/h1>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e0a9bc\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\"><strong>Welcome to our flower store - as a token of our appreciation for you signing up,<\\/strong><\\/span><\\/p>\\n    <p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\"><strong>here\'s a little gift from us for your next order.<\\/strong><\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"CoUpOn_Code\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#292929\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"26px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333; font-size: 11px;\\\"><strong><\\/strong><strong>10% off your next order with us. Terms and Conditions apply.<\\/strong><\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"45px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>A little inspiration to get you started...<\\/strong><\\/h2>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3><strong>New flowers delivered<\\/strong><\\/h3>\"},{\"type\":\"text\",\"text\":\"<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut rutrum et lacus a dignissim. Curabitur id nisi malesuada, pharetra massa ut, bibendum lacus.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Buy Now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#e0a9bc\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"3px\",\"borderStyle\":\"solid\",\"width\":\"85px\",\"lineHeight\":\"36px\",\"fontColor\":\"#292929\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/flowers-with-coupon\\/Flower-1.jpg\",\"alt\":\"Flower-1\",\"fullWidth\":false,\"width\":\"730px\",\"height\":\"604px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/flowers-with-coupon\\/Flower-2.jpg\",\"alt\":\"Flower-2\",\"fullWidth\":false,\"width\":\"730px\",\"height\":\"604px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3><strong>Save with a subscription<\\/strong><\\/h3>\"},{\"type\":\"text\",\"text\":\"<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut rutrum et lacus a dignissim. Curabitur id nisi malesuada, pharetra massa ut, bibendum lacus.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Buy Now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#e0a9bc\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"3px\",\"borderStyle\":\"solid\",\"width\":\"85px\",\"lineHeight\":\"36px\",\"fontColor\":\"#292929\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3><strong>Collect from our store<\\/strong><\\/h3>\"},{\"type\":\"text\",\"text\":\"<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut rutrum et lacus a dignissim. Curabitur id nisi malesuada, pharetra massa ut, bibendum lacus.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Buy Now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#e0a9bc\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"3px\",\"borderStyle\":\"solid\",\"width\":\"85px\",\"lineHeight\":\"36px\",\"fontColor\":\"#292929\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/flowers-with-coupon\\/Flower-3.jpg\",\"alt\":\"Flower-3\",\"fullWidth\":false,\"width\":\"730px\",\"height\":\"604px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#eae5e5\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #b3748a;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #b3748a;\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #b3748a;\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/span><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#e0a9bc\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eae5e5\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Buy Now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#e0a9bc\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"3px\",\"borderStyle\":\"solid\",\"width\":\"85px\",\"lineHeight\":\"36px\",\"fontColor\":\"#292929\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"392px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/flowers-with-coupon/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("29", "0", "خبرنامه: نمونه خالی با الگوی 1 ستون", "[\"standard\",\"blank\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"\\u0622\\u0631\\u0645 \\u062c\\u0639\\u0644\\u06cc\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>\\u0628\\u06cc\\u0627 \\u0634\\u0631\\u0648\\u0639 \\u06a9\\u0646\\u06cc\\u0645!<\\/strong><\\/h1>\\n<p>&nbsp;<\\/p>\\n<p>\\u0648\\u0642\\u062a \\u0622\\u0646 \\u0627\\u0633\\u062a \\u06a9\\u0647 \\u062e\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647 \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0637\\u0631\\u0627\\u062d\\u06cc \\u06a9\\u0646\\u06cc\\u062f! \\u062f\\u0631 \\u0646\\u0648\\u0627\\u0631 \\u06a9\\u0646\\u0627\\u0631\\u06cc \\u0633\\u0645\\u062a \\u0631\\u0627\\u0633\\u062a\\u060c \\u0634\\u0645\\u0627 4 \\u0622\\u06cc\\u062a\\u0645 \\u0645\\u0646\\u0648 \\u067e\\u06cc\\u062f\\u0627 \\u062e\\u0648\\u0627\\u0647\\u06cc\\u062f \\u06a9\\u0631\\u062f \\u06a9\\u0647 \\u0628\\u0647 \\u0634\\u0645\\u0627 \\u06a9\\u0645\\u06a9 \\u0645\\u06cc \\u06a9\\u0646\\u062f \\u062e\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647 \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0633\\u0641\\u0627\\u0631\\u0634\\u06cc \\u06a9\\u0646\\u06cc\\u062f:<\\/p>\\n<ol>\\n<li>\\u0645\\u062d\\u062a\\u0648\\u0627<\\/li>\\n<li>\\u0633\\u062a\\u0648\\u0646 \\u0647\\u0627<\\/li>\\n<li>\\u0633\\u0628\\u06a9 \\u0647\\u0627<\\/li>\\n<li>\\u067e\\u06cc\\u0634 \\u0646\\u0645\\u0627\\u06cc\\u0634<\\/li>\\n<\\/ol>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"24.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/newsletter-blank-1-column/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("30", "0", "خبرنامه: نمونه خالی با الگوی 1:2 ستون", "[\"standard\",\"blank\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"\\u0622\\u0631\\u0645 \\u062c\\u0639\\u0644\\u06cc\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>\\u0628\\u06cc\\u0627 \\u0634\\u0631\\u0648\\u0639 \\u06a9\\u0646\\u06cc\\u0645!<\\/strong><\\/h1>\\n<p>&nbsp;<\\/p>\\n<p>\\u0648\\u0642\\u062a \\u0622\\u0646 \\u0627\\u0633\\u062a \\u06a9\\u0647 \\u062e\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647 \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0637\\u0631\\u0627\\u062d\\u06cc \\u06a9\\u0646\\u06cc\\u062f! \\u062f\\u0631 \\u0646\\u0648\\u0627\\u0631 \\u06a9\\u0646\\u0627\\u0631\\u06cc \\u0633\\u0645\\u062a \\u0631\\u0627\\u0633\\u062a\\u060c \\u0634\\u0645\\u0627 4 \\u0622\\u06cc\\u062a\\u0645 \\u0645\\u0646\\u0648 \\u067e\\u06cc\\u062f\\u0627 \\u062e\\u0648\\u0627\\u0647\\u06cc\\u062f \\u06a9\\u0631\\u062f \\u06a9\\u0647 \\u0628\\u0647 \\u0634\\u0645\\u0627 \\u06a9\\u0645\\u06a9 \\u0645\\u06cc \\u06a9\\u0646\\u062f \\u062e\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647 \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0633\\u0641\\u0627\\u0631\\u0634\\u06cc \\u06a9\\u0646\\u06cc\\u062f:<\\/p>\\n<ol>\\n<li>\\u0645\\u062d\\u062a\\u0648\\u0627<\\/li>\\n<li>\\u0633\\u062a\\u0648\\u0646 \\u0647\\u0627<\\/li>\\n<li>\\u0633\\u0628\\u06a9 \\u0647\\u0627<\\/li>\\n<li>\\u067e\\u06cc\\u0634 \\u0646\\u0645\\u0627\\u06cc\\u0634<\\/li>\\n<\\/ol>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2>This template has...<\\/h2>\"},{\"type\":\"text\",\"text\":\"<p>\\u062f\\u0631 \\u0646\\u0648\\u0627\\u0631 \\u06a9\\u0646\\u0627\\u0631\\u06cc \\u0633\\u0645\\u062a \\u0631\\u0627\\u0633\\u062a\\u060c \\u0634\\u0645\\u0627 \\u0645\\u06cc \\u062a\\u0648\\u0627\\u0646\\u06cc\\u062f \\u0628\\u0644\\u0648\\u06a9 \\u0647\\u0627\\u06cc \\u0637\\u0631\\u062d \\u0631\\u0627 \\u0628\\u0647 \\u0627\\u06cc\\u0645\\u06cc\\u0644 \\u062e\\u0648\\u062f \\u0627\\u0636\\u0627\\u0641\\u0647 \\u06a9\\u0646\\u06cc\\u062f:<\\/p>\\n<ul>\\n<li>1 \\u0633\\u062a\\u0648\\u0646<\\/li>\\n<li>2 \\u0633\\u062a\\u0648\\u0646<\\/li>\\n<li>3 \\u0633\\u062a\\u0648\\u0646<\\/li>\\n<\\/ul>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2>... a 2-column layout.<\\/h2>\"},{\"type\":\"text\",\"text\":\"<p><span style=\\\"line-height: 25.6px;\\\">\\u0634\\u0645\\u0627 \\u0645\\u06cc \\u062a\\u0648\\u0627\\u0646\\u06cc\\u062f \\u0631\\u0646\\u06af \\u067e\\u0633 \\u0632\\u0645\\u06cc\\u0646\\u0647 \\u0637\\u0631\\u062d \\u0631\\u0627 \\u0628\\u0627 \\u06a9\\u0644\\u06cc\\u06a9 \\u06a9\\u0631\\u062f\\u0646 \\u0628\\u0631 \\u0631\\u0648\\u06cc \\u0622\\u06cc\\u06a9\\u0648\\u0646 \\u062a\\u0646\\u0638\\u06cc\\u0645\\u0627\\u062a \\u062f\\u0631 \\u0644\\u0628\\u0647 \\u0633\\u0645\\u062a \\u0631\\u0627\\u0633\\u062a \\u0637\\u0631\\u0627\\u062d \\u062a\\u063a\\u06cc\\u06cc\\u0631 \\u062f\\u0647\\u06cc\\u062f. \\u0628\\u0647 \\u0633\\u0627\\u062f\\u06af\\u06cc \\u0628\\u0631 \\u0631\\u0648\\u06cc \\u0627\\u06cc\\u0646 \\u0645\\u0646\\u0637\\u0642\\u0647 \\u062d\\u0631\\u06a9\\u062a \\u06a9\\u0646\\u06cc\\u062f \\u062a\\u0627 \\u0622\\u06cc\\u06a9\\u0648\\u0646 \\u062a\\u0646\\u0638\\u06cc\\u0645\\u0627\\u062a (\\u0686\\u0631\\u062e \\u062f\\u0646\\u062f\\u0647) \\u0631\\u0627 \\u0628\\u0628\\u06cc\\u0646\\u06cc\\u062f.<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"24.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/newsletter-blank-1-2-column/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("31", "0", "خبرنامه: نمونه خالی با الگوی 1:2:1 ستون", "[\"standard\",\"blank\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"\\u0622\\u0631\\u0645 \\u062c\\u0639\\u0644\\u06cc\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>\\u0627\\u062c\\u0627\\u0632\\u0647 \\u062f\\u0647\\u06cc\\u062f \\u0634\\u0631\\u0648\\u0639 \\u06a9\\u0646\\u06cc\\u0645!<\\/strong><\\/h1>\\n<p>\\u0627\\u06a9\\u0646\\u0648\\u0646 \\u0632\\u0645\\u0627\\u0646 \\u0637\\u0631\\u0627\\u062d\\u06cc \\u062e\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647 \\u0634\\u0645\\u0627\\u0633\\u062a! \\u062f\\u0631 \\u0646\\u0648\\u0627\\u0631 \\u06a9\\u0646\\u0627\\u0631\\u06cc \\u0633\\u0645\\u062a \\u0631\\u0627\\u0633\\u062a\\u060c \\u0622\\u06cc\\u062a\\u0645 \\u0647\\u0627\\u06cc \\u0645\\u0646\\u0648\\u06cc \\u0686\\u0647\\u0627\\u0631\\u06af\\u0627\\u0646\\u0647 \\u0627\\u06cc \\u0631\\u0627 \\u0645\\u06cc \\u0628\\u06cc\\u0646\\u06cc\\u062f \\u06a9\\u0647 \\u0628\\u0647 \\u0634\\u0645\\u0627 \\u062f\\u0631 \\u0633\\u0641\\u0627\\u0631\\u0634\\u06cc  \\u0633\\u0627\\u0632\\u06cc \\u062e\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647 \\u062a\\u0627\\u0646 \\u06a9\\u0645\\u06a9 \\u0645\\u06cc \\u06a9\\u0646\\u0646\\u062f:<\\/p>\\n<ol>\\n<li>\\u0645\\u062d\\u062a\\u0648\\u0627<\\/li>\\n<li>\\u0633\\u062a\\u0648\\u0646 \\u0647\\u0627<\\/li>\\n<li>\\u0633\\u0628\\u06a9 \\u0647\\u0627<\\/li>\\n<li>\\u067e\\u06cc\\u0634 \\u0646\\u0645\\u0627\\u06cc\\u0634<\\/li>\\n<\\/ol>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2>This template has...<\\/h2>\"},{\"type\":\"text\",\"text\":\"<p>\\u062f\\u0631 \\u0646\\u0648\\u0627\\u0631 \\u06a9\\u0646\\u0627\\u0631\\u06cc \\u0633\\u0645\\u062a \\u0631\\u0627\\u0633\\u062a\\u060c \\u0634\\u0645\\u0627 \\u0645\\u06cc \\u062a\\u0648\\u0627\\u0646\\u06cc\\u062f \\u0628\\u0644\\u0648\\u06a9 \\u0647\\u0627\\u06cc \\u0637\\u0631\\u062d \\u0631\\u0627 \\u0628\\u0647 \\u0627\\u06cc\\u0645\\u06cc\\u0644 \\u062e\\u0648\\u062f \\u0627\\u0636\\u0627\\u0641\\u0647 \\u06a9\\u0646\\u06cc\\u062f:<\\/p>\\n<ul>\\n<li>1 \\u0633\\u062a\\u0648\\u0646<\\/li>\\n<li>2 \\u0633\\u062a\\u0648\\u0646<\\/li>\\n<li>3 \\u0633\\u062a\\u0648\\u0646<\\/li>\\n<\\/ul>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2>... a 2-column layout.<\\/h2>\"},{\"type\":\"text\",\"text\":\"<p>You can change a layout\'s background color by clicking on the settings icon on the right edge of the Designer. Simply hover over this area to see the Settings (gear) icon.<\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"font-weight: 600;\\\">\\u0627\\u062c\\u0627\\u0632\\u0647 \\u0628\\u062f\\u0647\\u06cc\\u062f \\u0628\\u0627 \\u06cc\\u06a9 \\u0633\\u062a\\u0648\\u0646 \\u0628\\u0647 \\u067e\\u0627\\u06cc\\u0627\\u0646 \\u0628\\u0631\\u0633\\u062f. <\\/span><\\/h3>\\n<p style=\\\"line-height: 25.6px;\\\">\\u062f\\u0631 \\u0646\\u0648\\u0627\\u0631 \\u06a9\\u0646\\u0627\\u0631\\u06cc \\u0633\\u0645\\u062a \\u0631\\u0627\\u0633\\u062a\\u060c \\u0634\\u0645\\u0627 \\u0645\\u06cc \\u062a\\u0648\\u0627\\u0646\\u06cc\\u062f \\u0627\\u06cc\\u0646 \\u0628\\u0644\\u0648\\u06a9 \\u0637\\u0631\\u062d \\u0631\\u0627 \\u0628\\u0647 \\u0627\\u06cc\\u0645\\u06cc\\u0644 \\u062e\\u0648\\u062f \\u0627\\u0636\\u0627\\u0641\\u0647 \\u06a9\\u0646\\u06cc\\u062f:<\\/p>\\n<p style=\\\"line-height: 25.6px;\\\"><\\/p>\\n<ul style=\\\"line-height: 25.6px;\\\">\\n<li>1 \\u0633\\u062a\\u0648\\u0646<\\/li>\\n<li>2 \\u0633\\u062a\\u0648\\u0646<\\/li>\\n<li>3 \\u0633\\u062a\\u0648\\u0646<\\/li>\\n<\\/ul>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"24.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/newsletter-blank-1-2-1-column/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("32", "0", "خبرنامه: نمونه خالی با الگوی 1:3 ستون", "[\"standard\",\"blank\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"\\u0622\\u0631\\u0645 \\u062c\\u0639\\u0644\\u06cc\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>\\u0628\\u06cc\\u0627 \\u0634\\u0631\\u0648\\u0639 \\u06a9\\u0646\\u06cc\\u0645!<\\/strong><\\/h1>\\n<p>&nbsp;<\\/p>\\n<p>\\u0648\\u0642\\u062a \\u0622\\u0646 \\u0627\\u0633\\u062a \\u06a9\\u0647 \\u062e\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647 \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0637\\u0631\\u0627\\u062d\\u06cc \\u06a9\\u0646\\u06cc\\u062f! \\u062f\\u0631 \\u0646\\u0648\\u0627\\u0631 \\u06a9\\u0646\\u0627\\u0631\\u06cc \\u0633\\u0645\\u062a \\u0631\\u0627\\u0633\\u062a\\u060c \\u0634\\u0645\\u0627 \\u0686\\u0647\\u0627\\u0631 \\u0622\\u06cc\\u062a\\u0645 \\u0645\\u0646\\u0648 \\u067e\\u06cc\\u062f\\u0627 \\u062e\\u0648\\u0627\\u0647\\u06cc\\u062f \\u06a9\\u0631\\u062f \\u06a9\\u0647 \\u0628\\u0647 \\u0634\\u0645\\u0627 \\u06a9\\u0645\\u06a9 \\u0645\\u06cc \\u06a9\\u0646\\u062f \\u062e\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647 \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0633\\u0641\\u0627\\u0631\\u0634\\u06cc \\u06a9\\u0646\\u06cc\\u062f:<\\/p>\\n<ol>\\n<li>\\u0645\\u062d\\u062a\\u0648\\u0627<\\/li>\\n<li>\\u0633\\u062a\\u0648\\u0646 \\u0647\\u0627<\\/li>\\n<li>\\u0633\\u0628\\u06a9 \\u0647\\u0627<\\/li>\\n<li>\\u067e\\u06cc\\u0634 \\u0646\\u0645\\u0627\\u06cc\\u0634<\\/li>\\n<\\/ol>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>This template...<\\/h3>\"},{\"type\":\"text\",\"text\":\"<p>In the right sidebar, you can add layout blocks to your newsletter.<\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>... has a...<\\/h3>\"},{\"type\":\"text\",\"text\":\"<p>\\u0634\\u0645\\u0627 \\u0628\\u0627\\u06cc\\u062f \\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u06a9\\u0646\\u06cc\\u062f:<\\/p>\\n<ul>\\n<li>1 \\u0633\\u062a\\u0648\\u0646<\\/li>\\n<li>2 \\u0633\\u062a\\u0648\\u0646<\\/li>\\n<li>3 \\u0633\\u062a\\u0648\\u0646<\\/li>\\n<\\/ul>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>3-column layout.<\\/h3>\"},{\"type\":\"text\",\"text\":\"<p>You can add as many layout blocks as you want!<\\/p>\"},{\"type\":\"text\",\"text\":\"\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"24.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/newsletter-blank-1-3-column/thumbnail.20190930.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("33", "0", "متن ساده", "[\"standard\",\"blank\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"\\u0622\\u0631\\u0645 \\u062c\\u0639\\u0644\\u06cc\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: left;\\\">\\u0633\\u0644\\u0627\\u0645 [subscriber:firstname | default:subscriber],<\\/p>\\n<p style=\\\"text-align: left;\\\"><\\/p>\\n<p style=\\\"text-align: left;\\\">\\u062f\\u0631 \\u0645\\u06cc\\u0644 \\u067e\\u0648\\u0626\\u062a, \\u0634\\u0645\\u0627 \\u0645\\u06cc \\u062a\\u0648\\u0627\\u0646\\u06cc\\u062f \\u0627\\u06cc\\u0645\\u06cc\\u0644 \\u0647\\u0627\\u06cc\\u06cc \\u0628\\u0627 \\u0645\\u062a\\u0646 \\u0633\\u0627\\u062f\\u0647 \\u0628\\u0646\\u0648\\u06cc\\u0633\\u06cc\\u062f, \\u062f\\u0631\\u0633\\u062a \\u0645\\u062b\\u0644 \\u06cc\\u06a9 \\u0627\\u06cc\\u0645\\u06cc\\u0644 \\u0645\\u0639\\u0645\\u0648\\u0644\\u06cc. \\u0627\\u06cc\\u0646 \\u0645\\u06cc \\u062a\\u0648\\u0627\\u0646\\u062f \\u062e\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647 \\u0647\\u0627\\u06cc \\u0634\\u0645\\u0627 \\u0631\\u0627 \\u062e\\u06cc\\u0644\\u06cc \\u0627\\u062e\\u062a\\u0635\\u0627\\u0635\\u06cc \\u0648 \\u062c\\u0627\\u0644\\u0628 \\u062a\\u0648\\u062c\\u0647 \\u06a9\\u0646\\u062f.<\\/p>\\n<p style=\\\"text-align: left;\\\"><\\/p>\\n<p style=\\\"text-align: left;\\\">\\u062e\\u06cc\\u0644\\u06cc \\u067e\\u06cc\\u0634 \\u067e\\u0627 \\u0627\\u0641\\u062a\\u0627\\u062f\\u0647 \\u0627\\u0633\\u062a\\u061f \\u0634\\u0645\\u0627 \\u0647\\u0646\\u0648\\u0632 \\u0647\\u0645 \\u0645\\u06cc \\u062a\\u0648\\u0627\\u0646\\u06cc\\u062f \\u0633\\u0628\\u06a9 \\u0645\\u062a\\u0646 \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0628\\u0627 \\u0641\\u0631\\u0645\\u062a \\u0647\\u0627\\u06cc \\u0627\\u0628\\u062a\\u062f\\u0627\\u06cc\\u06cc \\u062a\\u0646\\u0638\\u06cc\\u0645 \\u06a9\\u0646\\u06cc\\u062f\\u060c \\u0645\\u062b\\u0644 <strong>\\u0636\\u062e\\u06cc\\u0645<\\/strong> \\u06cc\\u0627 <em>\\u0645\\u0627\\u06cc\\u0644.<\\/em><\\/p>\\n<p style=\\\"text-align: left;\\\"><\\/p>\\n<p style=\\\"text-align: left;\\\">\\u062f\\u0631 \\u0646\\u0647\\u0627\\u06cc\\u062a\\u060c \\u0634\\u0645\\u0627 \\u0645\\u06cc \\u062a\\u0648\\u0627\\u0646\\u06cc\\u062f \\u06cc\\u06a9 \\u06a9\\u0644\\u06cc\\u062f \\u0627\\u0631\\u062a\\u0628\\u0627\\u0637\\u06cc \\u0641\\u0639\\u0627\\u0644 \\u0631\\u0627 \\u0628\\u06cc\\u0646 2 \\u0628\\u0644\\u0648\\u06a9 \\u0645\\u062a\\u0646 \\u0627\\u0636\\u0627\\u0641\\u0647 \\u06a9\\u0646\\u06cc\\u062f\\u060c \\u0634\\u0628\\u06cc\\u0647 \\u0627\\u06cc\\u0646:<\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"23px\"}}},{\"type\":\"button\",\"text\":\"\\u0627\\u06a9\\u0646\\u0648\\u0646 \\u0632\\u0645\\u0627\\u0646 \\u0639\\u0645\\u0644 \\u0627\\u0633\\u062a!\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}},{\"type\":\"text\",\"text\":\"<p>\\u0645\\u062a\\u0634\\u06a9\\u0631\\u0645 \\u06a9\\u0647 \\u0645\\u0637\\u0627\\u0644\\u0628 \\u0631\\u0648 \\u062e\\u0648\\u0646\\u062f\\u06cc. \\u0628\\u0647 \\u0632\\u0648\\u062f\\u06cc \\u0645\\u06cc \\u0628\\u06cc\\u0646\\u0645\\u062a!<\\/p>\\n<p>&nbsp;<\\/p>\\n<p><strong><em>\\u062a\\u06cc\\u0645 \\u0645\\u06cc\\u0644 \\u067e\\u0648\\u0626\\u062a<\\/em><\\/strong><\\/p>\"},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#ffffff\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/simple-text/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("34", "0", "یک پیاده روی", "[\"standard\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/take_a_hike\\/header.jpg\",\"alt\":\"header\",\"fullWidth\":true,\"width\":\"1320px\",\"height\":\"483px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p>Hi&nbsp;[subscriber:firstname | default:explorer]<\\/p>\\n                      <p><\\/p>\\n                      <p>Aliquam feugiat nisl eget eleifend congue. Nullam neque tellus, elementum vel elit dictum, tempus sagittis nunc. Phasellus quis commodo odio. Vestibulum vitae mi vel quam rhoncus egestas eget vitae eros.&nbsp;<\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#843c15\",\"height\":\"40px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h1><strong>How to plan your hiking route<\\/strong><\\/h1>\\n                      <p>Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Aliquam dictum urna ac lacus dapibus rhoncus.<\\/p>\"},{\"type\":\"button\",\"text\":\"Read More\",\"url\":\"https:\\/\\/www.google.co.uk\",\"styles\":{\"block\":{\"backgroundColor\":\"#64a1af\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"150px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/take_a_hike\\/map.jpg\",\"alt\":\"map\",\"fullWidth\":false,\"width\":\"330px\",\"height\":\"227px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#843c15\",\"height\":\"40px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/take_a_hike\\/boots.jpg\",\"alt\":\"boots\",\"fullWidth\":false,\"width\":\"600px\",\"height\":\"400px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2><strong>Tried &amp; tested: Our favourite walking boots<\\/strong><\\/h2>\\n                        <p>Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.&nbsp;<\\/p>\"},{\"type\":\"button\",\"text\":\"See Reviews\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#64a1af\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"150px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#843c15\",\"height\":\"40px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><strong>Hikers Gallery<\\/strong><\\/h3>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/take_a_hike\\/gallery3.jpg\",\"alt\":\"gallery3\",\"fullWidth\":true,\"width\":\"1000px\",\"height\":\"750px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/take_a_hike\\/gallery1-300x225.jpg\",\"alt\":\"gallery1\",\"fullWidth\":true,\"width\":\"300px\",\"height\":\"225px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/take_a_hike\\/gallery2-1.jpg\",\"alt\":\"gallery2\",\"fullWidth\":true,\"width\":\"1000px\",\"height\":\"750px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Edit this to insert text<\\/p>\"},{\"type\":\"button\",\"text\":\"View More Photos\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#64a1af\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"214px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#843c15\",\"height\":\"40px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><strong>Hiking goes social...<\\/strong><\\/h3>\"},{\"type\":\"social\",\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"google-plus\",\"link\":\"http:\\/\\/plus.google.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Google-Plus.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Google Plus\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"}]},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#843c15\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#64a1af\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#64a1af\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"13px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"underline\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"footer\",\"text\":\"<p>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"13px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#64a1af\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#4f230c\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#423c39\",\"fontFamily\":\"Courier New\",\"fontSize\":\"24px\"},\"h2\":{\"fontColor\":\"#265f6d\",\"fontFamily\":\"Courier New\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#423c39\",\"fontFamily\":\"Courier New\",\"fontSize\":\"20px\"},\"link\":{\"fontColor\":\"#843c15\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#843c15\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/take_a_hike/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("35", "0", "روز اخبار", "[\"standard\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#f2f2f2\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/news_day\\/News-Outlet-Title-2.jpg\",\"alt\":\"News-Outlet-Title-2\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"700px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: left;\\\"><span style=\\\"color: #2ca5d2;\\\"><strong>Top Story<\\/strong><\\/span><\\/h1>\"},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: left;\\\"><strong>Plasma jet engines that could take you from the ground to space<\\/strong><\\/h2>\"},{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/plasma-jet-engines-that-could-take-you-from-the-ground-to-space\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/news_day\\/plasma-stingray111-800x533.jpg\",\"alt\":\"Plasma jet engines that could take you from the ground to space\",\"fullWidth\":false,\"width\":\"413.28125px\",\"height\":440,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p class=\\\"mailpoet_wp_post\\\">FORGET fuel-powered jet engines. We\\u2019re on the verge of having aircraft that can fly from the ground up to the edge of space using air and electricity alone. Traditional jet engines create thrust by mixing compressed air with fuel and igniting it. The burning mixture expands rapidly and is blasted out of the back of the engine, pushing it forwards. &hellip;<\\/p><p><a href=\\\"http:\\/\\/mailpoet.info\\/plasma-jet-engines-that-could-take-you-from-the-ground-to-space\\/\\\">Read More<\\/a><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h3><span style=\\\"color: #2ca5d2;\\\"><strong>Popular Posts Today<\\/strong><\\/span><\\/h3>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left; font-size: 18px; line-height: 1.4;\\\"><strong>Cutting through the smog: What to do to fight air pollution<\\/strong><\\/h3>\\n                      <p class=\\\"mailpoet_wp_post\\\">Tackling our air problems starts with traffic control, but individual action to reduce energy use and intensive farming would also help clean our air.<\\/p>\\n                      <p><a href=\\\"http:\\/\\/mailpoet.info\\/cutting-through-the-smog-what-to-do-to-fight-air-pollution\\/\\\">Read More<\\/a><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left; font-size: 18px; line-height: 1.4;\\\"><strong>Ladybird&rsquo;s transparent shell reveals how it&nbsp;moves<\\/strong><\\/h3>\\n                      <p class=\\\"mailpoet_wp_post\\\">They certainly know how to fold. A see-through artificial wing case has been used to watch for the first time as ladybirds put away their wings after flight.<\\/p>\\n                      <p><a href=\\\"http:\\/\\/mailpoet.info\\/ladybirds-transparent-shell-reveals-how-it-folds-its-wings\\/\\\">Read More<\\/a><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left; font-size: 18px; line-height: 1.4;\\\"><strong>Brazil&rsquo;s history-making Hurricane<\\/strong><\\/h3>\\n                      <p class=\\\"mailpoet_wp_post\\\">Jairzinho has just made history. In claiming the fourth goal of an unforgettable 1970 FIFA World Cup Mexico&trade; Final against Italy, he has maintained his record of scoring in every one of Brazil&rsquo;s matches en route to the Trophy.<\\/p>\\n                      <p><a href=\\\"http:\\/\\/mailpoet.info\\/brazils-history-making-hurricane\\/\\\">Read More<\\/a><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left; font-size: 18px; line-height: 1.4;\\\"><strong>Iceland&rsquo;s dentist-coach defying convention and expectations<\\/strong><\\/h3>\\n                      <p class=\\\"mailpoet_wp_post\\\">As Iceland&rsquo;s key matches loom, with kick-off just a couple of hours away, you will find their national coach in the pub. This may seem unusual...<\\/p>\\n                      <p><a href=\\\"http:\\/\\/mailpoet.info\\/icelands-dentist-coach-defying-convention-and-expectations\\/\\\">Read More<\\/a><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left; font-size: 18px; line-height: 1.4;\\\"><strong>Impact and legacy of 2018 FIFA World Cup Russia<\\/strong><\\/h3>\\n                      <p class=\\\"mailpoet_wp_post\\\">Organising a FIFA World Cup&trade; in a sustainable manner is a major challenge. The scale of the event inevitably has an impact on the Host Country.&nbsp;<\\/p>\\n                      <p><a href=\\\"http:\\/\\/mailpoet.info\\/impact-and-legacy-of-2018-fifa-world-cup-russia-facts-and-figures\\/\\\">Read More<\\/a><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left; font-size: 18px; line-height: 1.4;\\\"><strong>Lineker&rsquo;s life-changing treble<\\/strong><\\/h3>\\n                      <p class=\\\"mailpoet_wp_post\\\">Given that he won the Golden Boot in his first and came within a whisker of the Final in his second, one might expect Gary Lineker to have a tough time picking his FIFA World Cup&trade; highlight. Yet the man who scored ten times...<\\/p>\\n                      <p><a href=\\\"http:\\/\\/mailpoet.info\\/linekers-life-changing-treble\\/\\\">Read More<\\/a><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#f2f2f2\",\"height\":\"40px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"footer\",\"text\":\"<p><strong>NewsDay<\\/strong><\\/p>\\n                      <p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/><br \\/><\\/p>\\n                      <p><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"social\",\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"linkedin\",\"link\":\"http:\\/\\/www.linkedin.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/LinkedIn.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"LinkedIn\"}]},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#f2f2f2\",\"height\":\"40px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"13px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#2ca5d2\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#f2f2f2\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Button\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/news_day/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("36", "0", "جام جهانی", "[\"standard\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/Sports-Football-Header.png\",\"alt\":\"Sports-Football-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"220px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/Sports-Football-Divider-1.png\",\"alt\":\"Sports-Football-Divider-1\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#da6110\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p><strong><span style=\\\"color: #ffffff; font-size: 14px;\\\">Issue #1<\\/span><\\/strong><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: right;\\\"><a href=\\\"[link:newsletter_view_in_browser_url]\\\" target=\\\"_blank\\\" style=\\\"color: #ffffff; font-size: 14px; text-align: center;\\\">View In Browser<\\/a><\\/p>\\n                                        <p style=\\\"text-align: right;\\\"><span style=\\\"color: #ffffff; text-align: start;\\\">Monday 1st January 2017<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#da6110\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/Sports-Football-Header-1.png\",\"alt\":\"Sports-Football-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"580px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: left;\\\"><strong>Welcome Back!<\\/strong><\\/h2>\\n                                      <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam consequat lorem at est congue, non consequat lacus iaculis. Integer euismod mauris velit, vel ultrices nibh bibendum quis. Donec eget fermentum magna.<\\/p>\\n                                      <p><\\/p>\\n                                      <p>Nullam congue dui lectus, quis pellentesque orci placerat eu. Fusce semper neque a mi aliquet vulputate sed sit amet nisi. Etiam sed nisl nec orci pretium lacinia eget in turpis. Maecenas in posuere justo. Vestibulum et sapien vestibulum, imperdiet neque in, maximus velit.<\\/p>\\n                                      <p><\\/p>\\n                                      <p>Proin dignissim elit magna, viverra scelerisque libero vehicula sed<\\/p>\"},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/Sports-Football-Divider-3.png\",\"alt\":\"Sports-Football-Divider-3\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#efefef\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#efefef\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"padding-bottom: 0;\\\"><span style=\\\"font-weight: 600;\\\">Latest News<\\/span><\\/h2>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"View All News\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#d35400\",\"borderColor\":\"#d35400\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"110px\",\"lineHeight\":\"36px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"right\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#efefef\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#efefef\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/brazils-history-making-hurricane\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/2865897_full-lnd.jpg\",\"alt\":\"Brazil\\u2019s history-making Hurricane\",\"fullWidth\":false,\"width\":652,\"height\":366,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong>Brazil&rsquo;s history-making Hurricane<\\/strong><\\/h3>\\n                                            <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam consequat lorem at est congue, non consequat lacus iaculis. Integer euismod mauris velit, vel ultrices nibh bibendum quis. Donec eget fermentum magna. Nullam congue dui lectus, quis pellentesque orci placerat eu. Fusce semper neque a mi aliquet vulputate sed sit amet nisi...<\\/p>\\n                                            <p><a href=\\\"http:\\/\\/mailpoet.info\\/brazils-history-making-hurricane\\/\\\">Read More<\\/a><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#efefef\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/icelands-dentist-coach-defying-convention-and-expectations\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/2866107_full-lnd.jpg\",\"alt\":\"Iceland\\u2019s dentist-coach defying convention and expectations\",\"fullWidth\":false,\"width\":652,\"height\":366,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3><strong>Iceland&rsquo;s dentist-coach defying convention and expectations<\\/strong><\\/h3>\\n                                          <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam consequat lorem at est congue, non consequat lacus iaculis. Integer euismod mauris velit...<\\/p>\\n                                          <p><a href=\\\"http:\\/\\/mailpoet.info\\/icelands-dentist-coach-defying-convention-and-expectations\\/\\\">Read More<\\/a><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/impact-and-legacy-of-2018-fifa-world-cup-russia-facts-and-figures\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/2709222_full-lnd.jpg\",\"alt\":\"Impact and legacy of 2018 FIFA World Cup Russia: facts and figures\",\"fullWidth\":false,\"width\":652,\"height\":366,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong>Impact and legacy of 2018 FIFA World Cup Russia: facts and figures<\\/strong><\\/h3>\\n                                        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam consequat lorem at est congue, non consequat lacus iaculis. Integer euismod...<\\/p>\\n                                        <p><a href=\\\"http:\\/\\/mailpoet.info\\/impact-and-legacy-of-2018-fifa-world-cup-russia-facts-and-figures\\/\\\">Read More<\\/a><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/linekers-life-changing-treble\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/2867790_full-lnd.jpg\",\"alt\":\"Lineker\\u2019s life-changing treble\",\"fullWidth\":false,\"width\":652,\"height\":366,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong>Lineker&rsquo;s life-changing treble<\\/strong><\\/h3>\\n                                      <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam consequat lorem at est congue, non consequat lacus iaculis. Integer euismod mauris velit&nbsp;<span style=\\\"background-color: inherit;\\\">consequat lorem at est congue...<\\/span><\\/p>\\n                                      <p><a href=\\\"http:\\/\\/mailpoet.info\\/linekers-life-changing-treble\\/\\\">Read More<\\/a><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#efefef\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/Sports-Football-Divider-2.png\",\"alt\":\"Sports-Football-Divider-2\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/Sports-Football-Footer-1.png\",\"alt\":\"Sports-Football-Footer\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#da6110\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#da6110\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#b55311\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#da6110\",\"height\":\"20px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/world_cup\\/Sports-Football-Logo-Small.png\",\"alt\":\"Sports-Football-Logo-Small\",\"fullWidth\":false,\"width\":\"772px\",\"height\":\"171px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#da6110\",\"height\":\"20px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"underline\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#da6110\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#da6110\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#222222\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/world_cup/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("37", "0", "رویداد جشنواره", "[\"standard\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#0a5388\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/festival_event\\/festival-header.jpg\",\"alt\":\"festival-header\",\"fullWidth\":true,\"width\":\"1320px\",\"height\":\"879px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"36px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\">Pack your glowsticks, <br \\/>Boomfest is back!&nbsp;<\\/h1>\\n                        <p><\\/p>\\n                        <p style=\\\"text-align: center;\\\">Duis tempor nisl in risus hendrerit venenatis. <br \\/>Curabitur ornare venenatis nisl non ullamcorper. <\\/p>\"},{\"type\":\"button\",\"text\":\"Duis id tincidunt\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#0a5388\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"260px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Maecenas scelerisque nisi sit amet metus efficitur dapibus!&nbsp;<br \\/>Ut eros risus, facilisis ac aliquet vel, posuere ut urna.<\\/p>\"},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#ffffff\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"28px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\">Confirmed Lineup<\\/h2>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3><em><span style=\\\"color: #bae2ff;\\\">Main Stage<\\/span><\\/em><\\/h3><p>Quisque libero<br \\/>Nulla convallis<br \\/>Vestibulum Ornare<br \\/>Consectetur Odio<\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3><em><span style=\\\"color: #bae2ff;\\\">New Acts Stage<\\/span><\\/em><\\/h3><p>Nulla interdum<br \\/>Massa nec<br \\/>Pharetra<br \\/>Varius<\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3><em><span style=\\\"color: #bae2ff;\\\">Comedy Stage<\\/span><\\/em><\\/h3><p>In pulvinar<br \\/>Risus sed<br \\/>Condimentum<br \\/>Feugiat<\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#ffffff\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\">New to the festival this year<\\/h2>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"9px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#ffffff\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/festival_event\\/street-food.jpg\",\"alt\":\"street food\",\"fullWidth\":true,\"width\":\"499px\",\"height\":\"750px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h3>Award-winning Street Food<\\/h3><p>Nullam pharetra lectus id porta pulvinar. Proin ac massa nibh. Nullam ac mi pharetra, lobortis nunc et, placerat leo. Mauris eu feugiat elit. Pellentesque eget turpis eu diam vehicula convallis non <a href=\\\"http:\\/\\/www.mailpoet.com\\\">luctus enim.<\\/a><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/festival_event\\/happy.jpeg\",\"alt\":\"happy\",\"fullWidth\":true,\"width\":\"499px\",\"height\":\"750px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h3>Prepare to&nbsp;dazzle with our Glitter Run<\\/h3><p>Donec quis orci at metus finibus tincidunt. Sed vel urna sed urna maximus congue eu et turpis. Nulla tempus hendrerit justo eget molestie. Vivamus quis molestie lacus. Donec commodo odio a nisi feugiat, vitae egestas mi.<\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#ffffff\"}}},{\"type\":\"footer\",\"text\":\"<p>Mauris tristique ultricies ullamcorper. <br \\/>Don\'t want to hear from us?&nbsp;<a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a><\\/p><p><\\/p><p>Add your postal address here.&nbsp;<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"13px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"underline\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Georgia\",\"fontSize\":\"36px\"},\"h2\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Georgia\",\"fontSize\":\"26px\"},\"h3\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Georgia\",\"fontSize\":\"24px\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#8d062b\"},\"body\":{\"backgroundColor\":\"#0a5388\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/festival_event/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("38", "0", "Retro Computing Magazine", "[\"standard\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#4473a1\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#008282\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/retro_computing_magazine\\/Windows94-Header.png\",\"alt\":\"Windows94-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"740px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<p><span style=\\\"color: #ffffff;\\\"><a href=\\\"[link:newsletter_view_in_browser_url]\\\" style=\\\"color: #ffffff;\\\">View this in your browser.<\\/a><\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"#008282\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Courier New\",\"fontSize\":\"12px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: left;\\\"><strong>We\'re upgrading!<\\/strong><\\/h1>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. In elementum nunc vel est congue, a venenatis nunc aliquet. Curabitur luctus, nulla et dignissim elementum, ipsum eros fermentum nulla, non cursus eros mi eu velit. Nunc ex nibh, porta vulputate pharetra ac, placerat sed orci. Etiam enim enim, aliquet nec ligula in, ultrices iaculis dolor. Suspendisse potenti. Praesent fringilla augue ut lorem mattis, vitae fringilla nunc faucibus. <\\/span><\\/p>\\n<p><span><\\/span><\\/p>\\n<p><span>Quisque in leo felis. Etiam at libero et enim tincidunt scelerisque. Ut felis lectus, imperdiet quis justo quis, elementum sagittis tellus. Sed elementum, lacus at iaculis vestibulum, nunc leo gravida nisi, sed dapibus nisi odio ac ex. Aliquam id arcu dictum, cursus quam id, eleifend libero.<\\/span><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"ridge\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h1><strong>Latest News<\\/strong><\\/h1>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong>What is it like to use a Windows 98 PC in 2017?<\\/strong><\\/h3>\"},{\"type\":\"text\",\"text\":\"<p class=\\\"mailpoet_wp_post\\\"><span>Computers are much more advanced than they were even a few years ago, but of course we all like to complain about the dumb things they sometimes do. It&rsquo;s easy to forget how clunky things used to be, though...<\\/span><\\/p>\\n<p><a href=\\\"http:\\/\\/mailpoet.info\\/odds-on-10-science-breakthroughs-you-can-bet-on\\/\\\">Read more<\\/a><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong>Windows 95 still finds life online<\\/strong><\\/h3>\"},{\"type\":\"text\",\"text\":\"<p class=\\\"mailpoet_wp_post\\\">Microsoft&rsquo;s Windows 95 has reached the ripe old age of 22 this year and to commemorate this milestone, TheNextWeb goes into some details about the operating system that users may have missed over the years...<\\/p>\\n<p><a href=\\\"http:\\/\\/mailpoet.info\\/brazils-history-making-hurricane\\/\\\">Read more<\\/a><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong>New Sinclair ZX Spectrum Fully Funded<\\/strong><\\/h3>\"},{\"type\":\"text\",\"text\":\"<p class=\\\"mailpoet_wp_post\\\">The new Sinclair ZX Spectrum Next home computer which was launched on Kickstarter to mark the 35th birthday of the original Spectrum produced by Sinclair Research has been fully funded in less than 48 hours...<\\/p>\\n<p><a href=\\\"http:\\/\\/mailpoet.info\\/cutting-through-the-smog-what-to-do-to-fight-air-pollution\\/\\\">Read more<\\/a><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#008282\",\"height\":\"50px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#008282\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2><strong><span style=\\\"color: #ffffff;\\\">Did you know?<\\/span><\\/strong><\\/h2>\\n<p><span style=\\\"color: #ffffff;\\\">At the time of creation and development, the microcomputers in Japan were not powerful enough to handle the complex tasks related to the design and programming of Space Invaders. Nishikado then designed his own hardware and developmental tools to make the game a reality.<\\/span><\\/p>\\n<p><strong><span style=\\\"color: #ffffff;\\\"><\\/span><\\/strong><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/retro_computing_magazine\\/Windows94-Today.png\",\"alt\":\"Windows94-Today\",\"fullWidth\":false,\"width\":\"364px\",\"height\":\"291px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#008282\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><strong>Let\'s get social!<\\/strong><\\/p>\"},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png?mailpoet_version=3.0.0-rc.1.0.4\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png?mailpoet_version=3.0.0-rc.1.0.4\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Youtube.png?mailpoet_version=3.0.0-rc.1.0.4\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Email.png?mailpoet_version=3.0.0-rc.1.0.4\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"}]},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Courier New\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#008282\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Courier New\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Courier New\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Courier New\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Courier New\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#008282\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#008282\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/retro_computing_magazine/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("39", "0", "کفشها", "[\"standard\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f6f6f6\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/shoes\\/Retail-Shoes-Logo.png\",\"alt\":\"Retail-Shoes-Logo\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"220px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/shoes\\/Retail-Shoes-Header.jpg\",\"alt\":\"Retail-Shoes-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"700px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f1b512\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #614a0d;\\\">Our New Range<\\/span><\\/h2>\\n                      <p style=\\\"text-align: center;\\\"><span style=\\\"color: #614a0d;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque cursus aliquam urna, non ultricies diam sagittis sit amet. Etiam tempus a metus sed tincidunt.<\\/span><\\/p>\\n                      <p style=\\\"text-align: center;\\\"><span style=\\\"color: #614a0d;\\\">Curabitur fermentum ligula eget lacus aliquam volutpat. Integer sapien neque, laoreet quis lobortis sed, semper eget magna. Suspendisse potentiu.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Find Out More\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#41c7bf\",\"borderColor\":\"#28a9a2\",\"borderWidth\":\"2px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"160px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#36b0a9\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"70px\"}}},{\"type\":\"text\",\"text\":\"<h2><span style=\\\"color: #ffffff;\\\">Handcrafted Shoes<\\/span><\\/h2>\\n                       <p style=\\\"font-size: 14px;\\\"><span><span style=\\\"color: #ffffff;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque cursus aliquam urna, non ultricies diam sagittis sit amet. Etiam tempus a metus sed tincidunt. Curabitur fermentum ligula eget lacus aliquam volutpat.<\\/span><\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/shoes\\/Retail-Shoes-Boxes-1.jpg\",\"alt\":\"Retail-Shoes-Boxes-1\",\"fullWidth\":true,\"width\":\"700px\",\"height\":\"700px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#36b0a9\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/shoes\\/Retail-Shoes-Boxes-2.jpg\",\"alt\":\"Retail-Shoes-Boxes-2\",\"fullWidth\":true,\"width\":\"700px\",\"height\":\"700px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"70px\"}}},{\"type\":\"text\",\"text\":\"<h2><span style=\\\"color: #ffffff;\\\">Perfect For Any Occasion<\\/span><\\/h2>\\n                      <p style=\\\"font-size: 14px;\\\"><span><span style=\\\"color: #ffffff;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque cursus aliquam urna, non ultricies diam sagittis sit amet. Etiam tempus a metus sed tincidunt. Curabitur fermentum ligula eget lacus aliquam volutpat.<\\/span><\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f6f6f6\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><strong>We\'re open every day!<\\/strong><\\/h3>\\n                        <p style=\\\"text-align: center;\\\">Call in any time and we\'ll help you pick the best shoes for any occasion.<\\/p>\\n                        <p style=\\\"text-align: center;\\\">If you\'re not happy, just bring them back to us and we\'ll give you a full refund.<\\/p>\"},{\"type\":\"button\",\"text\":\"Check Out Our Website\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#41c7bf\",\"borderColor\":\"#28a9a2\",\"borderWidth\":\"2px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"220px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"2px\",\"borderColor\":\"#d3d3d3\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f6f6f6\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/shoes\\/Retail-Shoes-Logo-Footer.png\",\"alt\":\"Retail-Shoes-Logo-Footer\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"60px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 12px;\\\"><span style=\\\"color: #999999;\\\">Address Line 1<\\/span><\\/p>\\n                      <p style=\\\"text-align: center; font-size: 12px;\\\"><span style=\\\"color: #999999;\\\">Address Line 2<\\/span><\\/p>\\n                      <p style=\\\"text-align: center; font-size: 12px;\\\"><span style=\\\"color: #999999;\\\">City<\\/span><\\/p>\\n                      <p style=\\\"text-align: center; font-size: 12px;\\\"><span style=\\\"color: #999999;\\\">Country<\\/span><\\/p>\"},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f6f6f6\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#41c7bf\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#f6f6f6\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/shoes/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("40", "0", "Music", "[\"standard\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#2d2d2d\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/music\\/Music-Logo.png\",\"alt\":\"Music-Logo\",\"fullWidth\":false,\"width\":\"496px\",\"height\":\"78px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/music\\/music-header.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"70px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><span style=\\\"color: #393939;\\\"><strong>You Play.<\\/strong><\\/span><\\/h1>\\n<h1 style=\\\"text-align: center;\\\"><span style=\\\"color: #393939;\\\"><strong>They Listen.<\\/strong><\\/span><\\/h1>\"},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #878787;\\\">Up to 50% off all of our instruments.<\\/span><\\/h2>\\n<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #878787;\\\">This week only.<\\/span><\\/h2>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"176px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>Choose a category and get playing<\\/strong><\\/h2>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Electric Guitars\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#2d2d2d\",\"borderWidth\":\"3px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"189px\",\"lineHeight\":\"50px\",\"fontColor\":\"#2d2d2d\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Trumpets\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#2d2d2d\",\"borderWidth\":\"3px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"189px\",\"lineHeight\":\"50px\",\"fontColor\":\"#2d2d2d\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"DJ Equipment\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#2d2d2d\",\"borderWidth\":\"3px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"189px\",\"lineHeight\":\"50px\",\"fontColor\":\"#2d2d2d\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Amps\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#2d2d2d\",\"borderWidth\":\"3px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"189px\",\"lineHeight\":\"50px\",\"fontColor\":\"#2d2d2d\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Drums\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#2d2d2d\",\"borderWidth\":\"3px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"189px\",\"lineHeight\":\"50px\",\"fontColor\":\"#2d2d2d\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Pianos\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#2d2d2d\",\"borderWidth\":\"3px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"189px\",\"lineHeight\":\"50px\",\"fontColor\":\"#2d2d2d\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Banjos\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#2d2d2d\",\"borderWidth\":\"3px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"189px\",\"lineHeight\":\"50px\",\"fontColor\":\"#2d2d2d\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Synthesizers\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#2d2d2d\",\"borderWidth\":\"3px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"189px\",\"lineHeight\":\"50px\",\"fontColor\":\"#2d2d2d\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Guitar Pedals\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#2d2d2d\",\"borderWidth\":\"3px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"189px\",\"lineHeight\":\"50px\",\"fontColor\":\"#2d2d2d\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Harmonicas\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#2d2d2d\",\"borderWidth\":\"3px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"189px\",\"lineHeight\":\"50px\",\"fontColor\":\"#2d2d2d\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Flutes\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#2d2d2d\",\"borderWidth\":\"3px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"189px\",\"lineHeight\":\"50px\",\"fontColor\":\"#2d2d2d\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Headphones\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#2d2d2d\",\"borderWidth\":\"3px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"189px\",\"lineHeight\":\"50px\",\"fontColor\":\"#2d2d2d\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#2d2d2d\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#2d2d2d\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/music\\/Music-Logo.png\",\"alt\":\"Music-Logo\",\"fullWidth\":false,\"width\":\"496px\",\"height\":\"78px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"}]},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 11px;\\\"><span style=\\\"color: #999999;\\\"><em><strong><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #999999;\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a><\\/strong><\\/em><\\/span><\\/p>\\n<p style=\\\"text-align: center; font-size: 11px;\\\"><span style=\\\"color: #999999;\\\"><em><strong><a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #999999;\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/strong><\\/em><\\/span><br \\/><span style=\\\"color: #999999;\\\">\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/span><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"36px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#2d2d2d\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#2d2d2d\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Button\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"176px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/music/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("41", "0", "Hotels", "[\"standard\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#2d2a31\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/hotels\\/Hotel-Logo-1.png\",\"alt\":\"Hotel-Logo\",\"fullWidth\":false,\"width\":\"554px\",\"height\":\"200px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\"><strong>My Favourites<\\/strong><\\/span><\\/h3>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\"><strong>Recent Bookings<\\/strong><\\/span><\\/h3>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/hotels\\/Hotel-Header.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h1><span style=\\\"color: #ffffff;\\\"><strong>Pets go free<\\/strong><\\/span><\\/h1>\"},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: left;\\\"><span style=\\\"color: #ffffff;\\\">Stay in any Exquisite hotel this summer and bring your pet for free!<\\/span><\\/h2>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"button\",\"text\":\"Find Out More\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffc600\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"46px\",\"fontColor\":\"#3f3f3f\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: left;\\\"><strong>Get ready to travel in Exquiste style...<\\/strong><\\/h2>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. In elementum nunc vel est congue, a venenatis nunc aliquet. Curabitur luctus, nulla et dignissim elementum, ipsum eros fermentum nulla, non cursus eros mi eu velit. Nunc ex nibh, porta vulputate pharetra ac, placerat sed orci. Etiam enim enim, aliquet nec ligula in, ultrices iaculis dolor. Suspendisse potenti. Praesent fringilla augue ut lorem mattis, vitae fringilla nunc faucibus.<\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/hotels\\/dubai-paris.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"181px\"}}},{\"type\":\"text\",\"text\":\"<h1><span style=\\\"color: #ffffff;\\\"><strong>Dubai<\\/strong><\\/span><\\/h1>\\n<h2><span style=\\\"color: #ffffff;\\\">From $199<strong><br \\/><\\/strong><\\/span><\\/h2>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"181px\"}}},{\"type\":\"text\",\"text\":\"<h1><strong><span style=\\\"color: #ffffff;\\\">Paris<\\/span><\\/strong><\\/h1>\\n<h2><span style=\\\"color: #ffffff;\\\">From $149<\\/span><\\/h2>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/hotels\\/toronto-delhi.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"181px\"}}},{\"type\":\"text\",\"text\":\"<h1><span style=\\\"color: #ffffff;\\\"><strong>Toronto<\\/strong><\\/span><\\/h1>\\n<h2><span style=\\\"color: #ffffff;\\\">From $229<\\/span><\\/h2>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"181px\"}}},{\"type\":\"text\",\"text\":\"<h1><span style=\\\"color: #ffffff;\\\"><strong>New Delhi<\\/strong><\\/span><\\/h1>\\n<h2><span style=\\\"color: #ffffff;\\\">From $149<\\/span><\\/h2>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/hotels\\/rio-london.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"181px\"}}},{\"type\":\"text\",\"text\":\"<h1><span style=\\\"color: #ffffff;\\\"><strong>Rio de Janeiro<\\/strong><\\/span><\\/h1>\\n<h2><span style=\\\"color: #ffffff;\\\">From $329<\\/span><\\/h2>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"181px\"}}},{\"type\":\"text\",\"text\":\"<h1><span style=\\\"color: #ffffff;\\\"><strong>London<\\/strong><\\/span><\\/h1>\\n<h2><span style=\\\"color: #ffffff;\\\">From $99<\\/span><\\/h2>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffc600\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>Just for you...<\\/strong><\\/h2>\\n<p style=\\\"text-align: center;\\\">Here\'s 10% off your next booking with us.<\\/p>\\n<p style=\\\"text-align: center;\\\">Just grab the code below and paste it when required on the booking form!<\\/p>\"},{\"type\":\"button\",\"text\":\"VALU3DCUST\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffc600\",\"borderColor\":\"#000000\",\"borderWidth\":\"2px\",\"borderRadius\":\"6px\",\"borderStyle\":\"solid\",\"width\":\"219px\",\"lineHeight\":\"40px\",\"fontColor\":\"#000000\",\"fontFamily\":\"Courier New\",\"fontSize\":\"30px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#2d2a31\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#2d2a31\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/hotels\\/Hotel-Logo-Small.png\",\"alt\":\"Hotel-Logo-Small\",\"fullWidth\":true,\"width\":\"554px\",\"height\":\"200px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#2d2a31\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\"><strong>Address Line 1 <\\/strong><\\/span><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\"><strong>Address Line 2 <\\/strong><\\/span><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\"><strong>City <\\/strong><\\/span><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\"><strong>Country<\\/strong><\\/span><\\/p>\"},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #ffc600;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #ffc600;\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #ffc600;\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/span><br \\/><span style=\\\"color: #ffffff;\\\">\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"40px\"},\"h2\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\"},\"h3\":{\"fontColor\":\"#2d2a31\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#008282\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#2d2a31\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Find Out More\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffc600\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"46px\",\"fontColor\":\"#3f3f3f\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"181px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/hotels/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("42", "0", "تکه ای از کیک", "[\"standard\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<p><strong>Open daily from 9am to 9pm |&nbsp;<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/strong><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"#ececeb\"},\"text\":{\"fontColor\":\"#606060\",\"fontFamily\":\"Arial\",\"fontSize\":\"13px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#d42b2b\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/piece_of_cake\\/Restaurant-Bakery-Logo-1.png\",\"alt\":\"Restaurant-Bakery-Logo-1\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"180px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/piece_of_cake\\/Restaurant-Bakery-Header.jpg\",\"alt\":\"Restaurant-Bakery-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"1600px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>It\'s our Birthday!<\\/strong><\\/h1>\"},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center; line-height: 1.4;\\\">To celebrate, we\'re adding a slice of our Birthday cake to every order. Pop in this weekend to use our special offer code and enjoy!<\\/h3>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; border: 3px dashed #d42b2b; color: #d42b2b; padding: 10px; font-size: 24px;\\\"><strong>HAPPYBDAY<\\/strong><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"50px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ececeb\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ececeb\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"background-color: #ececeb; line-height: 1.3;\\\"><span style=\\\"font-weight: 600;\\\"><span style=\\\"font-size: 12px; text-align: center;\\\">Add your postal address here.<\\/span><\\/span><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"social\",\"iconSet\":\"full-symbol-color\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: right; line-height: 1.3;\\\"><strong><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #d42b2b; text-decoration: none; font-size: 12px; text-align: center;\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a><\\/strong><\\/p>\\n                      <p style=\\\"text-align: right; line-height: 1.3;\\\"><strong><a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #d42b2b; text-decoration: none; font-size: 12px; text-align: center;\\\">Manage&nbsp;Subscription<\\/a><\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ececeb\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#606060\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#606060\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#d42b2b\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#606060\",\"fontFamily\":\"Arial\",\"fontSize\":\"20px\"},\"link\":{\"fontColor\":\"#d42b2b\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#ececeb\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/piece_of_cake/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("43", "0", "Buddhist Temple", "[\"standard\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/buddhist-temple\\/Buddhist-Header.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#00050b\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"header\",\"text\":\"<p><a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"11px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#787878\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"80px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/buddhist-temple\\/Buddhist-Logo.png\",\"alt\":\"Buddhist-Logo\",\"fullWidth\":false,\"width\":\"170px\",\"height\":\"99px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}},{\"type\":\"text\",\"text\":\"<h1>With our thoughts, we make the <span style=\\\"color: #f37f31;\\\">world<\\/span><\\/h1>\\n    <p><span style=\\\"color: #dedede;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sed semper ipsum. Vestibulum finibus sapien in enim ultricies, vel placerat risus lacinia.<\\/span><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"24.5px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#f37f31\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/buddhist-temple\\/Buddhist-Avatar.jpg\",\"alt\":\"Buddhist-Avatar\",\"fullWidth\":false,\"width\":\"70px\",\"height\":\"400px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}},{\"type\":\"text\",\"text\":\"<p><span style=\\\"color: #999999;\\\">Special Event<\\/span><\\/p>\\n    <h3>Dalai Lama visit<\\/h3>\\n    <p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sed semper ipsum.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Book tickets here\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f37f31\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"145px\",\"lineHeight\":\"35px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#f37f31\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<h3><span style=\\\"color: #f37f31;\\\">New prayer flags<\\/span><\\/h3>\\n    <p><span style=\\\"color: #dedede;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sed semper ipsum. Vestibulum finibus sapien in enim ultricies, vel placerat risus lacinia.<\\/span><\\/p>\\n    <p><a href=\\\"http:\\/\\/a9d.fc4.mwp.accessdomain.com\\\">Find out more &gt;<\\/a><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/buddhist-temple\\/5bafccfc554c7f08176ec084.png\",\"alt\":\"5bafccfc554c7f08176ec084\",\"fullWidth\":false,\"width\":\"280px\",\"height\":\"524px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":\"1_2\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/buddhist-temple\\/Buddhist-Social.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f37f31\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"45px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"90px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Sharing matters to us<\\/span><\\/h3>\\n    <p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sed semper ipsum. Vestibulum finibus sapien in enim ultricies, vel placerat risus lacinia.<\\/span><\\/p>\"},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Website.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"45px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"50px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/buddhist-temple\\/Buddhist-Images-1.jpg\",\"alt\":\"Buddhist-Images-1\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"600px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3><span style=\\\"color: #dedede;\\\">Meditation for beginners<\\/span><\\/h3>\\n    <p><span style=\\\"color: #dedede;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sed semper ipsum.<\\/span>&nbsp;<\\/span><\\/p>\\n    <p><a href=\\\"http:\\/\\/a9d.fc4.mwp.accessdomain.com\\\">Find out more &gt;<\\/a><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/buddhist-temple\\/Buddhist-Images-2.jpg\",\"alt\":\"Buddhist-Images-2\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"600px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3><span style=\\\"color: #dedede;\\\">Planning your trip to a temple<\\/span><\\/h3>\\n    <p><span style=\\\"color: #dedede;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sed semper ipsum.<\\/span>&nbsp;<\\/span><\\/p>\\n    <p><a href=\\\"http:\\/\\/a9d.fc4.mwp.accessdomain.com\\\">Find out more &gt;<\\/a><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/buddhist-temple\\/Buddhist-Images-3.jpg\",\"alt\":\"Buddhist-Images-3\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"600px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3><span style=\\\"color: #dedede;\\\">Visit the sunken statues<\\/span><\\/h3>\\n    <p><span style=\\\"color: #dedede;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam sed semper ipsum.<\\/span>&nbsp;<\\/span><\\/p>\\n    <p><a href=\\\"http:\\/\\/a9d.fc4.mwp.accessdomain.com\\\">Find out more &gt;<\\/a><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#f37f31\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/buddhist-temple\\/Buddhist-Logo.png\",\"alt\":\"Buddhist-Logo\",\"fullWidth\":false,\"width\":\"170px\",\"height\":\"99px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#f37f31\",\"textDecoration\":\"underline\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#eeeeee\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#eeeeee\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#eeeeee\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#eeeeee\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#f37f31\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#00050b\"},\"body\":{\"backgroundColor\":\"#00050b\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Book tickets here\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f37f31\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"145px\",\"lineHeight\":\"35px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#f37f31\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#f37f31\",\"textDecoration\":\"underline\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Website.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"11px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#787878\",\"textDecoration\":\"none\"}},\"type\":\"header\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/buddhist-temple/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("44", "0", "Mosque", "[\"standard\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e3e3e3\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#009146\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<p><a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"10px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"none\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/mosque\\/Mosque-Header.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#333333\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"100px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/mosque\\/Mosque-Logo.png\",\"alt\":\"Mosque-Logo\",\"fullWidth\":false,\"width\":\"182px\",\"height\":\"119px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #999999;\\\"><strong>JANUARY 2019<\\/strong><\\/span><\\/p>\\n    <h1 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Newsletter<\\/span><\\/h1>\\n    <p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc scelerisque ut purus vel eleifend. Curabitur mollis nisi id mauris efficitur pretium.<\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"90px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #009146;\\\"><strong>Upcoming Events<\\/strong><\\/span><\\/h2>\"}]}]},{\"type\":\"container\",\"columnLayout\":\"1_2\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/mosque\\/Mosque-Images-1.jpg\",\"alt\":\"Mosque-Images-1\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"600px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: left;\\\"><span style=\\\"color: #999999;\\\"><strong>14th&nbsp;January 2019<\\/strong><\\/span><\\/p>\\n    <h3 style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\"><span>The Four Imams<\\/span><\\/span><\\/h3>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc scelerisque ut purus vel eleifend. Curabitur mollis nisi id mauris.<\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><strong><a href=\\\"\\\">Find out more &gt;<\\/a><\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":\"1_2\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/mosque\\/Mosque-Images-2.jpg\",\"alt\":\"Mosque-Images-2\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"600px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: left;\\\"><span style=\\\"color: #999999;\\\"><strong>23rd&nbsp;January 2019<\\/strong><\\/span><\\/p>\\n    <h3 style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\"><span>Prayer Makes Perfect<\\/span><\\/span><\\/h3>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc scelerisque ut purus vel eleifend. Curabitur mollis nisi id mauris.<\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\"><strong><a href=\\\"\\\">Find out more &gt;<\\/a><\\/strong><\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":\"1_2\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/mosque\\/Mosque-Images-3.jpg\",\"alt\":\"Mosque-Images-3\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"600px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: left;\\\"><span style=\\\"color: #999999;\\\"><strong>29th&nbsp;January 2019<\\/strong><\\/span><\\/p>\\n    <h3 style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\"><span>Plaster Carving<\\/span><\\/span><\\/h3>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc scelerisque ut purus vel eleifend. Curabitur mollis nisi id mauris.<\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\"><strong><a href=\\\"http:\\/\\/a9d.fc4.mwp.accessdomain.com\\\">Find out more &gt;<\\/a><\\/strong><\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#009146\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"5.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#009146\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #009146;\\\"><strong>Prayer Times<\\/strong><\\/span><\\/h2>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong><\\/strong><strong>Fajr<\\/strong><\\/h2>\"},{\"type\":\"button\",\"text\":\"7.04pm\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#009146\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>Sunrise<\\/strong><\\/h2>\"},{\"type\":\"button\",\"text\":\"8.41am\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#009146\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>Dhuhr<\\/strong><\\/h2>\"},{\"type\":\"button\",\"text\":\"12.35pm\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#009146\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>Asr<\\/strong><\\/h2>\"},{\"type\":\"button\",\"text\":\"2.01pm\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#009146\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>Maghrib<\\/strong><\\/h2>\"},{\"type\":\"button\",\"text\":\"4.21pm\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#009146\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>Isha\'a<\\/strong><\\/h2>\"},{\"type\":\"button\",\"text\":\"5.58pm\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#009146\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/mosque\\/bg-2.jpg\",\"alt\":\"bg-2\",\"fullWidth\":false,\"width\":\"1200px\",\"height\":\"286px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#009146\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"24px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/mosque\\/Mosque-Logo.png\",\"alt\":\"Mosque-Logo\",\"fullWidth\":false,\"width\":\"144px\",\"height\":\"119px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e3e3e3\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"29px\"}}},{\"type\":\"social\",\"iconSet\":\"circles\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"11px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#009146\",\"textDecoration\":\"underline\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"13px\"},\"h1\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#009146\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#e3e3e3\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"5.58pm\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#009146\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"5.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#009146\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"11px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#009146\",\"textDecoration\":\"underline\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"29px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"10px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"none\"}},\"type\":\"header\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/mosque/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("45", "0", "Synagogue", "[\"standard\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#2b3d5e\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"header\",\"text\":\"<p><a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#7386a7\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#384e76\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#04aeb9\",\"padding\":\"7.5px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#0d7e85\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":\"1_2\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#384e76\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/synagogue\\/Synagogue-Logo.png\",\"alt\":\"Synagogue-Logo\",\"fullWidth\":false,\"width\":\"180px\",\"height\":\"208px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"27px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"columnLayout\":\"1_2\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/synagogue\\/Synagogue-Header-2.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#384e76\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"140px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"44px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: left;\\\"><span style=\\\"color: #ffffff;\\\">Welcome&nbsp;back<\\/span><\\/h1>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #ffffff;\\\">This month we\'ll be discussing important topics around our faith, and highlighting some events that you may be interested in.<\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"38px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: left;\\\"><span style=\\\"color: #04aeb9;\\\"><strong><span>S P E C I A L&nbsp; E V E N T<\\/span><\\/strong><\\/span><\\/p>\\n    <h3 style=\\\"text-align: left;\\\"><span style=\\\"color: #ffffff;\\\">Stories In Song<\\/span><\\/h3>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #ffffff;\\\">An afternoon of comedy and music with Daniel Cainer. This multi-award-winning master-songwriter and great musician brings our family trees to life.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Tickets available here\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#04aeb9\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"175px\",\"lineHeight\":\"38px\",\"fontColor\":\"#093c3f\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"43px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":\"1_2\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/synagogue\\/Synagogue-Back-1.jpg\",\"display\":\"tile\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/synagogue\\/male-18.jpg\",\"alt\":\"male-18\",\"fullWidth\":false,\"width\":\"150px\",\"height\":\"360px\",\"styles\":{\"block\":{\"textAlign\":\"right\"}}},{\"type\":\"text\",\"text\":\"<p class=\\\"font_2\\\" style=\\\"text-align: right;\\\"><span style=\\\"color: #384e76;\\\"><strong>Ariel Abel<\\/strong><\\/span><\\/p>\\n    <p class=\\\"font_2\\\" style=\\\"font-size: 11px; text-align: right;\\\"><span style=\\\"color: #384e76;\\\">Princes Road Synagogue&nbsp;<span>Rabbi&nbsp;<\\/span><\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Get in touch\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#04aeb9\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"90px\",\"lineHeight\":\"30px\",\"fontColor\":\"#093c3f\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"fontWeight\":\"bold\",\"textAlign\":\"right\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: left;\\\"><span style=\\\"color: #384e76;\\\">Greetings from our Rabbi&nbsp;<\\/span><\\/h2>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #384e76;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed pellentesque magna erat, vitae ultricies eros porttitor eleifend. Fusce luctus accumsan risus, at rhoncus ante vehicula in. Praesent ut ultricies ipsum. Sed lacus dolor, laoreet nec tincidunt ut, commodo nec augue. In dignissim justo eget ante facilisis ornare.<\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #384e76;\\\"><\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #384e76;\\\"><span>Cras in lacus ac lectus hendrerit porta. Morbi pretium id nisi eget placerat. Integer nec quam nec augue luctus facilisis. Nam sollicitudin velit nec risus mattis, quis porttitor tortor consequat. Vivamus nec justo vel lectus pharetra volutpat.<\\/span><\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #384e76;\\\"><span><\\/span><\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #384e76;\\\"><span>Quisque eget vestibulum quam, eu fermentum ipsum.<\\/span><\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#384e76\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#04aeb9\",\"padding\":\"6.5px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#04aeb9\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #384e76;\\\">Latest News<\\/span><\\/h2>\\n    <p style=\\\"text-align: center;\\\"><span style=\\\"color: #384e76;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed pellentesque magna erat, vitae ultricies eros porttitor eleifend.<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/synagogue\\/Synagogue-Images-1.jpg\",\"alt\":\"Synagogue-Images-1\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><span style=\\\"color: #384e76;\\\">Building work started this week<\\/span><\\/h3>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #384e76;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed pellentesque magna erat.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#04aeb9\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"81px\",\"lineHeight\":\"30px\",\"fontColor\":\"#093c3f\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/synagogue\\/Synagogue-Images-2.jpg\",\"alt\":\"Synagogue-Images-2\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><span style=\\\"color: #384e76;\\\">What\'s life like as a Jewish teenager?<\\/span><\\/h3>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #384e76;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed pellentesque magna erat.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#04aeb9\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"81px\",\"lineHeight\":\"30px\",\"fontColor\":\"#093c3f\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/synagogue\\/Synagogue-Images-3.jpg\",\"alt\":\"Synagogue-Images-3\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><span style=\\\"color: #384e76;\\\">The life of paper in a modern world<\\/span><\\/h3>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #384e76;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed pellentesque magna erat.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#04aeb9\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"81px\",\"lineHeight\":\"30px\",\"fontColor\":\"#093c3f\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#2b3d5e\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#04aeb9\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Keep in touch with us<\\/span><\\/h2>\\n    <p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed pellentesque magna erat, vitae ultricies eros porttitor eleifend.<\\/span><\\/p>\"},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"styles\":{\"block\":{\"textAlign\":\"center\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#2b3d5e\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":\"1_2\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#2b3d5e\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/synagogue\\/Synagogue-Logo.png\",\"alt\":\"Synagogue-Logo\",\"fullWidth\":false,\"width\":\"180px\",\"height\":\"208px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#04aeb9\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#2b3d5e\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"13px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#2b3d5e\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Get in touch\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#04aeb9\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"90px\",\"lineHeight\":\"30px\",\"fontColor\":\"#093c3f\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"fontWeight\":\"bold\",\"textAlign\":\"right\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"#04aeb9\",\"padding\":\"6.5px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#04aeb9\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#04aeb9\",\"textDecoration\":\"underline\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#7386a7\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/synagogue/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("46", "0", "باور", "[\"standard\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/faith\\/church-header.jpg\",\"alt\":\"church-header\",\"fullWidth\":true,\"width\":\"1036px\",\"height\":\"563px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\">Spreading Love &amp; Hope...<\\/h1><p>Duis id molestie ex. Quisque finibus magna in justo tristique pellentesque. Nulla sed leo facilisis arcu malesuada molestie vel quis dolor. Donec imperdiet condimentum odio ut elementum. Aenean nisl massa, rutrum a ullamcorper eget, molestie non erat.&nbsp;<\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f3f4f4\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: left;\\\">Family Faith Events<\\/h2>\"},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/faith\\/family.jpg\",\"alt\":\"family\",\"fullWidth\":false,\"width\":\"660px\",\"height\":\"880px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p>In maximus tempus pellentesque. Nunc scelerisque ante odio, vel placerat dui fermentum efficitur. Integer vitae ex suscipit, aliquet eros vitae, ornare est. <a href=\\\"http:\\/\\/www.example.com\\\">Aenean vel dapibus nisi<\\/a>.<\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2>Thoughts &amp; Prayers<\\/h2>\"},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/faith\\/pray.jpg\",\"alt\":\"pray\",\"fullWidth\":false,\"width\":\"660px\",\"height\":\"880px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p>Donec sed vulputate ipsum. In scelerisque rutrum interdum. Donec imperdiet dignissim erat, in dictum lectus accumsan ut. <a href=\\\"http:\\/\\/www.example.com\\\">Aliquam erat volutpat.<\\/a><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\">Latest News<\\/h1>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"1px\",\"borderColor\":\"#dcdcdc\"}}},{\"type\":\"automatedLatestContent\",\"amount\":\"3\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#dfeaf3\",\"borderColor\":\"#00ddff\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"160px\",\"lineHeight\":\"45px\",\"fontColor\":\"#597890\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"2px\",\"borderColor\":\"#dfeaf3\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#e7eff6\",\"padding\":\"13px\",\"borderStyle\":\"ridge\",\"borderWidth\":\"6px\",\"borderColor\":\"#597890\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#e7eff6\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"footer\",\"text\":\"<a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/><b>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/b>\",\"styles\":{\"block\":{\"backgroundColor\":\"#e7eff6\"},\"text\":{\"fontColor\":\"#787878\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"14px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#787878\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Find us socially:<\\/p>\"},{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Email.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Website.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"}]},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#787878\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#597890\",\"fontFamily\":\"Comic Sans MS\",\"fontSize\":\"26px\"},\"h2\":{\"fontColor\":\"#597890\",\"fontFamily\":\"Comic Sans MS\",\"fontSize\":\"18px\"},\"h3\":{\"fontColor\":\"#787878\",\"fontFamily\":\"Tahoma\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#597890\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#e7eff6\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/faith/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("47", "0", "College", "[\"standard\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#eeeeee\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#eeeeee\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/college\\/College-Logo.png\",\"alt\":\"College-Logo\",\"fullWidth\":false,\"width\":\"106px\",\"height\":\"652px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"36px\"}}},{\"type\":\"social\",\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png?mailpoet_version=3.15.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png?mailpoet_version=3.15.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Instagram.png?mailpoet_version=3.15.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Youtube.png?mailpoet_version=3.15.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"33px\"}}},{\"type\":\"header\",\"text\":\"<p><a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/college\\/College-Header.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#333333\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"60px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: left;\\\"><span style=\\\"color: #ffcc00;\\\"><strong>S U M M E R&nbsp; &nbsp;E D I T I O N<\\/strong><\\/span><\\/p>\\n    <h1 style=\\\"text-align: left;\\\"><span style=\\\"color: #ffffff;\\\">Graduation Day is Coming<\\/span><\\/h1>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"color: #ffffff;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce dapibus iaculis risus ut tincidunt. Integer gravida mauris erat, vehicula blandit velit ultrices ut.&nbsp;<\\/span><\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":\"2_1\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"54px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: left;\\\"><span style=\\\"color: #999999;\\\"><strong>H E A D M A S T E R \' S&nbsp; &nbsp;B L O G<\\/strong><\\/span><\\/p>\\n    <h2 style=\\\"text-align: left;\\\"><strong><span style=\\\"color: #333333;\\\">Your hard work pays off in the future to come<\\/span><\\/strong><\\/h2>\\n    <p><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"18.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"2px\",\"borderColor\":\"#ffcc00\"}}},{\"type\":\"text\",\"text\":\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur purus quam, semper eget nisl at, pretium fermentum ligula. Ut augue elit, congue non nisl eget, venenatis ornare ante. Aliquam erat volutpat. Maecenas facilisis eget risus vel scelerisque.<\\/p>\\n    <p><\\/p>\\n    <p>Etiam eros arcu, vestibulum at iaculis ut, iaculis nec est. Ut ut malesuada purus. Etiam sed accumsan eros, eu aliquam nisl. Nam faucibus sit amet felis at euismod. Sed efficitur varius tincidunt. Curabitur varius, nunc id interdum sodales, felis purus congue nulla, at semper orci est id mauris. Ut euismod vel dui sed mollis. Aliquam vestibulum id leo eu tristique. Etiam sit amet lacus vitae mi dignissim iaculis id ac nulla.<\\/p>\\n    <p><\\/p>\"},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/college\\/College-Image.jpg\",\"alt\":\"College-Image\",\"fullWidth\":false,\"width\":\"1200px\",\"height\":\"800px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p><\\/p>\\n    <p>Praesent mi lorem, varius sit amet mattis at, sollicitudin ac enim. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam rhoncus tellus eleifend, accumsan magna in, imperdiet mauris. Cras a justo in lectus semper fermentum. Integer porta vel risus a varius. Aliquam nec nulla dui. Nulla congue ornare fringilla.<\\/p>\\n    <p><\\/p>\\n    <p>Nulla gravida interdum velit, nec pretium lacus placerat vel. Curabitur vitae arcu condimentum, iaculis nisl ac, viverra augue.<\\/p>\\n    <p><\\/p>\\n    <p>Etiam tincidunt justo quam, ac suscipit lectus hendrerit ac.<\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/college\\/College-Avatar.jpg\",\"alt\":\"College-Avatar\",\"fullWidth\":true,\"width\":\"500px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p><\\/p>\\n    <p><\\/p>\\n    <p><strong>Mr George Chalk<\\/strong><\\/p>\\n    <p>Headmaster &amp; Director<\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"44px\"}}},{\"type\":\"text\",\"text\":\"<p><strong>Need some tips and advice?&nbsp;<\\/strong><\\/p>\\n    <p>Here\'s the latest updates from our blog:<\\/p>\\n    <p><\\/p>\\n    <p><a href=\\\"http:\\/\\/mailpoet-sg.com\\\">7 ways to destress before an exam even starts<\\/a><\\/p>\\n    <p><\\/p>\\n    <p><a href=\\\"http:\\/\\/mailpoet-sg.com\\\">Focussing on the right content is key to being successful<\\/a><\\/p>\\n    <p><\\/p>\\n    <p><a href=\\\"http:\\/\\/mailpoet-sg.com\\\">Getting a degree is only the start of the battle<\\/a><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":\"2_1\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#eeeeee\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}},{\"type\":\"social\",\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png?mailpoet_version=3.15.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png?mailpoet_version=3.15.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Instagram.png?mailpoet_version=3.15.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Youtube.png?mailpoet_version=3.15.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"}]},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffcc00;\\\"><strong><\\/strong><\\/span><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a><span>&nbsp;|&nbsp;<\\/span><a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/><span>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/span><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/college\\/College-Logo.png\",\"alt\":\"College-Logo\",\"fullWidth\":false,\"width\":\"106px\",\"height\":\"652px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Source Sans Pro\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Playfair Display\",\"fontSize\":\"40px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Playfair Display\",\"fontSize\":\"30px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Open Sans\",\"fontSize\":\"24px\"},\"link\":{\"fontColor\":\"#447c9d\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Button\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"18.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"2px\",\"borderColor\":\"#ffcc00\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/college/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("48", "0", "Renewable Energy", "[\"standard\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#313f58\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"header\",\"text\":\"<p><span style=\\\"color: #fdb323;\\\"><a href=\\\"[link:newsletter_view_in_browser_url]\\\" style=\\\"color: #fdb323;\\\">View in browser &gt;<\\/a><\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#016fc1\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/renewable-energy\\/Energy-Logo.png\",\"alt\":\"Energy-Logo\",\"fullWidth\":false,\"width\":\"200px\",\"height\":\"145px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"36px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png?mailpoet_version=3.15.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png?mailpoet_version=3.15.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"linkedin\",\"link\":\"http:\\/\\/www.linkedin.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/LinkedIn.png?mailpoet_version=3.15.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"LinkedIn\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/renewable-energy\\/Energy-Header.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong><span style=\\\"color: #ffffff;\\\">2018 Energy Report<\\/span><\\/strong><\\/h1>\\n    <p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse maximus purus vel sem rutrum pulvinar. Pellentesque at justo id ipsum porttitor viverra non porta nisl.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Read it here\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#fdb323\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"135px\",\"lineHeight\":\"44px\",\"fontColor\":\"#2e2e2e\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"16px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"197px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #999999;\\\"><strong>R E C E N T<\\/strong><\\/span><\\/p>\\n    <h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #003366;\\\"><strong>Here\'s what\'s happening this week<\\/strong><\\/span><\\/h2>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/renewable-energy\\/Energy-Image-1.jpg\",\"alt\":\"Energy-Image-1\",\"fullWidth\":false,\"width\":\"600px\",\"height\":\"400px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3><span style=\\\"color: #003366;\\\"><strong>How can electricity be better?<\\/strong><\\/span><\\/h3>\"},{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#fdb323\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"100px\",\"lineHeight\":\"30px\",\"fontColor\":\"#2e2e2e\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/renewable-energy\\/Energy-Image-2.jpg\",\"alt\":\"Energy-Image-2\",\"fullWidth\":false,\"width\":\"600px\",\"height\":\"400px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3><span style=\\\"color: #003366;\\\"><strong>Nuclear power for newcomers<\\/strong><\\/span><\\/h3>\"},{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#fdb323\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"100px\",\"lineHeight\":\"30px\",\"fontColor\":\"#2e2e2e\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/renewable-energy\\/Energy-Image-3.jpg\",\"alt\":\"Energy-Image-3\",\"fullWidth\":false,\"width\":\"600px\",\"height\":\"400px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3><span style=\\\"color: #003366;\\\"><strong>Saving the planet, one trip at a time<\\/strong><\\/span><\\/h3>\"},{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#fdb323\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"100px\",\"lineHeight\":\"30px\",\"fontColor\":\"#2e2e2e\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":\"1_2\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/renewable-energy\\/Energy-Image-Tall.jpg\",\"alt\":\"Energy-Image-Tall\",\"fullWidth\":true,\"width\":\"600px\",\"height\":\"900px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: left;\\\"><span style=\\\"color: #999999;\\\"><strong>S P O N S O R E D<\\/strong><\\/span><\\/p>\\n    <h2><span style=\\\"color: #003366;\\\"><strong>Control your heating and your spending with our amazing app<\\/strong><\\/span><\\/h2>\\n    <p><span style=\\\"color: #003366;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse maximus purus vel sem rutrum pulvinar.&nbsp;<\\/span><\\/p>\"},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/renewable-energy\\/CityNews-GoogleDownload.png\",\"alt\":\"CityNews-GoogleDownload\",\"fullWidth\":false,\"width\":\"130px\",\"height\":\"168px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/renewable-energy\\/CityNews-AppleDownload.png\",\"alt\":\"CityNews-AppleDownload\",\"fullWidth\":false,\"width\":\"130px\",\"height\":\"168px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#313f58\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/renewable-energy\\/Energy-Logo.png\",\"alt\":\"Energy-Logo\",\"fullWidth\":true,\"width\":\"134px\",\"height\":\"145px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png?mailpoet_version=3.15.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png?mailpoet_version=3.15.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"linkedin\",\"link\":\"http:\\/\\/www.linkedin.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/LinkedIn.png?mailpoet_version=3.15.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"LinkedIn\"}]},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #fdb323;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #fdb323;\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a>&nbsp;|&nbsp;<a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #fdb323;\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/span><br \\/><span style=\\\"color: #999999;\\\">\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/span><\\/p>\"}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"36px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#2ea1cd\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#313f58\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Read more\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#fdb323\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"100px\",\"lineHeight\":\"30px\",\"fontColor\":\"#2e2e2e\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"linkedin\",\"link\":\"http:\\/\\/www.linkedin.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/LinkedIn.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"LinkedIn\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/renewable-energy/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("49", "0", "Primary School", "[\"standard\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#cae7f2\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"header\",\"text\":\"<p><strong><a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/strong><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#e63729\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/primary-school\\/PrimarySchool-Header.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/primary-school\\/PrimarySchool-Logo.png\",\"alt\":\"PrimarySchool-Logo\",\"fullWidth\":false,\"width\":\"120px\",\"height\":\"652px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"33px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e63729\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><strong><span style=\\\"color: #ffffff;\\\"><a href=\\\"http:\\/\\/mailpoet-sg.com\\\" style=\\\"color: #ffffff;\\\">News &amp; Events<\\/a><\\/span><\\/strong><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><strong><span style=\\\"color: #ffffff;\\\"><a href=\\\"http:\\/\\/mailpoet-sg.com\\\" style=\\\"color: #ffffff;\\\">Parent Information<\\/a><\\/span><\\/strong><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><strong><span style=\\\"color: #ffffff;\\\"><a href=\\\"http:\\/\\/mailpoet-sg.com\\\" style=\\\"color: #ffffff;\\\">Scho<\\/a><a href=\\\"http:\\/\\/mailpoet-sg.com\\\" style=\\\"color: #ffffff;\\\">ol Calendar<\\/a><\\/span><\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/primary-school\\/PrimarySchool-WideImage-1.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#c23a3a\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"50px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong><span style=\\\"color: #ffffff;\\\">Welcome back everyone!<\\/span><\\/strong><\\/h1>\\n    <p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus ac orci neque. Sed hendrerit condimentum augue, sed porta nulla vulputate rutrum. Donec vel purus urna.<\\/span><\\/p>\"},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/primary-school\\/PrimarySchool-Avatar.png\",\"alt\":\"PrimarySchool-Avatar\",\"fullWidth\":false,\"width\":\"80px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><em><span style=\\\"color: #ffffff;\\\">Dr Angela Boyd - Director of Schooling<\\/span><\\/em><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":\"2_1\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\"><strong>The new school year is here<\\/strong><\\/span><\\/h1>\\n    <p style=\\\"text-align: left;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus ac orci neque. Sed hendrerit condimentum augue, sed porta nulla vulputate rutrum. Donec vel purus urna. <\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span><\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span>Sed dui sapien, congue non accumsan euismod, ultrices ut dui. Ut sapien arcu, interdum pharetra enim at, porttitor viverra nisi. Suspendisse potenti.&nbsp;<\\/span><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"4px\",\"borderColor\":\"#e63729\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/primary-school\\/PrimarySchool-CopyImage.jpg\",\"alt\":\"PrimarySchool-CopyImage\",\"fullWidth\":false,\"width\":\"1000px\",\"height\":\"583px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\"><strong>Essentials for your bag<\\/strong><\\/span><\\/h2>\\n    <p style=\\\"text-align: left;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus ac orci neque. Sed hendrerit condimentum augue, sed porta nulla vulputate rutrum. Donec vel purus urna. <\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Get the kit\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#e63729\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"90px\",\"lineHeight\":\"33px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/primary-school\\/PrimarySchool-School.png\",\"alt\":\"PrimarySchool-School\",\"fullWidth\":false,\"width\":\"150px\",\"height\":\"512px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"button\",\"text\":\"Class Lists\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#e63729\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"160px\",\"lineHeight\":\"38px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"button\",\"text\":\"Payments\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#43772f\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"160px\",\"lineHeight\":\"38px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"button\",\"text\":\"Schedule\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#408bb6\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"160px\",\"lineHeight\":\"38px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#e63729\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong><span style=\\\"color: #ffffff;\\\">Everything is social!<\\/span><\\/strong><\\/h1>\\n    <p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus ac orci neque. Sed hendrerit condimentum augue, sed porta nulla vulputate rutrum. Donec vel purus urna.<\\/span><\\/p>\"},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png?mailpoet_version=3.15.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png?mailpoet_version=3.15.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Youtube.png?mailpoet_version=3.15.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Website.png?mailpoet_version=3.15.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#cae7f2\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/primary-school\\/PrimarySchool-Logo.png\",\"alt\":\"PrimarySchool-Logo\",\"fullWidth\":false,\"width\":\"110px\",\"height\":\"652px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#e63729\",\"textDecoration\":\"underline\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#cae7f2\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Get the kit\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#e63729\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"90px\",\"lineHeight\":\"33px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"4px\",\"borderColor\":\"#e63729\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#e63729\",\"textDecoration\":\"underline\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Website.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#e63729\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/primary-school/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("50", "0", "Computer Repair", "[\"standard\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#1c00af\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #999999;\\\"><a href=\\\"[link:newsletter_view_in_browser_url]\\\" style=\\\"color: #999999;\\\">View this in your browser.<\\/a><\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#1c00af\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/computer-repair\\/ComputerRepair-Logo.png\",\"alt\":\"ComputerRepair-Logo\",\"fullWidth\":true,\"width\":\"408px\",\"height\":\"97px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"34px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#ffffff\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>TIRED OF SCREENS&nbsp;LIKE THIS?<\\/strong><\\/h1>\\n    <p style=\\\"text-align: center;\\\"><em>Don\'t panic!&nbsp;We\'re here to help! <\\/em><\\/p>\\n    <p style=\\\"text-align: center;\\\"><\\/p>\\n    <p style=\\\"text-align: center;\\\">Come on down to our nearest store and we\'ll be happy to take a look at your computer and help get you back up and running again in no time.<\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"14px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#ffffff\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><a href=\\\"http:\\/\\/mailpoet-sg.com\\/wp-admin\\/http:\\\">Computer Repair<\\/a><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><a href=\\\"http:\\/\\/mailpoet-sg.com\\/wp-admin\\/http:\\\">Help &amp; Support<\\/a><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><a href=\\\"http:\\/\\/mailpoet-sg.com\\/wp-admin\\/http:\\\">Call Us Now<\\/a><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/computer-repair\\/ComputerRepair-Image-2.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#1c00af\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"42px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>Check out our locations<\\/strong><\\/h2>\\n    <p style=\\\"text-align: center;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce dapibus iaculis risus ut tincidunt.<\\/p>\"},{\"type\":\"button\",\"text\":\"View locations\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"borderColor\":\"#f8f8f8\",\"borderWidth\":\"3px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"16px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"50px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/computer-repair\\/ComputerRepair-Logo.png\",\"alt\":\"ComputerRepair-Logo\",\"fullWidth\":true,\"width\":\"254px\",\"height\":\"97px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 12px;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a><span>&nbsp;|&nbsp;<\\/span><a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png?mailpoet_version=3.15.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png?mailpoet_version=3.15.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png?mailpoet_version=3.15.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Website.png?mailpoet_version=3.15.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"},{\"type\":\"socialIcon\",\"iconType\":\"linkedin\",\"link\":\"http:\\/\\/www.linkedin.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/LinkedIn.png?mailpoet_version=3.15.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"LinkedIn\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 12px;\\\">Add your address here<\\/p>\"}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#1c00af\"},\"body\":{\"backgroundColor\":\"#1c00af\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"View locations\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"borderColor\":\"#f8f8f8\",\"borderWidth\":\"3px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"16px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"16.5px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#ffffff\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Website.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"},{\"type\":\"socialIcon\",\"iconType\":\"linkedin\",\"link\":\"http:\\/\\/www.linkedin.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/LinkedIn.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"LinkedIn\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"50px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/computer-repair/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("51", "0", "استودیو یوگا", "[\"standard\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#1e2937\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/yoga_studio\\/yoga-1.png\",\"alt\":\"yoga-1\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"740px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>Here\'s your classes for this week:<\\/strong><\\/h2>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3><strong><span style=\\\"color: #83bd31;\\\"><em>Weekdays<\\/em><\\/span><\\/strong><\\/h3>\\n                      <p><strong>Monday<\\/strong>: 7am, 9am, 11am, 3pm and 5pm.<\\/p>\\n                      <p><strong>Tuesday<\\/strong>: 7am, 9am, 11am, 3pm and 5pm.<\\/p>\\n                      <p><strong>Wednesday<\\/strong>: 7am, 9am, 11am, 3pm and 5pm.<\\/p>\\n                      <p><strong>Thursday<\\/strong>:&nbsp;CLOSED FOR PRIVATE CLASS.<\\/p>\\n                      <p><strong>Friday<\\/strong>: 7am, 9am, 11am,&nbsp;and 3pm.<\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3><strong><span style=\\\"color: #83bd31;\\\"><em>Weekend<\\/em><\\/span><\\/strong><\\/h3>\\n                      <p><strong>Saturday<\\/strong>: 7am, 9am, 11am, 3pm and 5pm.<\\/p>\\n                      <p><strong>Sunday<\\/strong>: 7am, 9am, 11am, 3pm and 5pm.<\\/p>\\n                      <p><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"22px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#d5d5d5\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"font-weight: 600;\\\">Meet the instructors<\\/span><\\/h3>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/yoga_studio\\/yoga-person-1.png\",\"alt\":\"yoga-person-1\",\"fullWidth\":false,\"width\":\"400px\",\"height\":\"400px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #83bd31;\\\"><span style=\\\"font-weight: 600;\\\">Maria Smith<\\/span><\\/span><\\/h3>\\n                      <p style=\\\"text-align: center;\\\">Nullam hendrerit feugiat feugiat. Praesent mollis ante lacus, quis tempor leo sagittis vel. Donec sagittis eros at felis venenatis ultricies.<\\/p>\"},{\"type\":\"button\",\"text\":\"Find Out More\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#83bd31\",\"borderColor\":\"#83bd31\",\"borderWidth\":\"1px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"30px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/yoga_studio\\/yoga-person-2.png\",\"alt\":\"yoga-person-2\",\"fullWidth\":false,\"width\":\"400px\",\"height\":\"400px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #83bd31;\\\"><span style=\\\"font-weight: 600;\\\">Fiona&nbsp;Davies<\\/span><\\/span><\\/h3>\\n                      <p style=\\\"text-align: center;\\\">Nullam hendrerit feugiat feugiat. Praesent mollis ante lacus, quis tempor leo sagittis vel. Donec sagittis eros at felis venenatis ultricies.<\\/p>\"},{\"type\":\"button\",\"text\":\"Find Out More\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#83bd31\",\"borderColor\":\"#83bd31\",\"borderWidth\":\"1px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"30px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/yoga_studio\\/yoga-person-3.png\",\"alt\":\"yoga-person-3\",\"fullWidth\":false,\"width\":\"400px\",\"height\":\"400px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #83bd31;\\\"><span style=\\\"font-weight: 600;\\\">Matthew&nbsp;Johnson<\\/span><\\/span><\\/h3>\\n                       <p style=\\\"text-align: center;\\\">Nullam hendrerit feugiat feugiat. Praesent mollis ante lacus, quis tempor leo sagittis vel. Donec sagittis eros at felis venenatis ultricies.<\\/p>\"},{\"type\":\"button\",\"text\":\"Find Out More\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#83bd31\",\"borderColor\":\"#83bd31\",\"borderWidth\":\"1px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"31px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#83bd31\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<p><strong>Pose of the week:<\\/strong><\\/p>\\n                      <h2>Virabhadrasana I<\\/h2>\\n                      <p>The myth is that the powerful priest Daksha made a great yagna (ritual sacrifice) but did not invite his youngest daughter Sati and her husband Shiva, the supreme ruler of the universe. Sati found out and decided to go alone to the yagna.<\\/p>\\n                      <p><\\/p>\\n                      <p>When she arrived, Sati entered into an argument with her father. Unable to withstand his insults, she spoke a vow to her father, &ldquo;Since it was you who gave me this body, I no longer wish to be associated with it.&rdquo;<\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/yoga_studio\\/yoga-pose.png\",\"alt\":\"yoga-pose\",\"fullWidth\":false,\"width\":\"400px\",\"height\":\"400px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"font-weight: 600;\\\">Quote of the week<\\/span><\\/h3>\"},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><em>Be a lamp to yourself. Be your own confidence. Hold on to the truth within yourself as to the only truth.<\\/em><\\/h2>\\n                      <p style=\\\"text-align: center;\\\"><span style=\\\"font-family: Arial, sans-serif; font-size: 14px; text-align: center; color: #999999;\\\">Buddha<\\/span><em><\\/em><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#d5d5d5\",\"padding\":\"15px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#b3b3b3\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#d5d5d5\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/yoga_studio\\/yoga-logo-small.png\",\"alt\":\"yoga-logo-small\",\"fullWidth\":false,\"width\":\"50px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/pre-websites.ir\\/elementor\\/resume\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"}]}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"font-size: 13px; text-align: center;\\\"><strong>Yoga Studio<\\/strong><\\/p>\\n                      <p style=\\\"font-size: 11px; text-align: center;\\\">Address Line 1<\\/p>\\n                      <p style=\\\"font-size: 11px; text-align: center;\\\">Address Line 2<\\/p>\\n                      <p style=\\\"font-size: 11px; text-align: center;\\\">City\\/Town<\\/p>\\n                      <p style=\\\"font-size: 11px; text-align: center;\\\">Country<\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a><\\/p><p><a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"11px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#000000\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#d5d5d5\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#1e2937\",\"fontFamily\":\"Arial\",\"fontSize\":\"13px\"},\"h1\":{\"fontColor\":\"#1e2937\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#1e2937\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#1e2937\",\"fontFamily\":\"Arial\",\"fontSize\":\"20px\"},\"link\":{\"fontColor\":\"#83bd31\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#1e2937\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/yoga_studio/thumbnail.20190411-1500.jpg", "1", NULL, "2021-12-12 15:00:08");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("52", "0", "Retro", "[\"standard\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/retro\\/1980s-Header.jpg\",\"alt\":\"1980s-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"740px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: left;\\\"><strong>Welcome back !<\\/strong><\\/h2>\\n<p style=\\\"text-align: left;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim ve